/**
 *
 */
package control;

import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Logger;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import meta.MetaFactory;

import common.Environment;

/**
 *
 * @author 無糖ブラック
 *
 */
public class ChokomaroHttpServlet extends HttpServlet {

	@Override
	public void init() throws ServletException {
		super.init();

		try {
			Environment env = Environment.getEnvironment();
			Logger logger = env.getLogger();

			//ログサンプル
//			m_logger.finest("finest message");
//			m_logger.finer("finer message");
//			m_logger.fine("fine message");
//			m_logger.config("config message");
//			m_logger.info("info message");
//			m_logger.warning("warning message");
//			m_logger.severe("severe message");

			//基準パス取得
			String strBasePath = getServletContext().getRealPath("/");
			env.setParam("base_path", strBasePath);

			//ログ出力ディレクトリ取得/生成
			String strLogDir = getServletContext().getRealPath("/log/");
			File fileLogDir = new File(strLogDir);
			if ( !fileLogDir.exists() ) {
				fileLogDir.mkdir();
			}

			//ログ出力パス取得
			String strLogPath = getServletContext().getRealPath("/log/HttpServlet.log");
			env.setParam("log_path", strLogPath);

			//ログファイル出力設定
			FileHandler fhLog = new FileHandler(strLogPath, true);
			fhLog.setFormatter(new java.util.logging.SimpleFormatter());
			logger.addHandler(fhLog);

			//設定ファイル取得
			String envPath = getServletContext().getRealPath("/conf/env.ini");
			int result = env.init(envPath);
			if ( result < 0 ) {
				return;
			}

			String columnsMetaPath = getServletContext().getRealPath("/conf/columns.ini");
			String columnTypesMetaPath = getServletContext().getRealPath("/conf/columntypes.ini");
			MetaFactory metaFactory = MetaFactory.getMetaFactory();
			metaFactory.init("MetaColumn", columnsMetaPath, columnTypesMetaPath);
		} catch (IOException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		}
	}

	@Override
	public void destroy() {
		super.destroy();
	}

	@Override
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		String characterEncoding = "UTF-8";
		request.setCharacterEncoding(characterEncoding);

		String contentType = "text/html; charset=UTF-8";
		response.setContentType(contentType);
	}

	@Override
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		String characterEncoding = "UTF-8";
		request.setCharacterEncoding(characterEncoding);

		String contentType = "text/html; charset=UTF-8";
		response.setContentType(contentType);
	}
}
