package model;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;

import meta.ClassMetaColumn;
import meta.ClassMetaObject;
import meta.MetaColumn;
import meta.MetaFactory;
import objectModel.Account;
import objectModel.AccountPart;
import objectModel.AccountStructure;
import objectModel.Part;

import common.DBAccessWrapper;

/**
 *
 * @author 無糖ブラック
 *
 */
public class Entity extends ModelObject {

	public Entity() {
		super();
	}

	/**
	 *
	 * @param db
	 * @param keys
	 * @param values
	 * @throws IOException
	 */
	public Entity(DBAccessWrapper db, ArrayList<String> keys, ArrayList<String> values, String tableName) {
		super(db, keys,values, tableName);
	}

	/**
	 *
	 * @param account
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 * @throws IOException
	 */
	protected ArrayList<NavigationItem> navigate(String level, String strbTableNames[], String condition, ArrayList<String> inSortParams) throws SQLException, ClassNotFoundException, IOException {

		MetaFactory metaFactory = MetaFactory.getMetaFactory();
		ClassMetaObject classMetaObject = metaFactory.getClassMetaObject("MetaColumn");
		ClassMetaColumn classMetaColumn = (ClassMetaColumn)classMetaObject;

		ArrayList<String> selectParams = new ArrayList<String>();
		ArrayList<String> selectParams1 = new ArrayList<String>();
		ArrayList<String> selectParams2 = new ArrayList<String>();

		String delimiter = "";
		String strbTableName = "";
		for (int ii = 0; ii < strbTableNames.length; ++ii) {

			String alias = "T" + (ii+1);

			//SELECT
			ArrayList<MetaColumn> metaColumns = classMetaColumn.getMetaObjects(strbTableNames[ii]);
			for (int jj = 0; jj < metaColumns.size(); ++jj) {
				MetaColumn metaColumn = metaColumns.get(jj);
				String columnId = metaColumn.getProperty("COLUMN_ID");
				if (ii == 0) {
					selectParams1.add(columnId);
				}
				if (ii == 1) {
					selectParams2.add(columnId);
				}
				String selectParam = alias + "." + columnId + " AS " + strbTableNames[ii] + "_" + columnId;
				selectParams.add(selectParam);
			}

			//FROM
			strbTableName += delimiter;
			strbTableName += strbTableNames[ii];
			strbTableName += " ";
			strbTableName += alias;
			delimiter = ", ";
		}

		delimiter = "";
		StringBuffer sortCondition = new StringBuffer();
		sortCondition.append(condition);
		sortCondition.append(" ORDER BY ");
		if (inSortParams != null) {
			for( int ii = 0; ii < inSortParams.size(); ++ii ) {
				String sortParam = inSortParams.get(ii);
				for (int jj = 0; jj < strbTableNames.length; ++jj) {
					String regex = strbTableNames[jj] + "\\.";
					String replacement = "T" + (jj+1) + ".";
					sortParam = sortParam.replaceAll(regex, replacement);
				}
				sortCondition.append(delimiter);
				sortCondition.append(sortParam);
				delimiter = ", ";
			}
		}
		sortCondition.append(delimiter);
		sortCondition.append("T1.STRUCT_ORDER");

		ArrayList<NavigationItem> objects = navigate(level, strbTableNames[1], strbTableName, selectParams, selectParams1, selectParams2, sortCondition.toString());
		return objects;
	}

	/**
	 *
	 * @param account
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 * @throws IOException
	 */
	protected ArrayList<NavigationItem> navigate(String level, String targetObjectName, String strbTableName, ArrayList<String> selectParams, ArrayList<String> selectParams1, ArrayList<String> selectParams2, String condition) throws SQLException, ClassNotFoundException, IOException {

		ArrayList<String> conditionTypes = new ArrayList<String>();
		ArrayList<Object> conditionValues = new ArrayList<Object>();

		conditionTypes.add("int");
		conditionValues.add(identification());

		ArrayList<ArrayList<String>> rows = m_db.select(selectParams, strbTableName, condition.toString(), conditionTypes, conditionValues);
		ArrayList<NavigationItem> objects = new ArrayList<NavigationItem>();
		for (int ii = 0; ii < rows.size(); ++ii) {

			ArrayList<String> row = rows.get(ii);
			ArrayList<String> row1 = new ArrayList<String>();
			ArrayList<String> row2 = new ArrayList<String>();

			int index = 0;
			for (int jj = 0; jj < selectParams1.size(); ++jj, ++index) {
				row1.add(row.get(index));
			}
			for (int jj = 0; jj < selectParams2.size(); ++jj, ++index) {
				row2.add(row.get(index));
			}

			NavigationItem navigationItem = new NavigationItem();
			if ( targetObjectName.equals("ACCOUNT")) {
				AccountStructure object1 = new AccountStructure(m_db, selectParams1, row1);
				Account object2 = new Account(m_db, selectParams2, row2);
				navigationItem.source = this;
				navigationItem.relation = object1;
				navigationItem.destination = object2;
				objects.add(navigationItem);
				if ( level.equals("multi") ) {
					ArrayList<NavigationItem> objects2 = object2.navigate(level, targetObjectName, strbTableName, selectParams, selectParams1, selectParams2, condition);
					objects.addAll(objects2);
				}
			}
			else if ( targetObjectName.equals("PART")) {
				AccountPart object1 = new AccountPart(m_db, selectParams1, row1);
				Part object2 = new Part(m_db, selectParams2, row2);
				navigationItem.source = this;
				navigationItem.relation = object1;
				navigationItem.destination = object2;
				objects.add(navigationItem);
			}

		}

		return objects;
	}

}
