package objectModel;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;

import model.Entity;
import model.NavigationItem;

import common.DBAccessWrapper;

/**
 *
 * @author 無糖ブラック
 *
 */
public class Part extends Entity {

	/**
	 *
	 * @param db
	 * @param keys
	 * @param values
	 */
	public Part(DBAccessWrapper db, ArrayList<String> keys, ArrayList<String> values) {
		super(db, keys,values, "PART");
	}

	/**
	 *
	 * @return
	 */
	public String number() {
		return m_properties.get("PART_NUMBER");
	}

	/**
	 *
	 * @param number
	 */
	public void number(String number) {
		m_properties.put("PART_NUMBER", number);
	}

	/**
	 *
	 * @param account
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 * @throws IOException
	 */
	public ArrayList<NavigationItem> navigateAccount(ArrayList<String> inSortParams) throws SQLException, ClassNotFoundException, IOException {

		String strbTableNames[] = {"ACCOUNT_PART", "ACCOUNT"};

		StringBuilder condition = new StringBuilder();
		condition.append("T1.RIGHT_IDENTIFICATION = ? AND T1.LEFT_IDENTIFICATION = T2.IDENTIFICATION");

		ArrayList<NavigationItem> objects = navigate("", strbTableNames, condition.toString(), inSortParams);
		return objects;
	}

	/**
	 *
	 * @param inSortParams
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 * @throws IOException
	 */
	public ArrayList<NavigationItem> navigatePartner(ArrayList<String> inSortParams) throws SQLException, ClassNotFoundException, IOException {

		String strbTableNames[] = {"PARTNER_PART", "PARTNER"};

		StringBuilder condition = new StringBuilder();
		condition.append("T1.RIGHT_IDENTIFICATION = ? AND T1.LEFT_IDENTIFICATION = T2.IDENTIFICATION");

		ArrayList<NavigationItem> objects = navigate("", strbTableNames, condition.toString(), inSortParams);
		return objects;
	}

	/**
	 *
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 * @throws IOException
	 */
	public int delete() throws SQLException, ClassNotFoundException, IOException {

		int result = 0;
		String deleteCondition = "";
		ArrayList<String> conditionTypes = new ArrayList<String>();
		ArrayList<Object> conditionValues = new ArrayList<Object>();

		//account_part削除
		deleteCondition = "right_identification = ?";
		conditionTypes.clear();
		conditionTypes.add("int");
		conditionValues.clear();
		conditionValues.add(identification());
		result = m_db.delete("ACCOUNT_PART", deleteCondition, conditionTypes, conditionValues);
		if ( result < 0 ) {
			return result;
		}

		//partner_part削除
		deleteCondition = "right_identification = ?";
		conditionTypes.clear();
		conditionTypes.add("int");
		conditionValues.clear();
		conditionValues.add(identification());
		result = m_db.delete("PARTNER_PART", deleteCondition, conditionTypes, conditionValues);
		if ( result < 0 ) {
			return result;
		}

		//part削除
		return super.delete();
	}
}
