package systemModel;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;

import model.Entity;
import model.NavigationItem;

import common.DBAccessWrapper;

/**
 *
 * @author 無糖ブラック
 *
 */
public class Department extends Entity {

	/**
	 *
	 * @param db
	 * @param keys
	 * @param values
	 */
	public Department(DBAccessWrapper db, ArrayList<String> keys, ArrayList<String> values) {
		super(db, keys,values, "DEPARTMENT");
	}

	/**
	 *
	 * @return
	 */
	public String number() {
		return m_properties.get("DEPARTMENT_NUMBER");
	}

	/**
	 *
	 * @param number
	 */
	public void number(String number) {
		m_properties.put("DEPARTMENT_NUMBER", number);
	}

	/**
	 *
	 * @param inSortParams
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 * @throws IOException
	 */
	public ArrayList<NavigationItem> navigatePerson(ArrayList<String> inSortParams) throws SQLException, ClassNotFoundException, IOException {

		String strbTableNames[] = {"DEPARTMENT_PERSON", "PERSON"};

		StringBuilder condition = new StringBuilder();
		condition.append("T1.LEFT_IDENTIFICATION = ? AND T1.RIGHT_IDENTIFICATION = T2.IDENTIFICATION");

		ArrayList<NavigationItem> objects = navigate("", strbTableNames, condition.toString(), inSortParams);
		return objects;
	}

	/**
	 *
	 * @param person
	 * @throws IOException
	 * @throws ClassNotFoundException
	 * @throws SQLException
	 */
	public DepartmentPerson assignPerson(Person person, String userid) throws SQLException, ClassNotFoundException, IOException {

		ClassDepartmentPerson clsDepartmentPerson = new ClassDepartmentPerson(m_db);

		DepartmentPerson departmentPerson = clsDepartmentPerson.create(this, person);

		return departmentPerson;


	}
}
