/*
 * JHPdf Free PDF Library : SlideShowDemo.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * original demo/line_demo.c in 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

import java.lang.Math;

import net.sf.jhpdf.*;
import net.sf.jhpdf.graphics.HPdfRect;
import net.sf.jhpdf.pdfobject.*;
import net.sf.jhpdf.pdfobject.HPdfCatalog.HPdfPageMode;
import net.sf.jhpdf.pdfobject.HPdfPage.HPdfTransitionStyle;
import net.sf.jhpdf.pdfobject.annotation.HPdfLinkAnnotation;
import net.sf.jhpdf.pdfobject.annotation.HPdfLinkAnnotation.HPdfHighlightMode;


public class SlideShowDemo  implements DemoEntry {
    public static void main(String[] args) {
        new SlideShowDemo().demo(args);
    }
    
    private static final String F_NAME = "SlideShowDemo.pdf";
    
    @Override
    public void demo(String[] args) {
        
        HPdfDocument pdf = null;
        try {
            pdf = JHPdf.createDocument();
            
            /* create default-font */
            HPdfFont font = pdf.getFont("Courier", null);
            
            /* Set page mode to use outlines. */
            pdf.setPageMode(HPdfPageMode.USE_OUTLINE);
            
            /* Add 17 pages to the document. */
            HPdfPage[] page = new HPdfPage[17];
            for (int i = 0; i < page.length; ++i) {
                page[i] = pdf.addPage();
            }
            
            printPage(page[0], "HPDF_TS_WIPE_RIGHT", font, 
                    HPdfTransitionStyle.WIPE_RIGHT, null, page[1]);
            printPage(page[1], "HPDF_TS_WIPE_UP", font, 
                    HPdfTransitionStyle.WIPE_UP, page[0], page[2]);
            printPage(page[2], "HPDF_TS_WIPE_LEFT", font, 
                    HPdfTransitionStyle.WIPE_LEFT, page[1], page[3]);
            printPage(page[3], "HPDF_TS_WIPE_DOWN", font, 
                    HPdfTransitionStyle.WIPE_DOWN, page[2], page[4]);
            printPage(page[4], "HPDF_TS_BARN_DOORS_HORIZONTAL_OUT", font, 
                    HPdfTransitionStyle.BARN_DOORS_HORIZONTAL_OUT, page[3], page[5]);
            printPage(page[5], "HPDF_TS_BARN_DOORS_HORIZONTAL_IN", font, 
                    HPdfTransitionStyle.BARN_DOORS_HORIZONTAL_IN, page[4], page[6]);
            printPage(page[6], "HPDF_TS_BARN_DOORS_VERTICAL_OUT", font, 
                    HPdfTransitionStyle.BARN_DOORS_VERTICAL_OUT, page[5], page[7]);
            printPage(page[7], "HPDF_TS_BARN_DOORS_VERTICAL_IN", font, 
                    HPdfTransitionStyle.BARN_DOORS_VERTICAL_IN, page[6], page[8]);
            printPage(page[8], "HPDF_TS_BOX_OUT", font, 
                    HPdfTransitionStyle.BOX_OUT, page[7], page[9]);
            printPage(page[9], "HPDF_TS_BOX_IN", font, 
                    HPdfTransitionStyle.BOX_IN, page[8], page[10]);
            printPage(page[10], "HPDF_TS_BLINDS_HORIZONTAL", font, 
                    HPdfTransitionStyle.BLINDS_HORIZONTAL, page[9], page[11]);
            printPage(page[11], "HPDF_TS_BLINDS_VERTICAL", font, 
                    HPdfTransitionStyle.BLINDS_VERTICAL, page[10], page[12]);
            printPage(page[12], "HPDF_TS_DISSOLVE", font, 
                    HPdfTransitionStyle.DISSOLVE, page[11], page[13]);
            printPage(page[13], "HPDF_TS_GLITTER_RIGHT", font, 
                    HPdfTransitionStyle.GLITTER_RIGHT, page[12], page[14]);
            printPage(page[14], "HPDF_TS_GLITTER_DOWN", font, 
                    HPdfTransitionStyle.GLITTER_DOWN, page[13], page[15]);
            printPage(page[15], "HPDF_TS_GLITTER_TOP_LEFT_TO_BOTTOM_RIGHT", font, 
                    HPdfTransitionStyle.GLITTER_TOP_LEFT_TO_BOTTOM_RIGHT, page[14], page[16]);
            printPage(page[16], "HPDF_TS_REPLACE", font, 
                    HPdfTransitionStyle.REPLACE, page[15], null);

            pdf.setPageMode (HPdfPageMode.FULL_SCREEN);
            
            /* save the document to a file */
            pdf.saveToFile(F_NAME);
            
        } catch (HPdfException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (pdf != null) {
                pdf.freeDocAll();
            }
        }
    }
    
    private void printPage(HPdfPage page, String caption, HPdfFont font, 
        HPdfTransitionStyle style, HPdfPage prev, HPdfPage next)
    {
        page.setWidth(800);
        page.setHeight(600);
        
        float r = (float) Math.random();
        float g = (float) Math.random();
        float b = (float) Math.random();
        page.setRGBFill(r, g, b);
        
        page.rectangle(0, 0, 800, 600);
        page.fill();
        
        page.setRGBFill(1.0F - r, 1.0F - g, 1.0F - b);
        
        page.setFontAndSize(font, 30);
        
        page.beginText();
        page.setTextMatrix(0.8F, 0.0F, 0.0F, 1.0F, 0.0F, 0.0F);
        page.textOut(50, 530, caption);
        
        page.setTextMatrix(1.0F, 0.0F, 0.0F, 1.0F, 0.0F, 0.0F);
        page.setFontAndSize(font, 20);
        page.textOut(55, 300,
            "Type \"Ctrl+L\" in order to return from full screen mode.");
        page.endText();
        
        page.setSlideShow(style, 5.0F, 1.0F);
        page.setFontAndSize(font, 20);
        
        if (next != null) {
            page.beginText();
            page.textOut(680, 50, "Next=>");
            page.endText();
            
            HPdfRect rect = new HPdfRect();
            rect.setLeft(680);
            rect.setRight(750);
            rect.setTop(70);
            rect.setBottom(50);
            HPdfDestination dst = next.createDestination();
            dst.setFit();
            HPdfLinkAnnotation annot = page.createLinkAnnot(rect, dst);
            annot.setBorderStyle(0, 0, 0);
            annot.setHighlightMode(HPdfHighlightMode.INVERT_BOX);
        }
        
        if (prev != null) {
            page.beginText();
            page.textOut(50, 50, "<=Prev");
            page.endText();
            
            HPdfRect rect = new HPdfRect();
            rect.setLeft(50);
            rect.setRight(110);
            rect.setTop(70);
            rect.setBottom(50);
            HPdfDestination dst = prev.createDestination();
            dst.setFit();
            HPdfLinkAnnotation annot = page.createLinkAnnot(rect, dst);
            annot.setBorderStyle(0, 0, 0);
            annot.setHighlightMode(HPdfHighlightMode.INVERT_BOX);
        }
    }
    
}
