/*
 * JHPdf Free PDF Library : HPdfConst.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf;

/**
 * Class for define misc constants.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public final class HPdfConst {
    
    private HPdfConst() {
        // inhibits instantiation.
    }
    
    // definition from hpdf_consts.h
    
    /* buffer size which is required when we convert to character string. */
    public static final int HPDF_TMP_BUF_SIZ            = 512;
    public static final int HPDF_SHORT_BUF_SIZ          = 32;
    public static final int HPDF_REAL_LEN               = 11;
    public static final int HPDF_INT_LEN                = 11;
    public static final int HPDF_TEXT_DEFAULT_LEN       = 256;
    public static final int HPDF_UNICODE_HEADER_LEN     = 2;
    public static final int HPDF_DATE_TIME_STR_LEN      = 23;

    /* length of each item defined in PDF */
    public static final int HPDF_BYTE_OFFSET_LEN        = 10;
    public static final int HPDF_OBJ_ID_LEN             = 10;
    public static final int HPDF_GEN_NO_LEN             = 5;
    
    /*---------------------------------------------------------------------------*/
    /*------ limitation of object implementation (PDF1.4) -----------------------*/

    public static final int HPDF_LIMIT_MAX_INT             = 2147483647;
    public static final int HPDF_LIMIT_MIN_INT             = -2147483647;

    public static final int HPDF_LIMIT_MAX_REAL            = 32767;
    public static final int HPDF_LIMIT_MIN_REAL            = -32767;

    public static final int HPDF_LIMIT_MAX_STRING_LEN      = 65535;
    public static final int HPDF_LIMIT_MAX_NAME_LEN        = 127;

    public static final int HPDF_LIMIT_MAX_ARRAY           = 8191;
    public static final int HPDF_LIMIT_MAX_DICT_ELEMENT    = 4095;
    public static final int HPDF_LIMIT_MAX_XREF_ELEMENT    = 8388607;
    public static final int HPDF_LIMIT_MAX_GSTATE          = 28;
    public static final int HPDF_LIMIT_MAX_DEVICE_N        = 8;
    public static final int HPDF_LIMIT_MAX_DEVICE_N_V15    = 32;
    public static final int HPDF_LIMIT_MAX_CID             = 65535;
    public static final int HPDF_MAX_GENERATION_NUM        = 65535;

    public static final int HPDF_MIN_PAGE_HEIGHT           = 3;
    public static final int HPDF_MIN_PAGE_WIDTH            = 3;
    public static final int HPDF_MAX_PAGE_HEIGHT           = 14400;
    public static final int HPDF_MAX_PAGE_WIDTH            = 14400;
    public static final int HPDF_MIN_MAGNIFICATION_FACTOR  = 8;
    public static final int HPDF_MAX_MAGNIFICATION_FACTOR  = 3200;
    
    // definition from hpdf_conf.h
    
    /*----------------------------------------------------------------------------*/
    /*----- parameters in relation to performance --------------------------------*/

    /* default buffer size of memory-stream-object */
    public static final int  HPDF_STREAM_BUF_SIZ           = 4096;
    
}
