/*
 * JHPdf Free PDF Library : HPdfCMYKColor.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.graphics;

/**
 * Class represents PDF CMYK Color.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public final class HPdfCMYKColor implements Cloneable {
    
    public HPdfCMYKColor() {
        this(0, 0, 0, 0);
    }
    
    public HPdfCMYKColor(float c, float m, float y, float k) {
        super();
        this.c = c;
        this.m = m;
        this.y = y;
        this.k = k;
    }
    
    private float c;
    
    public float getC() {
        return this.c;
    }
    
    public void setC(float c) {
        this.c = c;
    }

    private float m;
    
    /**
     * @return m
     */
    public float getM() {
        return this.m;
    }

    /**
     * @param m ݒ肷 Ml
     */
    public void setM(float m) {
        this.m = m;
    }
    
    private float y;
    
    public float getY() {
        return this.y;
    }
    
    public void setY(float y) {
        this.y = y;
    }

    private float k;
    
    /**
     * @return k
     */
    public float getK() {
        return this.k;
    }

    /**
     * @param k ݒ肷 Kl
     */
    public void setK(float k) {
        this.k = k;
    }
    
    private void copy(HPdfCMYKColor org) {
        this.setC(org.getC());
        this.setM(org.getM());
        this.setY(org.getY());
        this.setK(org.getK());
    }

    @Override
    public HPdfCMYKColor clone()  {
        HPdfCMYKColor c;
        try {
            c = (HPdfCMYKColor) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException("HPdfCMYKColor cloning failed", e);
        }
        c.copy(this);
        return c;
    }
    
    
}
