/*
 * JHPdf Free PDF Library : HPdf3DMeasure.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.pdfobject;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.sf.jhpdf.HPdfException;
import net.sf.jhpdf.encoder.HPdfEncoder;
import net.sf.jhpdf.graphics.HPdfPoint3D;
import net.sf.jhpdf.graphics.HPdfRGBColor;
import net.sf.jhpdf.graphics.HPdfTextWidth;

/**
 * Abstract class represents PDF 3d measurement.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public abstract class HPdf3DMeasure extends HPdfDict {
    // TODO only stub, needs methods definition.

    private static final Logger logger = LoggerFactory.getLogger(HPdf3DMeasure.class);
    
    protected HPdf3DMeasure() {
        super();
        this.addName("Type", "3DMeasure");
        
        // MEMO: subclasses MUST register their own subtype
        // with addName("Subtype", foo)
    }
    
    private String name;

    protected final String getName() {
        return this.name;
    }
    
    public final void setName(String name) {
        this.name = name;
    }

    private HPdfRGBColor color;
    

    protected final HPdfRGBColor getColor() {
        return this.color;
    }
    
    public final void setColor(HPdfRGBColor color) {
        this.color = color;
    }
    
    float textSize;
    
    protected final float getTextSize() {
        return this.textSize;
    }
    
    public final void setTextSize(float textSize) {
        this.textSize = textSize;
    }
    
    int textBoxX;
    int textBoxY;
    
    protected final int[] getTextBoxSize() {
        return new int[] {this.textBoxX, this.textBoxY};
    }
    
    public final void setTextBoxSize(int x, int y) {
        this.textBoxX = x;
        this.textBoxY = y;
    }
    
    public final void setText(String text, HPdfEncoder encoder) {
        // TODO only stub.
    }
    
    protected final void addPoint3D(String key, HPdfPoint3D point) {
        HPdfArray array = new HPdfArray();
        
        this.add(key, array);
        
        array.addReal(point.getX());
        array.addReal(point.getY());
        array.addReal(point.getZ());
    }
    
    // TODO not implemented.
    /*
    public final void setProjectionAnotation(HPdfProjectionAnnotation projectionAnnotation) {
        // TODO only stub.
    }
    */
}
