/*
 * JHPdf Free PDF Library : HPdfArray.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.pdfobject;

import java.util.List;
import java.util.ArrayList;

import net.sf.jhpdf.HPdfErrorCode;
import net.sf.jhpdf.HPdfException;
import net.sf.jhpdf.encrypt.HPdfEncrypt;
import net.sf.jhpdf.graphics.HPdfRect;
import net.sf.jhpdf.io.HPdfWriteStream;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Class represents PDF Array.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public class HPdfArray extends HPdfObject {

    private static final Logger logger = LoggerFactory.getLogger(HPdfArray.class);
    
    private List<HPdfObject> listBody = new ArrayList<HPdfObject>();
    
    /**
     * ctor.
     */
    public HPdfArray() {
        super();
    }
    
    /**
     * creates a HPdfArray from a HPdfRect.<br>
     * it corresponds to orignal's 'HPDF_Box_Array_New()' function.
     * @param box source for new HPdfArray instance.
     * @return a HPdfArray contains box data.
     */
    public static HPdfArray boxToArray(HPdfRect box) {
        logger.trace("HPdfArray.boxToArray");
        
        HPdfArray obj = new HPdfArray();
        obj.add(new HPdfReal(box.getLeft()));
        obj.add(new HPdfReal(box.getBottom()));
        obj.add(new HPdfReal(box.getRight()));
        obj.add(new HPdfReal(box.getTop()));
        
        return obj;
    }

    public void addNumber(int value) {
        logger.trace("HPdfArray#addNumber");
        
        this.add(new HPdfNumber(value));
    }

    public void addReal(float value) {
        logger.trace("HPdfArray#addReal");
        
        this.add(new HPdfReal(value));
    }
    
    public void addName(String value) {
        logger.trace("HPdfArray#addName");
        
        this.listBody.add(new HPdfName(value));
    }
    
    public void add(HPdfObject obj) {
        logger.trace("HPdfArray#add");
        
        if (obj == null) {
            throw new HPdfException(HPdfErrorCode.HPDF_INVALID_OBJECT, 0);
        }
        
        if (obj.isTypeDirect()) {
            throw new HPdfException(HPdfErrorCode.HPDF_INVALID_OBJECT, 0);
        }
        
        // MEMO: original code inspects internal list size here(HPDF_LIMIT_MAX_ARRAY).
        // it should be class-private concerns, but may PDF specification?
        
        if (obj.isTypeIndirect()) {
            HPdfProxy proxy = new HPdfProxy(obj);
            this.listBody.add(proxy);
            proxy.setObjType(HPdfObjectType.DIRECT);
        } else {
            this.listBody.add(obj);
            obj.setObjType(HPdfObjectType.DIRECT);
        }
    }
    
    public void clear() {
        logger.trace("HPdfArray#clear");
        
        this.listBody.clear();
    }
    
    @Override
    protected void writeValue(HPdfWriteStream stream, HPdfEncrypt e) {
        logger.trace("HPdfArray#writeValue");
        
        stream.writeStr("[ ");
        for (final HPdfObject obj : this.listBody) {
            obj.write(stream, e);
            stream.writeChar(' ');
        }
        stream.writeChar(']');
    }
}
