/*
 * JHPdf Free PDF Library : HPdfPages.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.pdfobject;

import net.sf.jhpdf.HPdfErrorCode;
import net.sf.jhpdf.HPdfException;
import net.sf.jhpdf.encrypt.HPdfEncrypt;
import net.sf.jhpdf.io.HPdfWriteStream;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Class represents PDF page set.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public class HPdfPages extends HPdfDict {

    private static final Logger logger = LoggerFactory.getLogger(HPdfPages.class);
    
    /**
     * ctor. this is package-private.
     */
    HPdfPages(HPdfPages parent, HPdfXref xref) {
        super();
        logger.trace("HPdfPages#ctor");
        
        xref.add(this);
        
        /* add required elements */
        this.addName("Type", "Pages");
        this.add("Kids", new HPdfArray());
        this.add("Count", new HPdfNumber(0));
        
        if (parent != null) {
            parent.addKids(this);
        }
    }
    
    public void addKids(HPdfDict kid) {
        // TODO only stub
    }
    
    public long getPageCount() {
        // TODO only stub
        return 0L;
    }

    @Override
    protected void beforeWrite(HPdfWriteStream stream, HPdfEncrypt e) {
        HPdfArray kids = getItem("Kids", HPdfArray.class);
        HPdfNumber count = getItem("Count", HPdfNumber.class);
        logger.trace("HPdfPages#beforeWrite");
        
        if (kids == null) {
            throw new HPdfException(HPdfErrorCode.HPDF_PAGES_MISSING_KIDS_ENTRY, 0);
        }
        if (count != null) {
            count.setValue(getPageCount());
        } else {
            count = new HPdfNumber(getPageCount());
            add("Count", count);
        }
    }
}
