/*
 * JHPdf Free PDF Library : HPdfTextAnnotation.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.pdfobject.annotation;

import net.sf.jhpdf.encoder.HPdfEncoder;
import net.sf.jhpdf.pdfobject.HPdfBoolean;
import net.sf.jhpdf.pdfobject.HPdfXref;
import net.sf.jhpdf.graphics.HPdfRect;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Class represents PDF Text Annotation.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public class HPdfTextAnnotation extends HPdfMarkupAnnotation {

    private static final Logger logger = LoggerFactory.getLogger(HPdfTextAnnotation.class);
    
    public enum HPdfAnnotIcon {
        COMMENT("Comment"),
        KEY("Key"),
        NOTE("Note"),
        HELP("Help"),
        NEW_PARAGRAPH("NewParagraph"),
        PARAGRAPH("Paragraph"),
        INSERT("Insert"),
        ;
        private String name;
        HPdfAnnotIcon(String name) {
            this.name = name;
        }
        String getName() {
            return this.name;
        }
    }
    
    public HPdfTextAnnotation(HPdfXref xref, HPdfRect rect, String text, HPdfEncoder encoder) {
        super(xref, rect, text, encoder);
        
        logger.trace("HPdfTextAnnotation#ctor");
        
        this.addName("SubType", "Text");
    }
    
    public void setIcon(HPdfAnnotIcon icon) {
        logger.trace("HPdfTextAnnotation#setIcon");
        
        this.validate();
        
        this.addName("Name", icon.getName());
    }
    
    public void setOpened(boolean opened) {
        logger.trace("HPdfTextAnnotation#setOpened");
        
        this.validate();
        
        this.add("Open", new HPdfBoolean(opened));
    }
}
