/*
 * JHPdf Free PDF Library : HPdfFontImpl.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.pdfobject.font;

import net.sf.jhpdf.HPdfConst;
import net.sf.jhpdf.HPdfErrorCode;
import net.sf.jhpdf.HPdfException;
import net.sf.jhpdf.encoder.HPdfEncoder;
import net.sf.jhpdf.graphics.HPdfRect;
import net.sf.jhpdf.graphics.HPdfTextWidth;
import net.sf.jhpdf.pdfobject.HPdfFont;
import net.sf.jhpdf.pdfobject.HPdfStreamDict;
import net.sf.jhpdf.pdfobject.HPdfXref;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Abstract class implements PDF Font common function.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public abstract class HPdfFontImpl extends HPdfFont {
    // TODO only stub, needs methods definition.

    private static final Logger logger = LoggerFactory.getLogger(HPdfFontImpl.class);
    
    protected HPdfFontImpl(HPdfFontDef fontDef, HPdfEncoder encoder, HPdfXref xref) {
        super();
        
        // TODO maybe more process required.
        
        this.setFontDef(fontDef);
        this.setEncoder(encoder);
        this.setXref(xref);
    }
    
    private HPdfFontType type;
    
    protected final HPdfFontType getFontType() {
        return this.type;
    }
    
    protected final void setFontType(HPdfFontType type) {
        this.type = type;
    }
    
    private HPdfWritingMode writingMode;
    
    protected final HPdfWritingMode getWritingMode() {
        return this.writingMode;
    }
    
    protected final void setWritingMode(HPdfWritingMode writingMode) {
        this.writingMode = writingMode;
    }
    
    private HPdfFontDef fontDef;
    
    protected final HPdfFontDef getFontDef() {
        return this.fontDef;
    }
    
    protected final void setFontDef(HPdfFontDef fontDef) {
        this.fontDef = fontDef;
    }

    @Override
    public final String getFontName() {
        logger.trace("HPdfFont#getFontName");
        return this.getFontDef().getBaseFont();
    }
    
    @Override
    public final HPdfRect getBBox() {
        logger.trace("HPdfFont#getBBox");
        return this.getFontDef().getFontBbox();
    }
    
    @Override
    public final int getAscent() {
        logger.trace("HPdfFont#getAscent");
        return this.getFontDef().getAscent();
    }
    
    @Override
    public final int getDescent() {
        logger.trace("HPdfFont#getDescent");
        return this.getFontDef().getDescent();
    }
    
    @Override
    public final int getXHeight() {
        logger.trace("HPdfFont#getXHeight");
        return this.getFontDef().getXHeight();
    }
    
    @Override
    public final int getCapHeight() {
        logger.trace("HPdfFont#getCapHeight");
        return this.getFontDef().getCapHeight();
    }
    
    private HPdfEncoder encoder;
    
    @Override
    public final HPdfEncoder getEncoder() {
        return this.encoder;
    }
    
    protected final void setEncoder(HPdfEncoder encoder) {
        this.encoder = encoder;
    }

    @Override
    public final String getEncodingName() {
        logger.trace("HPdfFont#getEncodingName");
        return this.getEncoder().getName();
    }
    
    private int[] widths;
    
    protected final int[] getWidths() {
        // TODO should return copy?
        return this.widths;
    }
    
    protected final void setWidthsCount(int count) {
        this.widths = new int[count];
    }
    
    protected final int lookupWidth(int index) {
        return this.widths[index];
    }
    
    protected final void putWidth(int index, int val) {
        this.widths[index] = val;
    }
    
    private byte[] used;
    
    protected final byte[] getUsed() {
        // TODO should return copy?
        return this.used;
    }
    
    protected final void setUsedCount(int count) {
        this.used = new byte[count];
    }
    
    protected final byte lookupUsed(int index) {
        return this.used[index];
    }
    
    protected final void putUsed(int index, byte val) {
        this.used[index] = val;
    }
    
    private HPdfXref xref;
    
    protected final HPdfXref getXref() {
        return this.xref;
    }
    
    protected final void setXref(HPdfXref xref) {
        this.xref = xref;
    }
    
    private HPdfFont descendantFont;
    
    protected final HPdfFont getDescendantFont() {
        return this.descendantFont;
    }
    
    protected final void setDescendantFont(HPdfFont descendantFont) {
        this.descendantFont = descendantFont;
    }
    
    private HPdfStreamDict mapStream;
    
    protected final HPdfStreamDict getMapStream() {
        return this.mapStream;
    }
    
    protected final void setMapStream(HPdfStreamDict mapStream) {
        this.mapStream = mapStream;
    }
    
    private HPdfStreamDict cmapStream;
    
    protected final HPdfStreamDict getCmapStream() {
        return this.cmapStream;
    }
    
    protected final void setCmapStream(HPdfStreamDict cmapStream) {
        this.cmapStream = cmapStream;
    }
    
    @Override
    public final int getUnicodeWidth(char code) {
        logger.trace("HPdfFont#getUnicodeWidth");
        
        return this.getFontDef().getWidth(code);
    }
    
    @Override
    public final HPdfTextWidth textWidth(String text, int len) {
        logger.trace("HPdfFont#textWidth");
        
        if (len > HPdfConst.HPDF_LIMIT_MAX_STRING_LEN) {
            throw new HPdfException(HPdfErrorCode.HPDF_STRING_OUT_OF_RANGE, 0);
        }
        return textWidthImpl(text, len);
    }
    
    protected abstract HPdfTextWidth textWidthImpl(String text, int len);
    
    @Override
    public final int measureText(String text, int len,
            float width, float fontSize, float charSpace, float wordSpace,
            boolean wordWrap, float[] realWidth) {
        logger.trace("HPdfFont#measureText");
        
        if (len > HPdfConst.HPDF_LIMIT_MAX_STRING_LEN) {
            throw new HPdfException(HPdfErrorCode.HPDF_STRING_OUT_OF_RANGE, 0);
        }
        return measureTextImpl(text, len,
                width, fontSize, charSpace, wordSpace,
                wordWrap, realWidth);
                
    }
    
    protected abstract int measureTextImpl(String text, int len,
            float width, float fontSize, float charSpace, float wordSpace,
            boolean wordWrap, float[] realWidth);
    
}
