package net.sf.jhpdf

import org.junit.Test
import static org.junit.Assert.assertThat
import static org.hamcrest.CoreMatchers.is

class ByteUtilTest {
    @Test
    void bytesIndexOf() {
        def b1 = "byte utils.".getBytes("ISO-8859-1")
        def b2 = "util".getBytes("ISO-8859-1")
        def idx = ByteUtil.indexOf(b1, b2, 9)
		assertThat(idx, is(5))
    }
    @Test
    void stringIndexOf() {
        def b1 = "byte utils.".getBytes("ISO-8859-1")
        def b2 = "util"
        def idx = ByteUtil.indexOf(b1, b2, 9)
		assertThat(idx, is(5))
    }
    
    @Test
    void notFoundAtAll() {
        def b1 = "byte utils.".getBytes("ISO-8859-1")
        def b2 = "Hoge".getBytes("ISO-8859-1")
        def idx = ByteUtil.indexOf(b1, b2, b1.length)
		assertThat(idx, is(-1))
    }
    @Test
    void stringNotFoundAtAll() {
        def b1 = "byte utils.".getBytes("ISO-8859-1")
        def b2 = "Hoge"
        def idx = ByteUtil.indexOf(b1, b2, b1.length)
		assertThat(idx, is(-1))
    }
    
    @Test
    void notFoundBecauseOutOfLimit() {
        def b1 = "byte utils.".getBytes("ISO-8859-1")
        def b2 = "util".getBytes("ISO-8859-1")
        def idx = ByteUtil.indexOf(b1, b2, 5)
		assertThat(idx, is(-1))
    }
    @Test
    void stringNotFoundBecauseOutOfLimit() {
        def b1 = "byte utils.".getBytes("ISO-8859-1")
        def b2 = "util"
        def idx = ByteUtil.indexOf(b1, b2, 5)
		assertThat(idx, is(-1))
    }
    
    @Test
    void notFoundBecauseLimit() {
        def b1 = "byte utils.".getBytes("ISO-8859-1")
        def b2 = "util".getBytes("ISO-8859-1")
        def idx = ByteUtil.indexOf(b1, b2, 8)
		assertThat(idx, is(-1))
    }
    @Test
    void stringNotFoundBecauseLimit() {
        def b1 = "byte utils.".getBytes("ISO-8859-1")
        def b2 = "util"
        def idx = ByteUtil.indexOf(b1, b2, 8)
		assertThat(idx, is(-1))
    }
}
