#!/bin/busybox sh

showUsage () {
  echo "Usage: ${0##*/} path_to/bin/busybox-name" 1>&2
  exit 1
}
[ $# -eq 0 ] && showUsage
bbname="${1##*/}"
rootDir="${1%/*}"
case "$rootDir" in
bin) rootDir=. ;;
/bin) rootDir=/ ; cd / ;;
*/bin) rootDir="${rootDir%/bin}"
  cd "$rootDir" || showUsage
;;
*) showUsage ;;
esac

if [ ! -x "bin/$bbname" -o -d "bin/$bbname" ] ; then
  echo "No executable: $1"
  exit 1
fi

if [ -L "bin/$bbname" ] ; then
  echo "$1 must not a symlinked."
  exit 1
fi

absPathBB="$(readlink -f "bin/$bbname")"

tmpd=$(mktemp -d /tmp/busyboxRelink_XXXXXX)
busybox="$tmpd/busybox"
ln -s "$absPathBB" $busybox
appletList=$tmpd/aplstPath
curList=$tmpd/aplstCur
appletNameList=$tmpd/aplstName

$busybox --list-full | sort > $appletList
dList="$(sed 's,/[^/]*$,,' $appletList | sort | uniq)"

get_cLink () {
  case "$1" in
  */*/*/*/*) echo "TooDeepDir: $1" 1>&2; return 1 ;;
  */*/*/*) cLink="../../../bin/$bbname" ;;
  */*/*) cLink="../../bin/$bbname" ;;
  bin/*) cLink="$bbname" ;;
  */*)   cLink="../bin/$bbname" ;;
  *)     cLink="bin/$bbname" ;;
  esac
  return 0
}

linkCorrect () {
  [ "$(readlink -f "$1")" = "$absPathBB" ] || return 0
  get_cLink "$1" || return 0
  if [ "$(readlink "$1")" != "$cLink" ] ; then
    echo "LinkCorrection: $1" 1>&2
    ln -sf "$cLink" "$1"
  fi
  echo "$1" # for $curlist
}

# Current link correction and list
for d in $dList ; do
  if [ -d "$d" -a ! -L "$d" ] ; then
    echo "Searching ${rootDir%/}/$d/" 1>&2
    for applet in "$d"/* ; do
      [ -L "$applet" ] || continue
      linkCorrect "$applet"
    done
  elif [ -L "$d" -a ! -d "$d" ] ; then
    linkCorrect "$d"
  fi
done > $curList

echo 'Correcting links ...' 2>&1
# Warn NonstandardPath and Delete NonApplet
$busybox --list | sed 's#^#/#;s#$#/#' > $appletNameList
sort $appletList $appletList $curList | uniq -u | while read x ; do
  if grep -F -q "/${x##*/}/" $appletNameList ; then
    # consider [ and [[, use fgrep
    stdPath="$(sed 's@^@/@;s@$@#@' $appletList |
      grep -F -m 1 "/${x##*/}#")"
    stdPath="${stdPath%?}"; stdPath="${stdPath#?}"
    echo "NonstandardPath: $x ; #Kept. ( $stdPath )" 1>&2
  else
    echo "NonApplet: $x ; #Delete" 1>&2
    rm -f "$x"
  fi 
done

# Make lost links
while read -r x ; do
  [ -e "$x" -o -L "$x" ] && continue
  if get_cLink "$x" ; then
    echo "NewLink: $x" 1>&2
    ln -s "$cLink" "$x"
  fi
done < $appletList

rm -rf "$tmpd"

exit


