#!/bin/busybox sh
# i am a superuer, no farther check
hk=/bin/rm  # command to wrap (hook)

################
[ -L "$hk" -a /bin/busybox = "$(readlink -f "$hk")" ] || exit 1
hk="${hk#/*}"

if [ ! -f versions.lst ] ; then 
  ## example of versions.lst
  cat >versions.lst <<- '  EOVLST'
	name: fakesh
	firmware_version,hardware comment
	2.1.*,*300  first kobo Touch
	2.2.0,*
	 2.2.1,*3[1-3]? except for first kobo Touch
	2.3.1,*300
	  2.3.2,*3[34]0 buggy
	# *,* all versions
	script:dst: 
	script:pre: 
	script:exe: 
	aux:tar: 
  EOVLST
  ### end of example
  echo "An example of versions.lst was generated" 1>&2
  exit 1
fi

mv -f versions.lst versions.lst.dos
tr -d '\r\0' < versions.lst.dos > versions.lst
rm -f versions.lst.dos
wd="$(mktemp -p . -d zXXXXXX)"
cd $wd
if [ ! -f ../KoboRoot.tgz ] ; then
  mkdir -p -m 1777 var/tmp
  date -Iseconds > var/tmp/addVerCheck-SUCC
  tar cfz ../KoboRoot.tgz ./var/tmp ./var/tmp/addVerCheck-SUCC
  rm -rf var
fi

name=addvercheck  # default name of this package
while read tag val ; do
  case "$tag" in
  name:) name="$val" ;;
  script:dst:) scr_dst="$val" ;; # abs path of script
  script:pre:) scr_pre="$val" ;; # cmds output to stdout to $scr_dst, 
  script:exe:) scr_exe="$val" ;; # exe command line
  aux:tar:) aux_tar="$val" ;; # auxiliary tar archive 
  esac
done < ../versions.lst

## DONT INCLUDE BOTH NONEMPTY DIR and ITS FILES
case "$aux_tar" in
/*.tar) ;;
*.tar) aux_tar="../$aux_tar" ;;
*) aux_tar='' ;;
esac

# scr_dst : abs path of script
[ -z "$scr_dst" ] && scr_dst="/mnt/onboard/_root_${wd##*/z}.tar"
scr_dst="${scr_dst#/}"
mkdir -p "${hk%/*}" "${scr_dst%/*}"

# scr_exe : exe command line
[ -z "$scr_exe" ] && scr_exe="tar xf /$scr_dst -C /"

# scr_pre : cmdline of preparing $scr_dst, output to stdout
[ -z "$scr_pre" ] && scr_pre="zcat ../KoboRoot.tgz; rm -f ../KoboRoot.tgz;"
eval "$scr_pre" > "$scr_dst"
chmod +x "$scr_dst"

bbx=busybox
case ${hk%/*} in
bin) lnk=$bbx ;;
*/*) lnk=../../bin/$bbx ;;
*) lnk=../bin/$bbx ;;
esac

upgrd=mnt/onboard/.kobo/upgrade
[ -d $upgrd ] || mkdir -p $upgrd
md5=mnt/onboard/.kobo/manifest.md5sum
echo 'fakesh ^o^;' > $md5
KoboRoot_tgz=/mnt/onboard/.kobo/KoboRoot.tgz

cat > $hk << EOH
#!/bin/$bbx sh
# i am a wrapper of "/$hk"=="\$0"
# you may not a superuser, check
[ \$(id -u) -eq 0 ] || exec $bbx "\${0##*/}" "\$@"
# dont upgrade u-boot or kernel
[ -e /$upgrd ] &&
  $bbx rm -rf /$upgrd /$md5
# fail safe against stopping "$scr_exe"
if [ -e $KoboRoot_tgz ] ; then
  [ -f $KoboRoot_tgz ] ||
    $bbx rm -rf $KoboRoot_tgz
  empDir=\$($bbx mktemp -d -p /tmp)
  $bbx chmod 755 \$empDir
  $bbx tar cfz - . -C \$empDir > $KoboRoot_tgz
  $bbx rm -rf \$empDir
fi
if [ -f '/$scr_dst' ] ; then
  $bbx ln -sf '$lnk' '/$hk'
  read fw < /mnt/onboard/.kobo/version
  hw=\${fw##*,}; fw="\${fw#*,}"; fw="\${fw#*,}"
  case "\${fw%%,*},\$hw" in
EOH

printf '\nname: %s\nVersions:\n' "$name" 1>&2
d='  '  # delimiter
while read vv cmt ; do
  case "$vv" in
  *,*,*) continue ;;
  [0-9]*,* | '['[0-9]*,* | '*'*,* ) ;;
  *) continue ;;
  esac
  printf '  %s\t\t%s\n' "$vv" "$cmt" 1>&2
  printf "${d}%s" "$vv"
  d=' |\\\n  '
done < ../versions.lst >> $hk

cat >> $hk << EOT
 )
    $scr_exe
  ;;
  *)
    cat > "/mnt/onboard/Error_install_$name" <<- EOE
	sorry, did not pass your version:
	firmware="\${fw%%,*}"; hardware="\$hw";
	EOE
  ;;
  esac >/dev/null 2>&1 </dev/null
  $bbx "\${0##*/}" "\$@"  # do the given command
  exitN=\$?
  # here may recursively call "rm", if
  # "$scr_exe" replaced "rm" !
  rm -f '/$scr_dst'
  $bbx sync; $bbx sync; $bbx sync
  # reboot # (^^; # will be done by the caller
  exit \$exitN
else
  exec $bbx "\${0##*/}" "\$@"
fi
#NEVER_REACH_HERE
EOT
chmod +x $hk

aux="./$upgrd ./$md5"
[ -f "$aux_tar" ] && aux="$(tar xfv "$aux_tar" 2>/dev/null) $aux"
tar cfz ../KoboRoot.tgz ./"$hk" ./"$scr_dst" $aux

printf '\n## contents of NEW KoboRoot.tgz\n'
tar tfvz ../KoboRoot.tgz
printf \\n
echo "## INSTALLER(/$hk):"
busybox sh -nv ./"$hk" && printf '## NO-SYNTAX-ERROR by "busybox sh -nv"\n'
printf \\n

cd ..
rm -rf $wd

exit

