//
//  label.c
//  chncpu
//
//  Created by 西田　耀 on 2014/06/22.
//  Copyright (c) 2014年 CHNOSProject. All rights reserved.
//

#include "chncpu.h"

CHNCPU_LabelSet *CHNCPU_CreateLabelSet(void)
{
	CHNCPU_LabelSet *lbSet;
	
	lbSet = malloc(sizeof(CHNCPU_LabelSet));
	if(!lbSet){
        puts("CHNCPU_CreateLabelSet: malloc error, abort.\n");
        exit(EXIT_FAILURE);
    }
	
	lbSet->top.labelID = 0;
	lbSet->top.opt = 0;
	lbSet->top.mindex = 0;
	lbSet->top.next = NULL;
	
	return lbSet;
}

int CHNCPU_Label_Add(CHNCPU_LabelSet *lbSet, int mindex, ch4_uint labelID, ch4_uint opt, ch4_sint pType)
{
	// retv: 0:succeeded -1:alreadyExisted -2:mallocError
	CHNCPU_LabelTag *t = &lbSet->top;
	for(;;){
		if(t->labelID == labelID){
			// 既に存在するラベルID
			return -1;
		}
		if(t->next == NULL){
			// 最後のタグ
			break;
		}
		t = t->next;
	}
	
	t->next = malloc(sizeof(CHNCPU_LabelTag));
	if(t->next){
		t = t->next;
		t->pType = pType;
		t->mindex = mindex;
		t->labelID = labelID;
		t->opt = opt;
		t->next = NULL;
	} else{
		return -2;
	}
	
	return 0;
}

CHNCPU_LabelTag *CHNCPU_Label_GetTagFromLabelID(CHNCPU_LabelSet *lbSet, int labelID)
{
	CHNCPU_LabelTag *t = &lbSet->top;
	for(;;){
		if(t->labelID == labelID){
			return t;
		}
		if(t->next == NULL){
			// 最後のタグ
			break;
		}
		t = t->next;
	}
	return NULL;
}

