//
//  opcache.h
//  chncpu
//
//  Created by 西田　耀 on 2014/07/07.
//  Copyright (c) 2014年 CHNOSProject. All rights reserved.
//

#ifndef chncpu_opcache_h
#define chncpu_opcache_h

#include "chncpu.h"

//
// 00 NOP (not cached)
//
// 00
//


//
// 01 LB
//
// 01 labelID opt
//
typedef struct _CHNCPU_OP_CACHE_LB CHNCPU_OpCache_LB;
struct _CHNCPU_OP_CACHE_LB {
    ch4_uint labelID;
    ch4_uint opt;
};

//
// 02 LIMM
//
// 02 (sint)imm r bit
//
typedef struct _CHNCPU_OP_CACHE_LIMM CHNCPU_OpCache_LIMM;
struct _CHNCPU_OP_CACHE_LIMM {
    ch4_sint imm;
    ch4_uint r;
    ch4_uint bit;
};

//
// 03 PLIMM
//
// 03 labelID p
//
typedef struct _CHNCPU_OP_CACHE_PLIMM CHNCPU_OpCache_PLIMM;
struct _CHNCPU_OP_CACHE_PLIMM {
    ch4_uint labelID;
    ch4_uint r;
};

//
// 04 CND
//
// 04 r
//
typedef struct _CHNCPU_OP_CACHE_CND CHNCPU_OpCache_CND;
struct _CHNCPU_OP_CACHE_CND {
    ch4_uint r;
};

//
// 05 CALLBIOS
//
// 05 fid ...
//

//
// 08 LMEM
//
// 08 p (sint)pType (sint)pDiff rDst bitDst
//
typedef struct _CHNCPU_OP_CACHE_LMEM CHNCPU_OpCache_LMEM;
struct _CHNCPU_OP_CACHE_LMEM {
    ch4_uint p;
    ch4_sint pType;
	ch4_sint pDiff;
	ch4_uint r;
	ch4_uint bitDst;
};

//
// 09 SMEM
//
// 09 rDst bitDst p (sint)pType (sint)pDiff
//
typedef struct _CHNCPU_OP_CACHE_SMEM CHNCPU_OpCache_SMEM;
struct _CHNCPU_OP_CACHE_SMEM {
    ch4_uint r;
	ch4_uint bitSrc;
    ch4_uint p;
    ch4_sint pType;
	ch4_sint pDiff;
};

//
// 10-12, 14-16, 18-1B Ternary Register Operation
//
// opCode r1 r2 r0 bit
//
//	Bitwise
//		10 CP/OR	r0 = r1 | r2;	(CP: r0 = r1)
//		11 XOR		r0 = r1 ^ r2;
//		12 AND		r0 = r1 & r2;
//
//	Arithmetic
//		14 ADD		r0 = r1 + r2;
//		15 SUB		r0 = r1 - r2;
//		16 MUL		r0 = r1 * r2;
//		18 SHL		r0 = r1 << r2;
//		19 SAR		r0 = r1 >> r2;
//		1A DIV		r0 = r1 / r2;
//		1B MOD		r0 = r1 % r2;
//
typedef struct _CHNCPU_OP_CACHE_TERNARY_REG CHNCPU_OpCache_TernaryReg;
struct _CHNCPU_OP_CACHE_TERNARY_REG {
    ch4_uint r0;
    ch4_uint r1;
    ch4_uint r2;
	ch4_uint bit;
	unsigned int prefix;
};

//
// 20-27 Compare Integer Register Operation
//
// opCode r1 r2 bitCmp r0 bitDst
//
//		20 CMPE		r0 = (r1 == r2)	? -1 : 0;
//		21 CMPNE	r0 = (r1 != r2)	? -1 : 0;
//		22 CMPL		r0 = (r1 < r2)	? -1 : 0;
//		23 CMPGE	r0 = (r1 >= r2) ? -1 : 0;
//		24 CMPLE	r0 = (r1 <= r2) ? -1 : 0;
//		25 CMPG		r0 = (r1 > r2)	? -1 : 0;
//		26 TSTZ		((r1 & r2) == 0) ? -1 : 0;
//		27 TSTNZ	((r1 & r2) != 0) ? -1 : 0;
//
typedef struct _CHNCPU_OP_CACHE_COMPARE_IREG CHNCPU_OpCache_CompareIReg;
struct _CHNCPU_OP_CACHE_COMPARE_IREG {
    ch4_uint rSrc1;
    ch4_uint rSrc2;
    ch4_uint bitDiff;
	ch4_uint rDst;
	ch4_uint bitDst;
	unsigned int prefix;
};


//
// 2E DATA
//
// 2E labelID labelOpt (sint)dType dCount (rawData...)
//
typedef struct _CHNCPU_OP_CACHE_DATA CHNCPU_OpCache_DATA;
struct _CHNCPU_OP_CACHE_DATA {
    ch4_uint labelID;
    ch4_uint labelOpt;
	CHNCPU_Data *data;
};

//
// 2F Prefix (not cached)
//
// 2F n
//

//
// 32 MALLOC
//
// 32 rType bitType rCount bitCount p
//
typedef struct _CHNCPU_OP_CACHE_MALLOC CHNCPU_OpCache_MALLOC;
struct _CHNCPU_OP_CACHE_MALLOC {
    ch4_uint rType;
    ch4_uint bitType;
	ch4_uint rCount;
	ch4_uint bitCount;
	ch4_uint p;
};



#endif
