#include	<openssl/md5.h>
#include	"xchange.h"
#include	"config.h"

void	DateSend(int sock);
extern	CpuUsage[];
extern	time_t	AprsConnectTime;

char    *wday[] = {"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
char    *month[] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
char	http_temp[512];

void	httpd_srv_accept(void)
{
	socklen_t	len;
	int	sock;
	int	yes = 1;
	time_t	atime;

	len = sizeof(http_recv);
	sock = accept(http_sd, (struct sockaddr *)&http_recv, &len);
	if (sock < 0)
	{
		time(&atime);
		fprintf (log_file, "%24.24s %s\n", ctime(&atime), strerror(errno));
		fflush (log_file);
		FD_CLR (http_sd, &fd_save);
		close (http_sd);
		http_sd = 0;
		http_port= 0;
	}
	else
	{
		setsockopt (sock, SOL_SOCKET, SO_REUSEADDR, (const char *)&yes, sizeof(yes));
		FD_SET (sock, &fd_save);
	}
}

void	NotFound (int sock)
{
	send (sock, "HTTP/1.1 404 Not Found\r\n", 24, 0);
	DateSend(sock);
	send (sock, "Content-Type: text/html\r\n", 25, 0);
	send (sock, "Content-length: 248\r\n\r\n", 23, 0);
	send (sock, "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">\r\n", 94, 0);
	send (sock, "<html><head><title>404 Not Found</title></head>",  47, 0); 
	send (sock, "<body><h1>Not Found</h1><p>The requested URL /favicon.ico was not found on this server.</p></body></html>", 107, 0);
}

void	NotModify (int sock)
{
	send (sock, "HTTP/1.1 304 Not Modified\r\nConnection: close\r\n\r\n", 50, 0);
	//DateSend (sock);
	//send (sock, "\r\n", 2, 0);
}

void	ETagSend (int sock, char tag[])
{
        send (sock, "ETag: \"", 7, 0);
        send (sock, tag, 32, 0);
        send (sock, "\"\r\n", 3, 0);
}

void	LastModSend (int sock, time_t mod_time)
{
        gt = gmtime(&mod_time);
        sprintf (http_temp, "Last-Modified: %3.3s, %2.2d %3.3s %4.4d %02d:%02d:%02d GMT\r\n",
                        wday[gt->tm_wday],
                        gt->tm_mday,
                        month[gt->tm_mon],
                        gt->tm_year+1900,
                        gt->tm_hour,
                        gt->tm_min,
                        gt->tm_sec);
        send (sock, http_temp, strlen(http_temp), 0);
}

time_t	ModifiedTime (char string[])
{
	time_t	req_time;
	char	*tok;
	int	mon;

	tok = string;
	tok = strtok (tok, " :\0");
	gt->tm_mday = atoi(tok);
	tok = strtok (NULL, " :\0");
	for (mon = 0 ; mon < 12 ; mon++)
	{
		if (!memcmp (tok, month[mon], 3)) break;
	}
	gt->tm_mon = mon;
	tok = strtok (NULL, " :\0");
	gt->tm_year = atoi (tok) - 1900;
	tok = strtok (NULL, " :\0");
	gt->tm_hour = atoi (tok);
	tok = strtok (NULL, " :\0");
	gt->tm_min = atoi (tok);
	tok = strtok (NULL, " :\0");
	gt->tm_sec = atoi (tok);
	gt->tm_isdst = daylight;
	req_time = mktime(gt);
	req_time -= timezone;
	return req_time;
}


void	ETagGen (char file_name[], char md_string[])
{
	MD5_CTX	ctx;
	unsigned char	md[MD5_LBLOCK];
	FILE	*fp;
	int	ret;

        fp = fopen (file_name, "rb");
        MD5_Init (&ctx);
        while (1)
        {
                ret = fread (http_temp, 1, sizeof(http_temp), fp);
                if (ret > 0) MD5_Update(&ctx, http_temp, ret);
                else break;
        }
        fclose (fp);
        MD5_Final (md, &ctx);
        sprintf (md_string, "%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x",
                        md[0], md[1], md[2], md[3], md[4], md[5], md[6], md[7],
                        md[8], md[9], md[10], md[11], md[12], md[13], md[14], md[15]);
}

void	FileBodySend (char file_name[], int sock)
{
	FILE	*fp;
	int	ret;

        fp = fopen (file_name, "rb");
        while (1)
        {
                ret = fread (http_temp, 1, sizeof(http_temp), fp);
                if (ret > 0) send (sock, http_temp, ret, 0);
                else break;
        }

        fclose(fp);
}

/*
        Java Scrip File send
        file name : /opt/dstar/web/xchange.js
*/
void    js_send(int sock, char buf[] )
{
        char   md_string[33];
        int     ret;
        struct  stat    stat_buf;
        char    *tok;
        time_t  req_time;
        char    NotMod;
        extern long int timezone;
        extern  int     daylight;

        ret = stat (JS_FILE, &stat_buf);

        if (ret != 0)
        {
                NotFound (sock);
                return;
        }

        ETagGen (JS_FILE, md_string);

        req_time = 0;
        tok = strtok (buf, "\r\n\0");
        NotMod = FALSE;
        while (tok)     /* Checnk last modified */
        {
                if (!memcmp (tok, "If-Modified-Since: ", 19))
                {
                        req_time = ModifiedTime (tok+24);
                        if (req_time >= stat_buf.st_mtime) NotMod = TRUE;
                }
                else if (!memcmp (tok, "If-None-Match: ", 15))
                {
                        if (!memcmp (tok+16, md_string, 32))
                        {
                                NotModify (sock);
                                return;
                        }

                }
                tok = strtok (NULL, "\r\n\0");
        }
        if (NotMod)
        {
                NotModify(sock);
                return;
        }

        send (sock, "HTTP/1.1 200 OK\r\n", 16, 0);
        DateSend (sock);
        LastModSend (sock, stat_buf.st_mtime);
        ETagSend (sock, md_string);
        send (sock, "Content-Type: text/javascript\r\n", 31, 0);
        send (sock, "Cache-Control: max-age=3600\r\n", 29, 0);
        send (sock, "Connection: close\r\n", 19, 0);
        sprintf (http_temp, "Content-length: %0ld\r\n", stat_buf.st_size);
        send (sock, http_temp, strlen(http_temp), 0);
        send (sock, "\r\n", 2, 0);

        FileBodySend (JS_FILE, sock);
}

/*
        logo File send
        file name : /opt/dstar/web/logo.png
*/
void    logo_send(int sock, char buf[] )
{
	char	md_string[33];
        int     ret;
        struct  stat    stat_buf;
        char    *tok;
        time_t  req_time;
	char	NotMod;
        extern long int timezone;
        extern  int     daylight;

        ret = stat (LOGO_FILE, &stat_buf);
        if (ret != 0)
        {
                NotFound (sock);
                return;
        }

	ETagGen (LOGO_FILE, md_string);

        req_time = 0;
        tok = strtok (buf, "\r\n\0");
	NotMod = FALSE;
        while (tok)     /* Checnk last modified */
        {
                if (!memcmp (tok, "If-Modified-Since: ", 19))
                {
                        req_time = ModifiedTime (tok+24);
			if (req_time >= stat_buf.st_mtime) NotMod = TRUE;
                }
		else if (!memcmp (tok, "If-None-Match: ", 15))
		{
			if (!memcmp (tok+16, md_string, 32))
			{
				NotModify (sock);
				return;
			}
			
		}
                tok = strtok (NULL, "\r\n\0");
        }
        if (NotMod)
        {
                NotModify(sock);
                return;
        }

        send (sock, "HTTP/1.1 200 OK\r\n", 16, 0);
        DateSend (sock);
	LastModSend (sock, stat_buf.st_mtime);
	ETagSend (sock, md_string);
        send (sock, "Content-Type: image/png\r\n", 26, 0);
	send (sock, "Cache-Control: max-age=3600\r\n", 29, 0);
        send (sock, "Connection: close\r\n", 19, 0);
        sprintf (http_temp, "Content-length: %0ld\r\n", stat_buf.st_size);
        send (sock, http_temp, strlen(http_temp), 0);
        send (sock, "\r\n", 2, 0);

	FileBodySend (LOGO_FILE, sock);
}


/*
	CSS File send
	file name : /opt/dstar/web/xchange.css
*/
void	css_send(int sock, char	buf[] )
{
	char	md_string[33];

	int	ret;
	struct	stat	stat_buf;
	char	*tok;
	time_t	req_time;
	char	NotMod;
	extern long int	timezone;
	extern	int	daylight;

	ret = stat (CSS_FILE, &stat_buf);

	if (ret != 0)
	{
		NotFound (sock);
		return;
	}

	ETagGen (CSS_FILE, md_string);

	req_time = 0;
	tok = strtok (buf, "\r\n\0");
	NotMod = FALSE;
	while (tok)	/* Checnk last modified */
	{
                if (!memcmp (tok, "If-Modified-Since: ", 19))
                {
                        req_time = ModifiedTime (tok+24);
                        if (req_time >= stat_buf.st_mtime) NotMod = TRUE;
                }
                else if (!memcmp (tok, "If-None-Match: ", 15))
                {
                        if (!memcmp (tok+16, md_string, 32))
			{
				NotModify(sock);
                        	return;
			}
                }
		tok = strtok (NULL, "\r\n\0");
	}
	if (NotMod)
	{
		NotModify(sock);
		return;
	}
			
	send (sock, "HTTP/1.1 200 OK\r\n", 16, 0);
	DateSend (sock);
	LastModSend (sock, stat_buf.st_mtime);
	ETagSend (sock, md_string);
	send (sock, "Content-Type: text/css\r\n", 24, 0);
	send (sock, "Cache-Control: max-age=3600\r\n", 29, 0);
	send (sock, "Connection: close\r\n", 19, 0);
	sprintf (http_temp, "Content-length: %0ld\r\n", stat_buf.st_size);
	send (sock, http_temp, strlen(http_temp), 0);
	send (sock, "\r\n", 2, 0);

	FileBodySend (CSS_FILE, sock);
}

void	DateSend(int sock)
{
	time_t	atime;

	time(&atime);
        gt = gmtime(&atime);
        sprintf (http_temp, "Date: %3.3s, %2.2d %3.3s %4.4d %02d:%02d:%02d GMT\r\n",
                        wday[gt->tm_wday],
                        gt->tm_mday,
                        month[gt->tm_mon],
                        gt->tm_year+1900,
                        gt->tm_hour,
                        gt->tm_min,
                        gt->tm_sec);
        send (sock, http_temp, strlen(http_temp), 0);
}

void	chunked_send(char string[], int sock)
{
	char	chunk[6];
	unsigned int	len;

	len = strlen(string);

	sprintf (chunk, "%02x\r\n", len);
	send (sock, chunk, 4, 0);
	send (sock, string, strlen(string), 0);
	send (sock, "\r\n", 2, 0);
}

void	httpd_srv_recv(int sock)
{
	struct	ModuleTable	*m_t;
	struct	forward		*fwd_pnt;
	time_t	atime;
	extern	time_t	start_time;
	time_t	dtime;
	int	len;
	int	d, h, m, s;
	char	temp[512];

	if ((len = recv (sock, temp, sizeof(temp) - 1, 0)) <= 0)
	{
		FD_CLR (sock, &fd_save);
		close (sock);
		return;
	}
	temp[len] = 0x00;
	if (len < 13) return;
	if (!memcmp (temp, "GET /favicon.ico", 16))
	{
		NotFound(sock);
		return;
	}
	else if (!memcmp (temp, "GET /xchange.css", 13))
	{
		css_send(sock, temp );
		return;
	}
        else if (!memcmp (temp, "GET /logo.png", 13))
        {
                logo_send(sock, temp );
                return;
        }
        else if (!memcmp (temp, "GET /xchange.js", 13))
        {
                js_send(sock, temp );
                return;
        }

	else if (!memcmp (temp, "GET /index.htm", 14) 
		|| !memcmp (temp, "GET / HTTP", 10))
	{  
		send (sock,"HTTP/1.1 200 OK\r\nContent-Type: text/html\r\n", 42, 0);
		DateSend (sock);
		sprintf (temp, "Server: dxchange %5.5s\r\n", PACKAGE_VERSION);
		send (sock, temp, strlen(temp), 0);
		send (sock, "Cache-Control: no-cache\r\n", 25, 0);
		send (sock, "Transfer-Encoding: chunked\r\n\r\n",  30, 0);
		time(&atime);
		chunked_send ("<!DOCTYPE HTML>\r\n\0",  sock);
		sprintf (temp, "<html><head><meta http-equiv=\"refresh\" content=\"5\"><title>D-STAR X-change Status %7.7s</title>\r\n", zr_callsign);
		chunked_send(temp, sock);
		//sprintf (temp, "<script type=\"text/javascript\" src=\"xchange.js\"></script>\r\n");
		//chunked_send(temp, sock);
		sprintf (temp, "<link rel=\"stylesheet\" type=\"text/css\" href=\"/xchange.css\" /></head>\r\n");
		chunked_send (temp, sock);

		sprintf (temp, "<body><h3>D-STAR X-change (xchange) Status V%5.5s at %24.24s</h3>\r\n",PACKAGE_VERSION, ctime(&atime));
		chunked_send(temp, sock);
		chunked_send ("<img src=\"logo.png\" align=\"left\" border=\"0\">\r\n\0", sock);

		dtime = atime - start_time;
		d = dtime / 86400;
		dtime %= 86400;
		h = dtime / 3600;
		dtime %= 3600;
		m = dtime / 60;
		s = dtime % 60;
		sprintf (temp, "<table><tr><td>Started</td><td>%24.24s</td></tr><tr><td>Up time</td><td>\r\n", ctime(&start_time));
		chunked_send(temp, sock);
		if (d)
		{
			sprintf (temp, "<div Align=right>%dd%2dh%2dm%2ds</div></td>\r\n", d, h, m, s);
		}
		else if (h)
		{
			sprintf (temp, "<div Align=right>%2dh%2dm%2ds</div></td>\r\n", h, m, s);
		}
		else if (m)
		{
	        	sprintf (temp, "<div align=right>%dm%2ds</div></td>\r\n", m, s);
		}
		else 
		{
        		sprintf (temp, "<div align=right>%2ds</div></td></tr>\r\n", s);
		}
		chunked_send(temp, sock);
		cpu_usage();
		sprintf (temp, "<tr><td>cpu usage</td><td><div align=right>%s</div></td></tr>\r\n", CpuUsage);
		chunked_send (temp, sock);
		chunked_send("<tr><td>upnp</td><td><div align=right>\0", sock);
		if (upnp_sw) chunked_send ("On</div></td</tr>\r\n\0", sock);
		else chunked_send ("Off</div></td</tr>\r\n\0", sock);
		chunked_send ("</table>\r\n\0", sock);

		/* xchange status */
		chunked_send ("<h3>NIC & Port Information</h3>\r\n\0", sock);
		chunked_send ("<table>\r\n\0", sock);
		sprintf (temp, "<tr><td>GW_NIC:%16.16s</td><td>gw_in:%d</td><td>gw_out:%d</td><td>ZR_NIC:%16.16s</td><td>zr_in:%d</td><td>zr_out:%d</td><td>mon_in:%d</d></tr>\r\n",
				GW_NIC, gw_in_port, gw_out_port, ZR_NIC, zr_in_port, zr_out_port, mon_port);
		chunked_send (temp, sock);
		chunked_send ("</table>\r\n\0", sock);
                chunked_send ("<table>\r\n\0", sock);
                chunked_send ("<tr><th><center>gateway in</center></th><th><center>gateway out</center></th><th><center>monitor in</center></th><th><center>zone repeater in</center></th><th><center>zone repeater out</center></th><th>position in fm zr</th><tr>\r\n\0", sock);
		sprintf (temp, "<tr><td><center>%ld</center></td><td><center>%ld</center></td><td><center>%ld</center></td><td><center>%ld</center></td><td><center>%ld</center></td><td><center>%ld</center></td></tr>\n\r",
                                gw_in_cnt, gw_out_cnt, mon_in_cnt, zr_in_cnt, zr_out_cnt, zr_posit_in_cnt);
                chunked_send (temp, sock);
		chunked_send ("</table>\r\n\0", sock);

		chunked_send ("<h3>Module Information (dv/dd)</h3>\r\n\0", sock);
		m_t = module_pnt;
		chunked_send ("<table>\r\n\0", sock);
		chunked_send ("<tr><th>Module</th><th><center>gateway in</center></th><th><center>gateway out</center></th><th><center>monitor in</center></th><th><center>zone repeater in</center></th><th><center>zone repeater out</center></th><th>Status</th><th>ZR PTT</th><tr>\r\n\0", sock);
		while (m_t)
		{
			sprintf (temp, "<tr><td>%8.8s</td><td><center>%ld/%ld</center></td><td><center>%ld/%ld</center></td><td><center>%ld/%ld</center></td><td><center>%ld/%ld</center></td><td><center>%ld/%ld</center></td>\n\r",
				m_t->ModuleName, m_t->gw_dv_in_cnt, m_t->gw_dd_in_cnt, 
				m_t->gw_dv_out_cnt, m_t->gw_dd_out_cnt,
				m_t->mon_dv_in_cnt, m_t->mon_dd_in_cnt,
				m_t->zr_dv_in_cnt, m_t->zr_dd_in_cnt,
				m_t->zr_dv_out_cnt, m_t->zr_dd_out_cnt);
			chunked_send (temp, sock);
			if (m_t->block_sw) chunked_send("<td>Blocked</td>\r\n\0", sock);
			else chunked_send("<td>UnBlocked</td>\r\n\0", sock);
			if (m_t->ZR_on) chunked_send ("<td><center>On</center></td></tr>\r\n\0", sock);
			else chunked_send ("<td><center>Off</center></td></tr>\r\n\0", sock);
			
			m_t = m_t->f_chain;
		}
		chunked_send ("</table>\r\n\0", sock);
	

		/* Forward Port Information */

		if (forward_pnt)
		{
			chunked_send ("<h3>Forward Port Information</h3>\r\n\0", sock);
			fwd_pnt = forward_pnt;
			chunked_send ("<table>\r\n\0", sock);
			chunked_send ("<tr><th>Mnemonic</th><th><center>domain name : port</center></th><th><center>In Packets</center></th><th><center>Out Packets</center></th><th>Status</th><tr>\r\n\0", sock);
			while (fwd_pnt)
			{
				sprintf (temp, "<tr><td>%16.16s</td><td><center>%s:%d</center></td><td><center>%ld</center></td><td><center>%ld</center></td>\r\n", fwd_pnt->mnemonic, fwd_pnt->fqdn, fwd_pnt->port, fwd_pnt->in_packets, fwd_pnt->out_packets);
				chunked_send (temp, sock);
				if (fwd_pnt->alive) chunked_send ("<td><center>OK</center></td><tr>\r\n\0", sock);
				else chunked_send ("<td><center>NG</center></td><tr>\r\n\0", sock); 
				fwd_pnt = fwd_pnt->f_chain;
			}
			chunked_send ("</table>\r\n\0", sock);
		}


		chunked_send ("<br><b>(C) Copyright 2018 JARL D-STAR Committee</b>\r\n\0", sock);
		chunked_send ("</body></html>\r\n\0", sock);


		/* Treminate (Last) for Chunked */
		send (sock, "0\r\n\r\n", 5, 0);

	}
	
}
