﻿Imports System.Windows.Forms.WebBrowser
Imports Microsoft.VisualBasic.FileIO

Public Class Main

    Public StopFlg As Boolean '停止用フラグ
    Dim DtCSv As New DataTable  'CSV読み込み用データテーブル
    Dim idx As Integer  'データテーブルの現在idx
    Dim MAXidx As Integer   '取得最大件数（表示用）
    Dim rowidx As Integer
    'WEBページ非同期処理待機用フラグ
    Dim ContOK As Boolean = False


    Private Sub Main_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        '組み込みブラウザのIEバージョン変更
        Dim myreg As New RegistryControl
        myreg.SetBrowberChange("AAC")

        'ヴァージョンを表示
        LblVer.Text = Application.ProductVersion
        Me.Text = Me.Text & "(Ver." & Application.ProductVersion & ")"
        'main()
    End Sub

    Private Sub main()
        '読み込んだCSVの全行を対象にする
        'ただし途中で再開をさせるため、msgがNULLのものだけ

        For Each row As DataRow In DtCSv.Select("msg=''")
            '中止おされたか？
            If Not StopFlg Then
                ContOK = False
                idx += 1
                rowidx = row(4) '行番号取り出し
                DisplayControl(Trim(row(0).ToString), Trim(row(2).ToString))
                DisplayCnt(idx.ToString)
                AppleLogin_main()
            Else
                MessageBox.Show("処理を中止しました。" & vbCrLf & "再開を行うには、再開を押してください", "中止しました", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
                BtnRun.Enabled = True
                BtnRun.Text = "再開"
                Exit Sub
            End If
        Next
        MessageBox.Show("終了しました" & vbCrLf & Now.ToString, "終了しました", MessageBoxButtons.OK, MessageBoxIcon.Information)
        BtnRun.Enabled = True
        BtnRun.Text = "実行"
        PicLoad.Visible = False
    End Sub

    Private Sub AppleLogin_main()
        'Dim AppleIDURL As String = "https://appleid.apple.com/cgi-bin/WebObjects/MyAppleId.woa/wa/directToSignIn?localang=ja_JP"
        'Dim AppleIDURL As String = "https://appleid.apple.com/cgi-bin/WebObjects/MyAppleId.woa/198/wa/directToSignIn?wosid=eHKH3b53hLcMJI47Xs6gDM&localang=ja_JP"
        Dim AppleIDURL As String = "https://appleid.apple.com/"

        Dim elem As HtmlElement

        WebBrowser1.Navigate(AppleIDURL)
        '読み込み終了になるまで監視する
        'ページ遷移を待機
        While WebBrowser1.IsBusy OrElse WebBrowser1.ReadyState <> WebBrowserReadyState.Complete
            Application.DoEvents()
        End While

        For Each elem In WebBrowser1.Document.GetElementsByTagName("A")
            If elem.GetAttribute("className") = "bigblue full-width-button" Then
                elem.InvokeMember("click")
                Application.DoEvents()
                Exit For
            End If
        Next

        'ページ遷移を待機
        While WebBrowser1.IsBusy OrElse WebBrowser1.ReadyState <> WebBrowserReadyState.Complete
            Application.DoEvents()
        End While

        WebBrowser1_AppleIDLoginPageDocumentCompleted()
    End Sub

    '現在のメールボックスとアップルIDの表示
    Private Sub DisplayControl(ByVal argMailId As String, ByVal argAppleId As String)
        'LblAppleID.Text = argAppleId
        LblMailID.Text = argMailId
    End Sub

    Private Sub DisplayCnt(ByVal nowcnt As String)
        txtNowCnt.Text = nowcnt & "/" & MAXidx.ToString
    End Sub

    'AppleID確認ページ
    '    Private Sub WebBrowser1_AppleIDLoginPageDocumentCompleted(ByVal sender As Object, ByVal e As System.Windows.Forms.WebBrowserDocumentCompletedEventArgs)
    Private Sub WebBrowser1_AppleIDLoginPageDocumentCompleted()
        '正常の場合AppleID、とパスワードの入力が可能なので「GetElementsByID」でエレメントを取り出してみる
        'もし、エレメントが取り出せない場合は、異常なので、エラーを取り出すことを試みる
        'ページの構造が変わったら、その都度解析しなければならない
        Dim elem As HtmlElement
        Dim str As String
        Dim chk2 As String = "Apple ID またはパスワード"
        Const AppleIDERR As String = "入力された Apple ID またはパスワードが正しくありません。"
        Dim chk3 As String = "Apple ID は無効になっています"
        Const AppleIDCLOSE As String = "この Apple ID は無効になっています"

        '■AppleIDログインページ
        elem = WebBrowser1.Document.GetElementById("accountname")
        If Not IsNothing(elem) Then
            Dim drCsv As DataRow = DtCSv.Rows(rowidx - 1)
            'AppleID
            elem.SetAttribute("value", Trim(drCsv(0).ToString))

            Try
                'AppleIDパスワード
                elem = WebBrowser1.Document.GetElementById("accountpassword")
                elem.SetAttribute("value", Trim(drCsv(1).ToString))
            Catch ex As Exception
                drCsv(2) = "ページ遷移が不安定のためスキップ"
                drCsv(3) = 1
                Exit Sub
            End Try
            elem = WebBrowser1.Document.GetElementById("bot-nav").Children(0)

            If elem.TagName = "A" Then
                AddHandler WebBrowser1.DocumentCompleted, AddressOf WebBrowser1_GetAppleIDLastPageDocumentCompleted
                elem.InvokeMember("click")
                Application.DoEvents()

            End If

            While WebBrowser1.IsBusy OrElse WebBrowser1.ReadyState <> WebBrowserReadyState.Complete
                Application.DoEvents()
            End While

            'AppleIDかパスワードがエラーの場合の対応
            'エラーがあるならエラーテキストを取り出して終了
            ''If InStr(WebBrowser1.Document.Body.InnerText, chk2) > 0 Then
            ''    drCsv(2) = AppleIDERR
            ''    drCsv(3) = 1
            ''ElseIf InStr(WebBrowser1.Document.Body.InnerText, chk3) > 0 Then
            ''    drCsv(2) = AppleIDCLOSE
            ''    drCsv(3) = 1
            ''Else
            ''    '正常終了→次ページへ
            ''    'WebBrowser1_GetAppleIDLastPageDocumentCompleted()
            ''End If
            DtCSv.AcceptChanges()

            'AddHandler WebBrowser1.DocumentCompleted, AddressOf WebBrowser1_GetAppleIDLastPageDocumentCompleted
            'Application.DoEvents()
        Else
            'エラー
            Dim drCsv As DataRow = DtCSv.Rows(rowidx - 1)
            'Dim drCsv As DataRow = DtCSv.Select("msg=''")(idx - 1)
            Try
                str = WebBrowser1.Document.GetElementById("intro").InnerText
                drCsv(2) = str
                drCsv(3) = 1
                DtCSv.AcceptChanges()
            Catch ex As Exception
                MessageBox.Show("セッションが期限切れです。画面内の右下から再送ボタンを押してください", "セッション期限切れ", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
                StopFlg = True
            End Try
            'MessageBox.Show(str)
            'エラーならここで終了
        End If

        '永久ループ
        'Do Until ContOK
        '    Application.DoEvents()
        'Loop
  
    End Sub

    'AppleID確認ページ専用
    '最終的なメッセージを取得するだけ
    Private Sub WebBrowser1_GetAppleIDLastPageDocumentCompleted(ByVal sender As Object, ByVal e As System.Windows.Forms.WebBrowserDocumentCompletedEventArgs)
        'Private Sub WebBrowser1_GetAppleIDLastPageDocumentCompleted()
        Dim str As String
        Dim chk1 As String = "名前、ID、メールアドレスの管理"
        Dim chk2 As String = "Apple ID またはパスワード"
        '        Dim chk2 As String = "Apple ID またはパスワードが正しくありません。"
        Dim chk3 As String = "この Apple ID は無効になっています"
        Dim chk4 As String = "パスワードを強化します。"
        '入力された Apple ID またはパスワードが正しくありません。
        Dim drCsv As DataRow = DtCSv.Rows(rowidx - 1)
        Dim elemLogout As HtmlElement

        RemoveHandler WebBrowser1.DocumentCompleted, AddressOf WebBrowser1_GetAppleIDLastPageDocumentCompleted

        Try
            'AppleIDかパスワードエラー対応
            If InStr(WebBrowser1.Document.Body.InnerText, chk2) > 0 Then
                str = chk2
                drCsv(3) = 1
                ContOK = True
            ElseIf InStr(WebBrowser1.Document.Body.InnerText, chk3) > 0 Then
                str = chk3
                drCsv(3) = 1
                ContOK = True
                '//2014/09/12 パスワードポリシー強化に伴う修正
            ElseIf InStr(WebBrowser1.Document.Body.InnerText, chk4) > 0 Then
                str = chk4
                drCsv(3) = 1
                ContOK = True
            Else
                str = ""
            End If
        Catch ex As Exception
            str = ex.Message
        End Try

        'ログインエラー以外を対応
        If str = "" Then
            '認証の時は、このIDがあるが、それ以外の場合、文字列判定
            Try
                '未承認ページ
                str = WebBrowser1.Document.GetElementById("intro").InnerText
                drCsv(3) = 1
            Catch exn As Exception
                '承認ページ
                If InStr(WebBrowser1.Document.Body.InnerHtml, chk1) > 0 Then
                    str = "承認済み"
                    drCsv(3) = 0
                Else
                    str = "未承認"
                    drCsv(3) = 1
                End If
            End Try
            'ログアウトしないと途中でURL変更を許可してくれない
            'エレメントを探す
            For Each elemAddr In WebBrowser1.Document.GetElementsByTagName("DIV")
                'If elemAddr.GetAttribute("className") = "logo" Then
                If elemAddr.GetAttribute("className") = "logo middle-body" Then
                    'elemLogout = elemAddr.Children.Item(0)
                    elemLogout = DirectCast(elemAddr.Children.Item(1), System.Windows.Forms.HtmlElement).Children(1)
                    'ログアウト
                    If elemLogout.TagName = "A" Then
                        AddHandler WebBrowser1.DocumentCompleted, AddressOf WebBrowser1_GetAppleIDLogOutCompleted
                        elemLogout.InvokeMember("click")
                        Application.DoEvents()
                        Exit For
                    End If
                End If
            Next

            'ページ遷移を待機
            While WebBrowser1.IsBusy OrElse WebBrowser1.ReadyState <> WebBrowserReadyState.Complete
                Application.DoEvents()
            End While

        End If
        drCsv(2) = str
        'DtCSv.AcceptChanges()
        ' MessageBox.Show(str)
        'RemoveHandler WebBrowser1.DocumentCompleted, AddressOf WebBrowser1_GetAppleIDLastPageDocumentCompleted
    End Sub

    'ログアウト
    Private Sub WebBrowser1_GetAppleIDLogOutCompleted(ByVal sender As Object, ByVal e As System.Windows.Forms.WebBrowserDocumentCompletedEventArgs)
        RemoveHandler WebBrowser1.DocumentCompleted, AddressOf WebBrowser1_GetAppleIDLogOutCompleted
        ContOK = True
    End Sub

    Private Sub BtnRun_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BtnRun.Click
        'CSV読み込んでいるかチェック
        If DtCSv.Rows.Count = 0 Then
            MessageBox.Show("先に認証用CSVを読み込んでください", "CSVを読み込んでください", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
            TabControl1.SelectTab(0)
            Exit Sub
        End If
        '再開か否かの判断
        'メッセージがNULLの件数が０なら初期、それ以外は空白件数
        If DtCSv.Select("msg<>''").Length = 0 Then
            idx = 0
            'インデックスの初期値の設定
            MAXidx = DtCSv.Select("msg=''").Length
        Else
            idx = DtCSv.Select("msg<>''").Length
        End If
        StopFlg = False
        BtnRun.Enabled = False
        BtnStop.Enabled = True
        PicLoad.Visible = True

        main()
    End Sub

    Private Sub BtnStop_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BtnStop.Click
        StopFlg = True  '停止フラグ更新
        BtnRun.Enabled = True   '実行ボタンを有効に
        PicLoad.Visible = False '右上画像を非表示に
    End Sub

    'ファイル読み込みボタン
    'すべてを初期化する
    Private Sub btnChoiceFile_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnChoiceFile.Click
        Dim cnt As Integer
        'ファイルオープンダイアログ表示
        If OpenFileDialog1.ShowDialog() = DialogResult.OK Then
            TxtFilePath.Text = OpenFileDialog1.FileName
            BtnRun.Enabled = True
            BtnRun.Text = "開始"
        Else
            Exit Sub
        End If

        'ファイルをセパレートで一度全部読み込み、データセットへ展開する
        'データテーブルチェック
        If DtCSv.TableName <> "CSV" Then
            DtCSv = CSVtype()
        Else
            DtCSv.Rows.Clear()  'CSV内容全消去
        End If

        Dim drCsv As DataRow
        Dim parser As New TextFieldParser(TxtFilePath.Text)
        parser.TextFieldType = FieldType.Delimited
        parser.SetDelimiters(",") ' 区切り文字はコンマ
        While Not parser.EndOfData
            Dim row As String() = parser.ReadFields() ' 1行読み込み
            cnt += 1
            drCsv = DtCSv.NewRow()  '新規行
            '空白以外は取り込む
            'If row(0) <> "" Then
            '    drCsv(0) = row(0) 'ホスティングメール
            'Else
            '    cnt = DtCSv.Rows.Count + 1
            '    MessageBox.Show(cnt.ToString & " 行目のホスティングメールが空白です", "CSV読込チェック", MessageBoxButtons.OK, MessageBoxIcon.Warning)
            '    TxtFilePath.Text = ""
            '    Exit Sub
            'End If
            ''ホスティングメールパスワード
            'If row(1) <> "" Then
            '    drCsv(1) = row(1) 'ホスティングメールパスワード
            'Else
            '    cnt = DtCSv.Rows.Count + 1
            '    MessageBox.Show(cnt.ToString & " 行目のホスティングメールパスワードが空白です", "CSV読込チェック", MessageBoxButtons.OK, MessageBoxIcon.Warning)
            '    TxtFilePath.Text = ""
            '    Exit Sub
            'End If
            'AppleID
            If row(0) <> "" Then
                drCsv(0) = row(0) 'AppleID
            Else
                cnt = DtCSv.Rows.Count + 1
                MessageBox.Show(cnt.ToString & " 行目のAppleIDが空白です", "CSV読込チェック", MessageBoxButtons.OK, MessageBoxIcon.Warning)
                TxtFilePath.Text = ""
                Exit Sub
            End If
            'AppleIDパスワード
            If row(1) <> "" Then
                drCsv(1) = row(1) 'AppleIDパスワード
            Else
                cnt = DtCSv.Rows.Count + 1
                MessageBox.Show(cnt.ToString & " 行目のAppleIDパスワードが空白です", "CSV読込チェック", MessageBoxButtons.OK, MessageBoxIcon.Warning)
                TxtFilePath.Text = ""
                Exit Sub
            End If
            drCsv(2) = "" 'AppleID認証後のメッセージ格納
            drCsv(4) = cnt    '行数
            DtCSv.Rows.Add(drCsv)   '行追加
        End While
        DtCSv.AcceptChanges()

        'データビューへ設定
        'バインディングは自動
        DGCSV.DataSource = DtCSv
        'DGCSV.DataMember = "CSV"

        '各カラムに対して幅を指定する
        For Each c As DataGridViewColumn In DGCSV.Columns
            Select Case c.Index
                Case 0   'メールアドレス
                    c.Width = 125
                Case 1   'パスワード
                    c.Width = 80
                Case 2  'メッセージ
                    c.Width = 317
                Case 3  'エラーフラグ
                    c.Width = 27
                Case 4  '項番
                    c.Width = 30
            End Select
            'ソートを不可にする
            c.SortMode = DataGridViewColumnSortMode.NotSortable
        Next c

        'ループ用インデックスを初期化
        idx = 0
    End Sub

    'CSV取り込み用データテーブル定義
    Public Function CSVtype() As DataTable
        Dim dtCSV As New DataTable
        With dtCSV
            '.Columns.Add("MailAddress")     'ホスティングメール0
            '.Columns.Add("MailPassword")    'ホスティングメールパスワード1
            .Columns.Add("AppleID")         'AppleID0
            .Columns.Add("AppleIDPassword") 'AppleIDパスワード1
            .Columns.Add("msg").DefaultValue = DBNull.Value 'AppleID認証後のメッセージ格納2
            .Columns.Add("Error").DefaultValue = 0  'エラー行は１ 3
            .Columns.Add("No")  '行数 4
            '.Columns.Add("time")  '日時 5
            .TableName = "CSV"
        End With
        Return dtCSV.Clone
    End Function

    'CSV出力ボタン
    Private Sub BtnOutPut_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BtnOutPut.Click
        SaveToCsv(DGCSV)
    End Sub

    '保存したいDataGridViewコントロールの名前を引数として
    '設定します。
    Public Sub SaveToCsv(ByVal tempDgv As DataGridView)

        '1行もデータが無い場合は、保存を中止します。
        If tempDgv.Rows.Count = 0 Then
            Exit Sub
        End If

        '変数を定義します。
        Dim i As Integer
        Dim j As Integer
        Dim strFileName As String
        Dim strResult As New System.Text.StringBuilder

        '保存ダイアログでファイル名を設定した場合に処理を実行します。
        If Me.sfdCsvFile.ShowDialog = _
          Windows.Forms.DialogResult.OK Then

            'コラムヘッダを1行目に列記します。
            '※ヘッダ行が不要な場合は削除可能です。
            For i = 0 To tempDgv.Columns.Count - 1
                Select Case i
                    Case 0
                        strResult.Append("""" & _
                        tempDgv.Columns(i).HeaderText.ToString & """")

                    Case tempDgv.Columns.Count - 1
                        strResult.Append("," & """" & _
                        tempDgv.Columns(i).HeaderText.ToString & _
                        """" & vbCrLf)

                    Case Else
                        strResult.Append("," & """" & _
                        tempDgv.Columns(i).HeaderText.ToString & """")
                End Select

            Next

            'データを保存します。
            '※新規行の追加を認めている場合は、次行の「tempDgv.Columns.Count - 1」を
            '「tempDgv.Columns.Count - 2」としてください。
            For i = 0 To tempDgv.Rows.Count - 1
                For j = 0 To tempDgv.Columns.Count - 1
                    Select Case j
                        Case 0
                            strResult.Append("""" & _
                            tempDgv.Rows(i).Cells(j).Value.ToString & _
                            """")

                        Case tempDgv.Columns.Count - 1
                            strResult.Append("," & """" & _
                            tempDgv.Rows(i).Cells(j).Value.ToString & _
                            """" & vbCrLf)

                        Case Else
                            strResult.Append("," & """" & _
                            tempDgv.Rows(i).Cells(j).Value.ToString & _
                            """")
                    End Select

                Next
            Next

            'ファイル名を保存ダイアログで指定した値に設定します。
            strFileName = Me.sfdCsvFile.FileName

            'Shift-JISで保存します。
            Dim swText As New System.IO.StreamWriter(strFileName, _
              False, System.Text.Encoding.GetEncoding(932))
            swText.Write(strResult.ToString)
            swText.Dispose()

        End If

    End Sub

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        If DtCSv.TableName <> "CSV" Then
            Exit Sub
        Else
            DtCSv.WriteXml("debug_output.xml", XmlWriteMode.WriteSchema)
            MessageBox.Show("デバック用XML出力した！！")
        End If
    End Sub

End Class

