package com.mxmobiling.kitting;
import java.io.IOException;

import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class VPN {

	public static final String STRING = "string";
	public static final String INTEGER = "integer";
	public static final String DATA = "data";

	public VPN() {
	}

	/*
	 * EAP
	 * 
	 * なぞのパラメータ
	 */
	public void EAP(Element PayloadContentDict, Document document) {
		Element EAPKey = document.createElement("key");
		PayloadContentDict.appendChild(EAPKey);

		Text EAPKeyParam = document.createTextNode("EAP");
		EAPKey.appendChild(EAPKeyParam);

		Element EAPDict = document.createElement("dict");
		PayloadContentDict.appendChild(EAPDict);
	}

	/*
	 * IPSecRoot
	 * 
	 * IPSecの情報
	 * 
	 * AuthenticationMethod＝ユーザ認証、SharedSecret＝共有シークレット
	 */
	public void L2TP_IPSecRoot(Element PayloadContentDict, Document document,
			String authenticationMethod, String sharedSecret)
			throws IOException, InterruptedException {
		/*
		 * IPSec
		 * 
		 * IPSecのルート
		 */
		Element IPSecKey = document.createElement("key");
		PayloadContentDict.appendChild(IPSecKey);

		Text IPSecKeyParam = document.createTextNode("IPSec");
		IPSecKey.appendChild(IPSecKeyParam);

		Element IPSecDict = document.createElement("dict");
		PayloadContentDict.appendChild(IPSecDict);

		/*
		 * AuthenticationMethod
		 * 
		 * ユーザー認証の方式
		 */
		Element AuthenticationMethodKey = document.createElement("key");
		IPSecDict.appendChild(AuthenticationMethodKey);

		Text AuthenticationMethodKeyParam = document
				.createTextNode("AuthenticationMethod");
		AuthenticationMethodKey.appendChild(AuthenticationMethodKeyParam);

		Element AuthenticationMethodString = document.createElement(STRING);
		IPSecDict.appendChild(AuthenticationMethodString);

		Text AuthenticationMethodStringParam = document
				.createTextNode(authenticationMethod);
		AuthenticationMethodString.appendChild(AuthenticationMethodStringParam);

		/*
		 * SharedSecret
		 * 
		 * 共有シークレット
		 * 
		 * Base64形式へのエンコードが必要なため、処理が多め
		 */
		Element SharedSecretKey = document.createElement("key");
		IPSecDict.appendChild(SharedSecretKey);

		Text SharedSecretKeyParam = document.createTextNode("SharedSecret");
		SharedSecretKey.appendChild(SharedSecretKeyParam);

		Element SharedSecretString = document.createElement(DATA);
		IPSecDict.appendChild(SharedSecretString);

		// 共有シークレットをBase64へ変換し、返す
		Text SharedSecretStringParam = document
				.createTextNode(encodeBase64(sharedSecret));
		SharedSecretString.appendChild(SharedSecretStringParam);
	}

	/*
	 * IPSecRoot
	 * 
	 * IPSecの情報
	 * 
	 * AuthenticationMethod＝ユーザ認証、LocalIdenfier＝VPNのグループ、LocalIdenfierType＝なぞのパラメータ
	 * RemoteAddress＝サーバー、SharedSecret＝共有シークレット、XAuthEnabled＝なぞのパラメータ
	 * XAuthName＝VPNのアカウント、XAuthPassword＝VPNのパスワード
	 */
	public void IPSec_IPSecRoot(Element PayloadContentDict, Document document,
			String authenticationMethod, String localIdentifier,
			String localIdentifierType, String remoteAddress,
			String sharedSecret, String xAuthEnabled, String xAuthName,
			String xAuthPassword) throws IOException, InterruptedException {
		/*
		 * IPSec
		 * 
		 * IPSecのルート
		 */
		Element IPSecKey = document.createElement("key");
		PayloadContentDict.appendChild(IPSecKey);

		Text IPSecKeyParam = document.createTextNode("IPSec");
		IPSecKey.appendChild(IPSecKeyParam);

		Element IPSecDict = document.createElement("dict");
		PayloadContentDict.appendChild(IPSecDict);

		/*
		 * AuthenticationMethod
		 * 
		 * ユーザー認証の方式
		 */
		Element AuthenticationMethodKey = document.createElement("key");
		IPSecDict.appendChild(AuthenticationMethodKey);

		Text AuthenticationMethodKeyParam = document
				.createTextNode("AuthenticationMethod");
		AuthenticationMethodKey.appendChild(AuthenticationMethodKeyParam);

		Element AuthenticationMethodString = document.createElement(STRING);
		IPSecDict.appendChild(AuthenticationMethodString);

		Text AuthenticationMethodStringParam = document
				.createTextNode(authenticationMethod);
		AuthenticationMethodString.appendChild(AuthenticationMethodStringParam);

		/*
		 * LocalIdentifier
		 * 
		 * VPNのグループ
		 */
		Element LocalIdentifierKey = document.createElement("key");
		IPSecDict.appendChild(LocalIdentifierKey);

		Text LocalIdentifierKeyParam = document
				.createTextNode("LocalIdentifier");
		LocalIdentifierKey.appendChild(LocalIdentifierKeyParam);

		Element LocalIdentifierString = document.createElement(STRING);
		IPSecDict.appendChild(LocalIdentifierString);

		Text LocalIdentifierStringParam = document
				.createTextNode(localIdentifier);
		LocalIdentifierString.appendChild(LocalIdentifierStringParam);

		/*
		 * LocalIdentifierType
		 * 
		 * なぞのパラメータ
		 */
		Element LocalIdentifierTypeKey = document.createElement("key");
		IPSecDict.appendChild(LocalIdentifierTypeKey);

		Text LocalIdentifierTypeKeyParam = document
				.createTextNode("LocalIdentifierType");
		LocalIdentifierTypeKey.appendChild(LocalIdentifierTypeKeyParam);

		Element LocalIdentifierTypeString = document.createElement(STRING);
		IPSecDict.appendChild(LocalIdentifierTypeString);

		Text LocalIdentifierTypeStringParam = document
				.createTextNode(localIdentifierType);
		LocalIdentifierTypeString.appendChild(LocalIdentifierTypeStringParam);

		/*
		 * RemoteAddress
		 * 
		 * サーバー
		 */
		Element RemoteAddressKey = document.createElement("key");
		IPSecDict.appendChild(RemoteAddressKey);

		Text RemoteAddressKeyParam = document.createTextNode("RemoteAddress");
		RemoteAddressKey.appendChild(RemoteAddressKeyParam);

		Element RemoteAddressString = document.createElement(STRING);
		IPSecDict.appendChild(RemoteAddressString);

		Text RemoteAddressStringParam = document.createTextNode(remoteAddress);
		RemoteAddressString.appendChild(RemoteAddressStringParam);

		/*
		 * SharedSecret
		 * 
		 * 共有シークレット
		 * 
		 * Base64形式へのエンコードが必要なため、処理が多め
		 */
		Element SharedSecretKey = document.createElement("key");
		IPSecDict.appendChild(SharedSecretKey);

		Text SharedSecretKeyParam = document.createTextNode("SharedSecret");
		SharedSecretKey.appendChild(SharedSecretKeyParam);

		Element SharedSecretString = document.createElement(DATA);
		IPSecDict.appendChild(SharedSecretString);

		// 共有シークレットをBase64へ変換し、返す
		Text SharedSecretStringParam = document
				.createTextNode(encodeBase64(sharedSecret));
		SharedSecretString.appendChild(SharedSecretStringParam);

		/*
		 * XAuthEnabled
		 * 
		 * なぞのパラメータ
		 */
		Element XAuthEnabledKey = document.createElement("key");
		IPSecDict.appendChild(XAuthEnabledKey);

		Text XAuthEnabledKeyParam = document.createTextNode("XAuthEnabled");
		XAuthEnabledKey.appendChild(XAuthEnabledKeyParam);

		Element XAuthEnabledString = document.createElement(STRING);
		IPSecDict.appendChild(XAuthEnabledString);

		Text XAuthEnabledStringParam = document.createTextNode(xAuthEnabled);
		XAuthEnabledString.appendChild(XAuthEnabledStringParam);

		/*
		 * XAuthName
		 * 
		 * VPNのアカウント
		 */
		Element XAuthNameKey = document.createElement("key");
		IPSecDict.appendChild(XAuthNameKey);

		Text XAuthNameKeyParam = document.createTextNode("XAuthName");
		XAuthNameKey.appendChild(XAuthNameKeyParam);

		Element XAuthNameString = document.createElement(STRING);
		IPSecDict.appendChild(XAuthNameString);

		Text XAuthNameStringParam = document.createTextNode(xAuthName);
		XAuthNameString.appendChild(XAuthNameStringParam);

		/*
		 * XAuthPassword
		 * 
		 * VPNのパスワード
		 */
		Element XAuthPasswordKey = document.createElement("key");
		IPSecDict.appendChild(XAuthPasswordKey);

		Text XAuthPasswordKeyParam = document.createTextNode("XAuthPassword");
		XAuthPasswordKey.appendChild(XAuthPasswordKeyParam);

		Element XAuthPasswordString = document.createElement(STRING);
		IPSecDict.appendChild(XAuthPasswordString);

		Text XAuthPasswordStringParam = document.createTextNode(xAuthPassword);
		XAuthPasswordString.appendChild(XAuthPasswordStringParam);
	}

	/*
	 * IPv4(OverridePrimary)
	 * 
	 * トラフィックをすべてVPNインターフェイス経由で伝送するか否かを指定する
	 * 
	 * 「true(1)」ならネットワークトラフィックはすべてVPN経由で送信される
	 * 
	 * （すべてのトラフィックを送信）
	 */
	public void IPv4(Element PayloadContentDict, Document document,
			String overridePrimary) {
		Element IPv4Key = document.createElement("key");
		PayloadContentDict.appendChild(IPv4Key);

		Text IPv4KeyParam = document.createTextNode("IPv4");
		IPv4Key.appendChild(IPv4KeyParam);

		Element OverridePrimaryDict = document.createElement("dict");
		PayloadContentDict.appendChild(OverridePrimaryDict);

		Element OverridePrimaryKey = document.createElement("key");
		OverridePrimaryDict.appendChild(OverridePrimaryKey);

		Text OverridePrimaryKeyParam = document
				.createTextNode("OverridePrimary");
		OverridePrimaryKey.appendChild(OverridePrimaryKeyParam);

		Element OverrideString = document.createElement(INTEGER);
		OverridePrimaryDict.appendChild(OverrideString);

		Text OverridePrimaryStringParam = document
				.createTextNode(overridePrimary);
		OverrideString.appendChild(OverridePrimaryStringParam);
	}

	/*
	 * PPP(パスワードあり)
	 * 
	 * PPP(パスワードあり)の情報
	 * 
	 * AuthName＝アカウント、AuthPassword＝パスワード、サーバー＝CommRemoteAddress
	 */
	public void L2TP_PPP_PassRoot(Element PayloadContentDict,
			Document document, String authName, String authPassword,
			String commRemoteAddress) {
		/*
		 * PPP
		 * 
		 * PPPのルート
		 */
		Element PPPKey = document.createElement("key");
		PayloadContentDict.appendChild(PPPKey);

		Text PPPKeyParam = document.createTextNode("PPP");
		PPPKey.appendChild(PPPKeyParam);

		Element PPPRootDict = document.createElement("dict");
		PayloadContentDict.appendChild(PPPRootDict);

		/*
		 * AuthName
		 * 
		 * アカウント名
		 */
		Element AuthNameKey = document.createElement("key");
		PPPRootDict.appendChild(AuthNameKey);

		Text AuthNameKeyParam = document.createTextNode("AuthName");
		AuthNameKey.appendChild(AuthNameKeyParam);

		Element AuthNameString = document.createElement(STRING);
		PPPRootDict.appendChild(AuthNameString);

		Text AuthNameStringParam = document.createTextNode(authName);
		AuthNameString.appendChild(AuthNameStringParam);

		/*
		 * AuthPassword
		 * 
		 * パスワード
		 */
		Element AuthPasswordKey = document.createElement("key");
		PPPRootDict.appendChild(AuthPasswordKey);

		Text AuthPasswordKeyParam = document.createTextNode("AuthPassword");
		AuthPasswordKey.appendChild(AuthPasswordKeyParam);

		Element AuthPasswordString = document.createElement(STRING);
		PPPRootDict.appendChild(AuthPasswordString);

		Text AuthPasswordStringParam = document.createTextNode(authPassword);
		AuthPasswordString.appendChild(AuthPasswordStringParam);

		/*
		 * CommRemoteAddress
		 * 
		 * サーバーのアドレス
		 */
		Element RemoteAddressKey = document.createElement("key");
		PPPRootDict.appendChild(RemoteAddressKey);

		Text RemoteAddressKeyParam = document
				.createTextNode("CommRemoteAddress");
		RemoteAddressKey.appendChild(RemoteAddressKeyParam);

		Element RemoteAddressString = document.createElement(STRING);
		PPPRootDict.appendChild(RemoteAddressString);

		Text RemoteAddressStringParam = document
				.createTextNode(commRemoteAddress);
		RemoteAddressString.appendChild(RemoteAddressStringParam);
	}

	/*
	 * PPP(パスワードなし)
	 * 
	 * PPP(パスワードなし)の情報
	 * 
	 * AuthEAPPlugins＝なぞのパラメータ、AuthName＝アカウント、AuthProtocol＝なぞのパラメータ
	 * CommRemoteAddress＝サーバー、TokenCard＝なぞのパラメータ
	 */
	public void L2TP_PPP_NonPassRoot(Element PayloadContentDict,
			Document document, String authEAPPlugins, String authName,
			String authProtocol, String commRemoteAddress, Boolean tokenCard) {
		/*
		 * PPP
		 * 
		 * PPPのルート
		 */
		Element PPPKey = document.createElement("key");
		PayloadContentDict.appendChild(PPPKey);

		Text PPPKeyParam = document.createTextNode("PPP");
		PPPKey.appendChild(PPPKeyParam);

		Element PPPRootDict = document.createElement("dict");
		PayloadContentDict.appendChild(PPPRootDict);

		/*
		 * AuthEAPPlugins
		 * 
		 * なぞのパラメータ
		 */
		Element AuthEAPPluginsKey = document.createElement("key");
		PPPRootDict.appendChild(AuthEAPPluginsKey);

		Text AuthEAPPluginsKeyParam = document.createTextNode("AuthEAPPlugins");
		AuthEAPPluginsKey.appendChild(AuthEAPPluginsKeyParam);

		Element AuthEAPPluginsArray = document.createElement("array");
		PPPRootDict.appendChild(AuthEAPPluginsArray);

		Element AuthEAPPluginsString = document.createElement(STRING);
		AuthEAPPluginsArray.appendChild(AuthEAPPluginsString);

		Text AuthEAPPluginsStringParam = document
				.createTextNode(authEAPPlugins);
		AuthEAPPluginsString.appendChild(AuthEAPPluginsStringParam);

		/*
		 * AuthName
		 * 
		 * アカウント名
		 */
		Element AuthNameKey = document.createElement("key");
		PPPRootDict.appendChild(AuthNameKey);

		Text AuthNameKeyParam = document.createTextNode("AuthName");
		AuthNameKey.appendChild(AuthNameKeyParam);

		Element AuthNameString = document.createElement(STRING);
		PPPRootDict.appendChild(AuthNameString);

		Text AuthNameStringParam = document.createTextNode(authName);
		AuthNameString.appendChild(AuthNameStringParam);

		/*
		 * AuthProtocol
		 * 
		 * なぞのパラメータ
		 */
		Element AuthProtocolKey = document.createElement("key");
		PPPRootDict.appendChild(AuthProtocolKey);

		Text AuthProtocolKeyParam = document.createTextNode("AuthProtocol");
		AuthProtocolKey.appendChild(AuthProtocolKeyParam);

		Element AuthProtocolArray = document.createElement("array");
		PPPRootDict.appendChild(AuthProtocolArray);

		Element AuthProtocolString = document.createElement(STRING);
		AuthProtocolArray.appendChild(AuthProtocolString);

		Text AuthProtocolStringParam = document.createTextNode(authProtocol);
		AuthProtocolString.appendChild(AuthProtocolStringParam);

		/*
		 * CommRemoteAddress
		 * 
		 * サーバーのアドレス
		 */
		Element RemoteAddressKey = document.createElement("key");
		PPPRootDict.appendChild(RemoteAddressKey);

		Text RemoteAddressKeyParam = document
				.createTextNode("CommRemoteAddress");
		RemoteAddressKey.appendChild(RemoteAddressKeyParam);

		Element RemoteAddressString = document.createElement(STRING);
		PPPRootDict.appendChild(RemoteAddressString);

		Text RemoteAddressStringParam = document
				.createTextNode(commRemoteAddress);
		RemoteAddressString.appendChild(RemoteAddressStringParam);

		/*
		 * TokenCard
		 * 
		 * RSA SecurIDを用いるかどうか。基本true固定
		 */
		Element TokenCardKey = document.createElement("key");
		PPPRootDict.appendChild(TokenCardKey);

		Text TokenCardKeyParam = document.createTextNode("TokenCard");
		TokenCardKey.appendChild(TokenCardKeyParam);

		Element TokenCardString = document.createElement(String
				.valueOf(tokenCard));
		PPPRootDict.appendChild(TokenCardString);

	}

	public void PPTP_PPP_PassRoot(Element PayloadContentDict,
			Document document, String authName, String authPassword,
			String CCPEnabled, String CCPMPPE128Enabled,
			String CCPMPPE40Enabled, String commRemoteAddress) {
		/*
		 * PPP
		 * 
		 * PPPのルート
		 */
		Element PPPKey = document.createElement("key");
		PayloadContentDict.appendChild(PPPKey);

		Text PPPKeyParam = document.createTextNode("PPP");
		PPPKey.appendChild(PPPKeyParam);

		Element PPPRootDict = document.createElement("dict");
		PayloadContentDict.appendChild(PPPRootDict);

		/*
		 * AuthName
		 * 
		 * アカウント名
		 */
		Element AuthNameKey = document.createElement("key");
		PPPRootDict.appendChild(AuthNameKey);

		Text AuthNameKeyParam = document.createTextNode("AuthName");
		AuthNameKey.appendChild(AuthNameKeyParam);

		Element AuthNameString = document.createElement(STRING);
		PPPRootDict.appendChild(AuthNameString);

		Text AuthNameStringParam = document.createTextNode(authName);
		AuthNameString.appendChild(AuthNameStringParam);

		/*
		 * AuthPassword
		 * 
		 * パスワード
		 */
		Element AuthPasswordKey = document.createElement("key");
		PPPRootDict.appendChild(AuthPasswordKey);

		Text AuthPasswordKeyParam = document.createTextNode("AuthPassword");
		AuthPasswordKey.appendChild(AuthPasswordKeyParam);

		Element AuthPasswordString = document.createElement(STRING);
		PPPRootDict.appendChild(AuthPasswordString);

		Text AuthPasswordStringParam = document.createTextNode(authPassword);
		AuthPasswordString.appendChild(AuthPasswordStringParam);

		/*
		 * CCPEnabled
		 * 
		 * なぞのパラメータ
		 */
		Element CCPEnabledKey = document.createElement("key");
		PPPRootDict.appendChild(CCPEnabledKey);

		Text CCPEnabledKeyParam = document.createTextNode("CCPEnabled");
		CCPEnabledKey.appendChild(CCPEnabledKeyParam);

		Element CCPEnabledString = document.createElement(INTEGER);
		PPPRootDict.appendChild(CCPEnabledString);

		Text CCPEnabledStringParam = document.createTextNode(CCPEnabled);
		CCPEnabledString.appendChild(CCPEnabledStringParam);

		/*
		 * CCPMPPE128Enabled
		 * 
		 * なぞのパラメータ
		 */
		Element CCPMPPE128EnabledKey = document.createElement("key");
		PPPRootDict.appendChild(CCPMPPE128EnabledKey);

		Text CCPMPPE128EnabledKeyParam = document
				.createTextNode("CCPMPPE128Enabled");
		CCPMPPE128EnabledKey.appendChild(CCPMPPE128EnabledKeyParam);

		Element CCPMPPE128EnabledString = document.createElement(INTEGER);
		PPPRootDict.appendChild(CCPMPPE128EnabledString);

		Text CCPMPPE128EnabledStringParam = document
				.createTextNode(CCPMPPE128Enabled);
		CCPMPPE128EnabledString.appendChild(CCPMPPE128EnabledStringParam);

		/*
		 * CCPMPPE40Enabled
		 * 
		 * なぞのパラメータ
		 */
		Element CCPMPPE40EnabledKey = document.createElement("key");
		PPPRootDict.appendChild(CCPMPPE40EnabledKey);

		Text CCPMPPE40EnabledKeyParam = document
				.createTextNode("CCPMPPE40Enabled");
		CCPMPPE40EnabledKey.appendChild(CCPMPPE40EnabledKeyParam);

		Element CCPMPPE40EnabledString = document.createElement(INTEGER);
		PPPRootDict.appendChild(CCPMPPE40EnabledString);

		Text CCPMPPE40EnabledStringParam = document
				.createTextNode(CCPMPPE40Enabled);
		CCPMPPE40EnabledString.appendChild(CCPMPPE40EnabledStringParam);

		/*
		 * CommRemoteAddress
		 * 
		 * サーバーのアドレス
		 */
		Element RemoteAddressKey = document.createElement("key");
		PPPRootDict.appendChild(RemoteAddressKey);

		Text RemoteAddressKeyParam = document
				.createTextNode("CommRemoteAddress");
		RemoteAddressKey.appendChild(RemoteAddressKeyParam);

		Element RemoteAddressString = document.createElement(STRING);
		PPPRootDict.appendChild(RemoteAddressString);

		Text RemoteAddressStringParam = document
				.createTextNode(commRemoteAddress);
		RemoteAddressString.appendChild(RemoteAddressStringParam);
	}

	public void PPTP_PPP_NonPassRoot(Element PayloadContentDict,
			Document document, String authEAPPlugins, String authName,
			String authProtocol, String CCPEnabled, String CCPMPPE128Enabled,
			String CCPMPPE40Enabled, String commRemoteAddress, Boolean tokenCard) {
		/*
		 * PPP
		 * 
		 * PPPのルート
		 */
		Element PPPKey = document.createElement("key");
		PayloadContentDict.appendChild(PPPKey);

		Text PPPKeyParam = document.createTextNode("PPP");
		PPPKey.appendChild(PPPKeyParam);

		Element PPPRootDict = document.createElement("dict");
		PayloadContentDict.appendChild(PPPRootDict);

		/*
		 * AuthEAPPlugins
		 * 
		 * なぞのパラメータ
		 */
		Element AuthEAPPluginsKey = document.createElement("key");
		PPPRootDict.appendChild(AuthEAPPluginsKey);

		Text AuthEAPPluginsKeyParam = document.createTextNode("AuthEAPPlugins");
		AuthEAPPluginsKey.appendChild(AuthEAPPluginsKeyParam);

		Element AuthEAPPluginsArray = document.createElement("array");
		PPPRootDict.appendChild(AuthEAPPluginsArray);

		Element AuthEAPPluginsString = document.createElement(STRING);
		AuthEAPPluginsArray.appendChild(AuthEAPPluginsString);

		Text AuthEAPPluginsStringParam = document
				.createTextNode(authEAPPlugins);
		AuthEAPPluginsString.appendChild(AuthEAPPluginsStringParam);

		/*
		 * AuthName
		 * 
		 * アカウント名
		 */
		Element AuthNameKey = document.createElement("key");
		PPPRootDict.appendChild(AuthNameKey);

		Text AuthNameKeyParam = document.createTextNode("AuthName");
		AuthNameKey.appendChild(AuthNameKeyParam);

		Element AuthNameString = document.createElement(STRING);
		PPPRootDict.appendChild(AuthNameString);

		Text AuthNameStringParam = document.createTextNode(authName);
		AuthNameString.appendChild(AuthNameStringParam);

		/*
		 * AuthProtocol
		 * 
		 * なぞのパラメータ
		 */
		Element AuthProtocolKey = document.createElement("key");
		PPPRootDict.appendChild(AuthProtocolKey);

		Text AuthProtocolKeyParam = document.createTextNode("AuthProtocol");
		AuthEAPPluginsKey.appendChild(AuthProtocolKeyParam);

		Element AuthProtocolArray = document.createElement("array");
		PPPRootDict.appendChild(AuthProtocolArray);

		Element AuthProtocolString = document.createElement(STRING);
		AuthProtocolArray.appendChild(AuthProtocolString);

		Text AuthProtocolStringParam = document.createTextNode(authProtocol);
		AuthProtocolString.appendChild(AuthProtocolStringParam);

		/*
		 * CCPEnabled
		 * 
		 * なぞのパラメータ
		 */
		Element CCPEnabledKey = document.createElement("key");
		PPPRootDict.appendChild(CCPEnabledKey);

		Text CCPEnabledKeyParam = document.createTextNode("CCPEnabled");
		CCPEnabledKey.appendChild(CCPEnabledKeyParam);

		Element CCPEnabledString = document.createElement(INTEGER);
		PPPRootDict.appendChild(CCPEnabledString);

		Text CCPEnabledStringParam = document.createTextNode(CCPEnabled);
		CCPEnabledString.appendChild(CCPEnabledStringParam);

		/*
		 * CCPMPPE128Enabled
		 * 
		 * なぞのパラメータ
		 */
		Element CCPMPPE128EnabledKey = document.createElement("key");
		PPPRootDict.appendChild(CCPMPPE128EnabledKey);

		Text CCPMPPE128EnabledKeyParam = document
				.createTextNode("CCPMPPE128Enabled");
		CCPMPPE128EnabledKey.appendChild(CCPMPPE128EnabledKeyParam);

		Element CCPMPPE128EnabledString = document.createElement(INTEGER);
		PPPRootDict.appendChild(CCPMPPE128EnabledString);

		Text CCPMPPE128EnabledStringParam = document
				.createTextNode(CCPMPPE128Enabled);
		CCPMPPE128EnabledString.appendChild(CCPMPPE128EnabledStringParam);

		/*
		 * CCPMPPE40Enabled
		 * 
		 * なぞのパラメータ
		 */
		Element CCPMPPE40EnabledKey = document.createElement("key");
		PPPRootDict.appendChild(CCPMPPE40EnabledKey);

		Text CCPMPPE40EnabledKeyParam = document
				.createTextNode("CCPMPPE40Enabled");
		CCPMPPE40EnabledKey.appendChild(CCPMPPE40EnabledKeyParam);

		Element CCPMPPE40EnabledString = document.createElement(INTEGER);
		PPPRootDict.appendChild(CCPMPPE40EnabledString);

		Text CCPMPPE40EnabledStringParam = document
				.createTextNode(CCPMPPE40Enabled);
		CCPMPPE40EnabledString.appendChild(CCPMPPE40EnabledStringParam);

		/*
		 * CommRemoteAddress
		 * 
		 * サーバーのアドレス
		 */
		Element RemoteAddressKey = document.createElement("key");
		PPPRootDict.appendChild(RemoteAddressKey);

		Text RemoteAddressKeyParam = document
				.createTextNode("CommRemoteAddress");
		RemoteAddressKey.appendChild(RemoteAddressKeyParam);

		Element RemoteAddressString = document.createElement(STRING);
		PPPRootDict.appendChild(RemoteAddressString);

		Text RemoteAddressStringParam = document
				.createTextNode(commRemoteAddress);
		RemoteAddressString.appendChild(RemoteAddressStringParam);

		/*
		 * TokenCard
		 * 
		 * RSA SecurIDを用いるかどうか。基本true固定
		 */
		Element TokenCardKey = document.createElement("key");
		PayloadContentDict.appendChild(TokenCardKey);

		Text TokenCardKeyParam = document.createTextNode("TokenCard");
		TokenCardKey.appendChild(TokenCardKeyParam);

		Element TokenCardString = document.createElement(String
				.valueOf(tokenCard));
		PayloadContentDict.appendChild(TokenCardString);
	}

	/*
	 * Proxies(なし)
	 * 
	 * プロキシが「なし」の場合
	 */
	public void ProxiesNone(Element PayloadContentDict, Document document) {
		Element ProxiesNoneKey = document.createElement("key");
		PayloadContentDict.appendChild(ProxiesNoneKey);

		Text ProxiesNoneKeyParam = document.createTextNode("Proxies");
		ProxiesNoneKey.appendChild(ProxiesNoneKeyParam);

		Element ProxiesNoneDict = document.createElement("dict");
		PayloadContentDict.appendChild(ProxiesNoneDict);
	}

	/*
	 * Proxies(手動)
	 * 
	 * プロキシが「手動」の場合
	 */
	public void ProxiesManual(Element PayloadContentDict, Document document,
			String HTTPEnable, String port, String server, String password,
			String userName, String HTTPSEnable) {

		/*
		 * Proxies
		 * 
		 * Proxiesのルート
		 */
		Element ProxiesManualKey = document.createElement("key");
		PayloadContentDict.appendChild(ProxiesManualKey);

		Text ProxiesManualKeyParam = document.createTextNode("Proxies");
		ProxiesManualKey.appendChild(ProxiesManualKeyParam);

		Element ProxiesManualDict = document.createElement("dict");
		PayloadContentDict.appendChild(ProxiesManualDict);

		/*
		 * HTTPEnable
		 * 
		 * HTTPプロキシ有効フラグ
		 */
		Element HTTPEnableKey = document.createElement("key");
		ProxiesManualDict.appendChild(HTTPEnableKey);

		Text HTTPEnableKeyParam = document.createTextNode("HTTPEnable");
		HTTPEnableKey.appendChild(HTTPEnableKeyParam);

		Element HTTPEnableString = document.createElement(INTEGER);
		ProxiesManualDict.appendChild(HTTPEnableString);

		Text HTTPEnableStringParam = document.createTextNode(HTTPEnable);
		HTTPEnableString.appendChild(HTTPEnableStringParam);

		/*
		 * HTTPPort
		 * 
		 * HTTPサーバーポート設定
		 */
		Element HTTPPortKey = document.createElement("key");
		ProxiesManualDict.appendChild(HTTPPortKey);

		Text HTTPPortKeyParam = document.createTextNode("HTTPPort");
		HTTPPortKey.appendChild(HTTPPortKeyParam);

		Element HTTPPortString = document.createElement(INTEGER);
		ProxiesManualDict.appendChild(HTTPPortString);

		Text HTTPPortStringParam = document.createTextNode(port);
		HTTPPortString.appendChild(HTTPPortStringParam);

		/*
		 * HTTPProxy
		 * 
		 * HTTPサーバー設定
		 */
		Element HTTPProxyKey = document.createElement("key");
		ProxiesManualDict.appendChild(HTTPProxyKey);

		Text HTTPProxyKeyParam = document.createTextNode("HTTPProxy");
		HTTPProxyKey.appendChild(HTTPProxyKeyParam);

		Element HTTPProxyString = document.createElement(STRING);
		ProxiesManualDict.appendChild(HTTPProxyString);

		Text HTTPProxyStringParam = document.createTextNode(server);
		HTTPProxyString.appendChild(HTTPProxyStringParam);

		/*
		 * HTTPProxyPassword
		 * 
		 * HTTPサーバーパスワード
		 */
		Element HTTPProxyPasswordKey = document.createElement("key");
		ProxiesManualDict.appendChild(HTTPProxyPasswordKey);

		Text HTTPProxyPasswordKeyParam = document
				.createTextNode("HTTPProxyPassword");
		HTTPProxyPasswordKey.appendChild(HTTPProxyPasswordKeyParam);

		Element HTTPProxyPasswordString = document.createElement(STRING);
		ProxiesManualDict.appendChild(HTTPProxyPasswordString);

		Text HTTPProxyPasswordStringParam = document.createTextNode(password);
		HTTPProxyPasswordString.appendChild(HTTPProxyPasswordStringParam);

		/*
		 * HTTPProxyUsername
		 * 
		 * HTTPユーザー名
		 */
		Element HTTPProxyUsernameKey = document.createElement("key");
		ProxiesManualDict.appendChild(HTTPProxyUsernameKey);

		Text HTTPProxyUsernameKeyParam = document
				.createTextNode("HTTPProxyUsername");
		HTTPProxyUsernameKey.appendChild(HTTPProxyUsernameKeyParam);

		Element HTTPProxyUsernameString = document.createElement(STRING);
		ProxiesManualDict.appendChild(HTTPProxyUsernameString);

		Text HTTPProxyUsernameStringParam = document.createTextNode(userName);
		HTTPProxyUsernameString.appendChild(HTTPProxyUsernameStringParam);

		/*
		 * HTTPSPort
		 * 
		 * HTTPサーバーポート設定
		 */
		Element HTTPSPortKey = document.createElement("key");
		ProxiesManualDict.appendChild(HTTPSPortKey);

		Text HTTPSPortKeyParam = document.createTextNode("HTTPSPort");
		HTTPSPortKey.appendChild(HTTPSPortKeyParam);

		Element HTTPSPortString = document.createElement(INTEGER);
		ProxiesManualDict.appendChild(HTTPSPortString);

		Text HTTPSPortStringParam = document.createTextNode(port);
		HTTPSPortString.appendChild(HTTPSPortStringParam);

		/*
		 * HTTPSEnable
		 * 
		 * HTTPプロキシ有効フラグ
		 */
		Element HTTPSEnableKey = document.createElement("key");
		ProxiesManualDict.appendChild(HTTPSEnableKey);

		Text HTTPSEnableKeyParam = document.createTextNode("HTTPSEnable");
		HTTPSEnableKey.appendChild(HTTPSEnableKeyParam);

		Element HTTPSEnableString = document.createElement(INTEGER);
		ProxiesManualDict.appendChild(HTTPSEnableString);

		Text HTTPSEnableStringParam = document.createTextNode(HTTPSEnable);
		HTTPSEnableString.appendChild(HTTPSEnableStringParam);

		/*
		 * HTTPSProxy
		 * 
		 * HTTPSサーバー設定
		 */
		Element HTTPSProxyKey = document.createElement("key");
		ProxiesManualDict.appendChild(HTTPSProxyKey);

		Text HTTPSProxyKeyParam = document.createTextNode("HTTPSProxy");
		HTTPSProxyKey.appendChild(HTTPSProxyKeyParam);

		Element HTTPSProxyString = document.createElement(STRING);
		ProxiesManualDict.appendChild(HTTPSProxyString);

		Text HTTPSProxyStringParam = document.createTextNode(server);
		HTTPSProxyString.appendChild(HTTPSProxyStringParam);

	}

	/*
	 * Proxies(自動)
	 * 
	 * プロキシが「自動」の場合
	 */
	public void ProxiesAuto(Element PayloadContentDict, Document document,
			String autoConfigEnable, String autoConfigURLString) {

		/*
		 * Proxies
		 * 
		 * Proxiesのルート
		 */
		Element ProxiesAutoKey = document.createElement("key");
		PayloadContentDict.appendChild(ProxiesAutoKey);

		Text ProxiesAutoKeyParam = document.createTextNode("Proxies");
		ProxiesAutoKey.appendChild(ProxiesAutoKeyParam);

		Element ProxiesAutoDict = document.createElement("dict");
		PayloadContentDict.appendChild(ProxiesAutoDict);

		/*
		 * ProxyAutoConfigEnable
		 * 
		 * なぞのパラメータ
		 */
		Element ProxyAutoConfigEnableKey = document.createElement("key");
		ProxiesAutoDict.appendChild(ProxyAutoConfigEnableKey);

		Text ProxyAutoConfigEnableKeyParam = document
				.createTextNode("ProxyAutoConfigEnable");
		ProxyAutoConfigEnableKey.appendChild(ProxyAutoConfigEnableKeyParam);

		Element ProxyAutoConfigEnableString = document.createElement(INTEGER);
		ProxiesAutoDict.appendChild(ProxyAutoConfigEnableString);

		Text ProxyAutoConfigEnableStringParam = document
				.createTextNode(autoConfigEnable);
		ProxyAutoConfigEnableString
				.appendChild(ProxyAutoConfigEnableStringParam);

		/*
		 * ProxyAutoConfigURLString
		 * 
		 * プロキシサーバーアドレス
		 */
		Element ProxyAutoConfigURLStringKey = document.createElement("key");
		ProxiesAutoDict.appendChild(ProxyAutoConfigURLStringKey);

		Text ProxyAutoConfigURLStringKeyParam = document
				.createTextNode("ProxyAutoConfigURLString");
		ProxyAutoConfigURLStringKey
				.appendChild(ProxyAutoConfigURLStringKeyParam);

		Element ProxyAutoConfigURLStringString = document.createElement(STRING);
		ProxiesAutoDict.appendChild(ProxyAutoConfigURLStringString);

		Text ProxyAutoConfigURLStringStringParam = document
				.createTextNode(autoConfigURLString);
		ProxyAutoConfigURLStringString
				.appendChild(ProxyAutoConfigURLStringStringParam);
	}

	/*
	 * UserDefinedName
	 * 
	 * VPN接続の説明でこれがデバイスに表示される
	 */
	public void UserDefinedName(Element PayloadContentDict, Document document,
			String difinedName) {
		Element UserDefinedNameKey = document.createElement("key");
		PayloadContentDict.appendChild(UserDefinedNameKey);

		Text UserDefinedNameKeyParam = document
				.createTextNode("UserDefinedName");
		UserDefinedNameKey.appendChild(UserDefinedNameKeyParam);

		Element UserDefinedNameString = document.createElement(STRING);
		PayloadContentDict.appendChild(UserDefinedNameString);

		Text UserDefinedNameStringParam = document.createTextNode(difinedName);
		UserDefinedNameString.appendChild(UserDefinedNameStringParam);
	}

	/*
	 * VPNType
	 * 
	 * VPN接続の種類をここで指定する
	 * 
	 * Cisco AnyConnectなら「VPN」
	 */
	public void VPNType(Element PayloadContentDict, Document document,
			String vpnType) {
		Element VPNTypeKey = document.createElement("key");
		PayloadContentDict.appendChild(VPNTypeKey);

		Text VPNTypeKeyParam = document.createTextNode("VPNType");
		VPNTypeKey.appendChild(VPNTypeKeyParam);

		Element VPNTypeString = document.createElement(STRING);
		PayloadContentDict.appendChild(VPNTypeString);

		Text VPNTypeStringParam = document.createTextNode(vpnType);
		VPNTypeString.appendChild(VPNTypeStringParam);
	}

	/*
	 * VPN
	 * 
	 * VPNの情報（プロキシあり）
	 * 
	 * AuthName＝アカウント、AuthPassword＝パスワード、AuthPasswordEncryption＝？
	 * AuthenticationMethod＝ユーザ認証、RemoteAddress＝サーバー
	 */
	public void VPNRootProxy(Element PayloadContentDict, Document document,
			String authName, String authPassword,
			String authPasswordEncryption, String authenticationMethod,
			String remoteAddress) {
		/*
		 * VPN
		 * 
		 * VPNのルート
		 */
		Element VPNKey = document.createElement("key");
		PayloadContentDict.appendChild(VPNKey);

		Text VPNKeyParam = document.createTextNode("VPN");
		VPNKey.appendChild(VPNKeyParam);

		Element VPNRootDict = document.createElement("dict");
		PayloadContentDict.appendChild(VPNRootDict);

		/*
		 * AuthName
		 * 
		 * アカウント名
		 */
		Element AuthNameKey = document.createElement("key");
		VPNRootDict.appendChild(AuthNameKey);

		Text AuthNameKeyParam = document.createTextNode("AuthName");
		AuthNameKey.appendChild(AuthNameKeyParam);

		Element AuthNameString = document.createElement(STRING);
		VPNRootDict.appendChild(AuthNameString);

		Text AuthNameStringParam = document.createTextNode(authName);
		AuthNameString.appendChild(AuthNameStringParam);

		/*
		 * AuthPassword
		 * 
		 * パスワード
		 */
		Element AuthPasswordKey = document.createElement("key");
		VPNRootDict.appendChild(AuthPasswordKey);

		Text AuthPasswordKeyParam = document.createTextNode("AuthPassword");
		AuthPasswordKey.appendChild(AuthPasswordKeyParam);

		Element AuthPasswordString = document.createElement(STRING);
		VPNRootDict.appendChild(AuthPasswordString);

		Text AuthPasswordStringParam = document.createTextNode(authPassword);
		AuthPasswordString.appendChild(AuthPasswordStringParam);

		/*
		 * AuthPasswordEncryption
		 * 
		 * なぞのパラメータ
		 */
		Element AuthPasswordEncryptionKey = document.createElement("key");
		VPNRootDict.appendChild(AuthPasswordEncryptionKey);

		Text AuthPasswordEncryptionKeyParam = document
				.createTextNode("AuthPasswordEncryption");
		AuthPasswordEncryptionKey.appendChild(AuthPasswordEncryptionKeyParam);

		Element AuthPasswordEncryptionString = document.createElement(STRING);
		VPNRootDict.appendChild(AuthPasswordEncryptionString);

		Text AuthPasswordEncryptionStringParam = document
				.createTextNode(authPasswordEncryption);
		AuthPasswordEncryptionString
				.appendChild(AuthPasswordEncryptionStringParam);

		/*
		 * AuthenticationMethod
		 * 
		 * ユーザー認証の方式
		 */
		Element AuthenticationMethodKey = document.createElement("key");
		VPNRootDict.appendChild(AuthenticationMethodKey);

		Text AuthenticationMethodKeyParam = document
				.createTextNode("AuthenticationMethod");
		AuthenticationMethodKey.appendChild(AuthenticationMethodKeyParam);

		Element AuthenticationMethodString = document.createElement(STRING);
		VPNRootDict.appendChild(AuthenticationMethodString);

		Text AuthenticationMethodStringParam = document
				.createTextNode(authenticationMethod);
		AuthenticationMethodString.appendChild(AuthenticationMethodStringParam);

		/*
		 * RemoteAddress
		 * 
		 * サーバーのアドレス
		 */
		Element RemoteAddressKey = document.createElement("key");
		VPNRootDict.appendChild(RemoteAddressKey);

		Text RemoteAddressKeyParam = document.createTextNode("RemoteAddress");
		RemoteAddressKey.appendChild(RemoteAddressKeyParam);

		Element RemoteAddressString = document.createElement(STRING);
		VPNRootDict.appendChild(RemoteAddressString);

		Text RemoteAddressStringParam = document.createTextNode(remoteAddress);
		RemoteAddressString.appendChild(RemoteAddressStringParam);
	}

	/*
	 * VPN
	 * 
	 * VPNの情報（プロキシなし）
	 * 
	 * アカウント＝AuthName、パスワード＝AuthPassword、
	 * AuthenticationMethod＝ユーザ認証、RemoteAddress＝サーバー
	 */
	public void VPNRoot(Element PayloadContentDict, Document document,
			String authName, String authPassword, String authenticationMethod,
			String remoteAddress) {
		/*
		 * VPN
		 * 
		 * VPNのルート
		 */
		Element VPNKey = document.createElement("key");
		PayloadContentDict.appendChild(VPNKey);

		Text VPNKeyParam = document.createTextNode("VPN");
		VPNKey.appendChild(VPNKeyParam);

		Element VPNRootDict = document.createElement("dict");
		PayloadContentDict.appendChild(VPNRootDict);

		/*
		 * AuthName
		 * 
		 * アカウント名
		 */
		Element AuthNameKey = document.createElement("key");
		VPNRootDict.appendChild(AuthNameKey);

		Text AuthNameKeyParam = document.createTextNode("AuthName");
		AuthNameKey.appendChild(AuthNameKeyParam);

		Element AuthNameString = document.createElement(STRING);
		VPNRootDict.appendChild(AuthNameString);

		Text AuthNameStringParam = document.createTextNode(authName);
		AuthNameString.appendChild(AuthNameStringParam);

		/*
		 * AuthPassword
		 * 
		 * パスワード
		 */
		Element AuthPasswordKey = document.createElement("key");
		VPNRootDict.appendChild(AuthPasswordKey);

		Text AuthPasswordKeyParam = document.createTextNode("AuthPassword");
		AuthPasswordKey.appendChild(AuthPasswordKeyParam);

		Element AuthPasswordString = document.createElement(STRING);
		VPNRootDict.appendChild(AuthPasswordString);

		Text AuthPasswordStringParam = document.createTextNode(authPassword);
		AuthPasswordString.appendChild(AuthPasswordStringParam);

		/*
		 * AuthenticationMethod
		 * 
		 * ユーザー認証の方式
		 */
		Element AuthenticationMethodKey = document.createElement("key");
		VPNRootDict.appendChild(AuthenticationMethodKey);

		Text AuthenticationMethodKeyParam = document
				.createTextNode("AuthenticationMethod");
		AuthenticationMethodKey.appendChild(AuthenticationMethodKeyParam);

		Element AuthenticationMethodString = document.createElement(STRING);
		VPNRootDict.appendChild(AuthenticationMethodString);

		Text AuthenticationMethodStringParam = document
				.createTextNode(authenticationMethod);
		AuthenticationMethodString.appendChild(AuthenticationMethodStringParam);

		/*
		 * RemoteAddress
		 * 
		 * サーバーのアドレス
		 */
		Element RemoteAddressKey = document.createElement("key");
		VPNRootDict.appendChild(RemoteAddressKey);

		Text RemoteAddressKeyParam = document.createTextNode("RemoteAddress");
		RemoteAddressKey.appendChild(RemoteAddressKeyParam);

		Element RemoteAddressString = document.createElement(STRING);
		VPNRootDict.appendChild(RemoteAddressString);

		Text RemoteAddressStringParam = document.createTextNode(remoteAddress);
		RemoteAddressString.appendChild(RemoteAddressStringParam);
	}

	/*
	 * VPNSubType
	 * 
	 * VPN接続のサブ種類をここで指定する
	 * 
	 * Cisco AnyConnectなら「com.cisco.anyconnect.applevpn.plugin」
	 */
	public void VPNSubType(Element PayloadContentDict, Document document,
			String vpnSubType) {
		Element VPNSubTypeKey = document.createElement("key");
		PayloadContentDict.appendChild(VPNSubTypeKey);

		Text VPNSubTypeKeyParam = document.createTextNode("VPNSubType");
		VPNSubTypeKey.appendChild(VPNSubTypeKeyParam);

		Element VPNSubTypeString = document.createElement(STRING);
		PayloadContentDict.appendChild(VPNSubTypeString);

		Text VPNSubTypeStringParam = document.createTextNode(vpnSubType);
		VPNSubTypeString.appendChild(VPNSubTypeStringParam);
	}

	/*
	 * VendorConfig(Cisco AnyConnect)
	 * 
	 * Groupを設定するためのルート
	 */
	public void VendorConfig_AnyConnect(Element PayloadContentDict,
			Document document, String Group) {
		Element VenderConfigKey = document.createElement("key");
		PayloadContentDict.appendChild(VenderConfigKey);

		Text VenderConfigKeyParam = document.createTextNode("VendorConfig");
		VenderConfigKey.appendChild(VenderConfigKeyParam);

		Element VendorConfigDict = document.createElement("dict");
		PayloadContentDict.appendChild(VendorConfigDict);

		/*
		 * Group
		 * 
		 * 接続認証用のグループ
		 */
		Element Groupkey = document.createElement("key");
		VendorConfigDict.appendChild(Groupkey);

		Text GroupkeyParam = document.createTextNode("Group");
		Groupkey.appendChild(GroupkeyParam);

		Element GroupString = document.createElement(STRING);
		VendorConfigDict.appendChild(GroupString);

		Text GroupStringParam = document.createTextNode(Group);
		GroupString.appendChild(GroupStringParam);
	}

	/*
	 * VendorConfig(Juniper SSL)
	 * 
	 * VendorConfigルート
	 */
	public void VendorConfig_Juniper(Element PayloadContentDict,
			Document document, String realm, String role) {
		Element VenderConfigKey = document.createElement("key");
		PayloadContentDict.appendChild(VenderConfigKey);

		Text VenderConfigKeyParam = document.createTextNode("VendorConfig");
		VenderConfigKey.appendChild(VenderConfigKeyParam);

		Element VendorConfigDict = document.createElement("dict");
		PayloadContentDict.appendChild(VendorConfigDict);

		/*
		 * Realm
		 * 
		 * 保護領域
		 */
		Element Realmkey = document.createElement("key");
		VendorConfigDict.appendChild(Realmkey);

		Text RealmkeyParam = document.createTextNode("Realm");
		Realmkey.appendChild(RealmkeyParam);

		Element RealmString = document.createElement(STRING);
		VendorConfigDict.appendChild(RealmString);

		Text RealmStringParam = document.createTextNode(realm);
		RealmString.appendChild(RealmStringParam);

		/*
		 * Role
		 * 
		 * 役割
		 */
		Element Rolekey = document.createElement("key");
		VendorConfigDict.appendChild(Rolekey);

		Text RolekeyParam = document.createTextNode("Role");
		Rolekey.appendChild(RolekeyParam);

		Element RoleString = document.createElement(STRING);
		VendorConfigDict.appendChild(RoleString);

		Text RoleStringParam = document.createTextNode(role);
		RoleString.appendChild(RoleStringParam);
	}

	/*
	 * VendorConfig
	 * 
	 * VendorConfigルート
	 */
	public void VendorConfig(Element PayloadContentDict, Document document) {
		Element VenderConfigKey = document.createElement("key");
		PayloadContentDict.appendChild(VenderConfigKey);

		Text VenderConfigKeyParam = document.createTextNode("VendorConfig");
		VenderConfigKey.appendChild(VenderConfigKeyParam);

		Element VendorConfigDict = document.createElement("dict");
		PayloadContentDict.appendChild(VendorConfigDict);
	}

	/*
	 * VendorConfig(SonicWALL)
	 * 
	 * VendorConfigルート
	 */
	public void VendorConfig_SonicWall(Element PayloadContentDict,
			Document document, String loginGroupOrDomain) {
		Element VenderConfigKey = document.createElement("key");
		PayloadContentDict.appendChild(VenderConfigKey);

		Text VenderConfigKeyParam = document.createTextNode("VendorConfig");
		VenderConfigKey.appendChild(VenderConfigKeyParam);

		Element VendorConfigDict = document.createElement("dict");
		PayloadContentDict.appendChild(VendorConfigDict);

		/*
		 * LoginGroupOrDomain
		 * 
		 * ログイングループまたはドメイン
		 */
		Element LoginGroupOrDomainkey = document.createElement("key");
		VendorConfigDict.appendChild(LoginGroupOrDomainkey);

		Text LoginGroupOrDomainkeyParam = document
				.createTextNode("LoginGroupOrDomain");
		LoginGroupOrDomainkey.appendChild(LoginGroupOrDomainkeyParam);

		Element LoginGroupOrDomainString = document.createElement(STRING);
		VendorConfigDict.appendChild(LoginGroupOrDomainString);

		Text LoginGroupOrDomainStringParam = document
				.createTextNode(loginGroupOrDomain);
		LoginGroupOrDomainString.appendChild(LoginGroupOrDomainStringParam);
	}

	/* ------------ ここから下、メソッド（XML生成には直接関係ない） ------------ */

	// 共有シークレットをBase64エンコードする
	public String encodeBase64(String sharedSecret) throws IOException,
			InterruptedException {
		// 文字列をByte型へ変換
		byte[] inStrByte = sharedSecret.getBytes();

		// Base64にエンコードする
		byte[] outStrByte = Base64.encodeBase64(inStrByte);

		// Base64にエンコードしたものをString型へ戻す
		String sOutStr = new String(outStrByte);

		return sOutStr;
	}
}
