package com.mxmobiling.kitting;
import org.apache.commons.lang.RandomStringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class Common {

	public static final String STRING = "string";
	public static final String INTEGER = "integer";

	public Common() {
	}

	/*
	 * PayloadDescription
	 * 
	 * プロファイルの説明
	 */
	public void PayloadDescription(Element dict, Document document,
			String valueType, String description) {

		Element PayloadDescriptionKey = document.createElement("key");
		dict.appendChild(PayloadDescriptionKey);

		Text PayloadDescriptionKeyParam = document
				.createTextNode("PayloadDescription");
		PayloadDescriptionKey.appendChild(PayloadDescriptionKeyParam);

		Element PayloadDescriptionKeyString = document.createElement(valueType);
		dict.appendChild(PayloadDescriptionKeyString);

		Text PayloadDescriptionKeyStringParam = document
				.createTextNode(description);
		PayloadDescriptionKeyString
				.appendChild(PayloadDescriptionKeyStringParam);
	}

	/*
	 * PayloadDisplayName
	 * 
	 * プロファイル名
	 */
	public void PayloadDisplayName(Element dict, Document document,
			String valueType, String displayName) {
		Element PayloadDisplayNameKey = document.createElement("key");
		dict.appendChild(PayloadDisplayNameKey);

		Text PayloadDisplayNamekeyParam = document
				.createTextNode("PayloadDisplayName");
		PayloadDisplayNameKey.appendChild(PayloadDisplayNamekeyParam);

		Element PayloadDisplayNameString = document.createElement(valueType);
		dict.appendChild(PayloadDisplayNameString);

		Text PayloadDisplayNameStringParam = document
				.createTextNode(displayName);
		PayloadDisplayNameString.appendChild(PayloadDisplayNameStringParam);
	}

	/*
	 * PayloadIdentifier
	 * 
	 * プロファイルの識別子
	 */
	public void PayloadIdentifier(Element dict, Document document,
			String valueType, String ID) {
		Element PayloadIdentifierKey = document.createElement("key");
		dict.appendChild(PayloadIdentifierKey);

		Text PayloadIdentifierKeyParam = document
				.createTextNode("PayloadIdentifier");
		PayloadIdentifierKey.appendChild(PayloadIdentifierKeyParam);

		Element PayloadIdentifierString = document.createElement(valueType);
		dict.appendChild(PayloadIdentifierString);

		Text PayloadIdentifierStringParam = document.createTextNode(ID);
		// "jp.mobiling.auto"
		PayloadIdentifierString.appendChild(PayloadIdentifierStringParam);
	}

	/*
	 * PayloadOrganization
	 * 
	 * 構成プロファイルの作成元
	 */
	public void PayloadOrganization(Element dict, Document document,
			String valueType, String companyName) {
		Element PayloadOrganizationKey = document.createElement("key");
		dict.appendChild(PayloadOrganizationKey);

		Text PayloadOrganizationKeyParam = document
				.createTextNode("PayloadOrganization");
		PayloadOrganizationKey.appendChild(PayloadOrganizationKeyParam);

		Element PayloadOrganizationString = document.createElement(valueType);
		dict.appendChild(PayloadOrganizationString);

		Text PayloadOrganizationStringParam = document
				.createTextNode(companyName);
		PayloadOrganizationString.appendChild(PayloadOrganizationStringParam);
	}

	/*
	 * PayloadRemovalDisallowed
	 * 
	 * プロファイルの削除可否
	 * 
	 * trueなら削除不可、falseなら削除可能
	 */
	public void PayloadRemovalDisallowed(Element dict, Document document,
			Boolean deleteProfile) {
		Element PayloadRemovalDisallowedKey = document.createElement("key");
		dict.appendChild(PayloadRemovalDisallowedKey);

		Text PayloadRemovalDisallowedKeyParam = document
				.createTextNode("PayloadRemovalDisallowed");
		PayloadRemovalDisallowedKey
				.appendChild(PayloadRemovalDisallowedKeyParam);

		Element PayloadRemovalDisallowedString = document.createElement(String
				.valueOf(deleteProfile));
		dict.appendChild(PayloadRemovalDisallowedString);
	}

	/*
	 * PayloadType
	 * 
	 * よくわからないが、ルートの場合「Configuration」固定らしい
	 * 
	 * Exchangeの場合は「com.apple.eas.account」
	 * 
	 * Webclipの場合は「com.apple.webClip.managed」
	 */
	public void PayloadType(Element dict, Document document, String valueType,
			String payloadType) {
		Element PayloadTypeKey = document.createElement("key");
		dict.appendChild(PayloadTypeKey);

		Text PayloadTypeKeyParam = document.createTextNode("PayloadType");
		PayloadTypeKey.appendChild(PayloadTypeKeyParam);

		Element PayloadTypeKeyString = document.createElement(valueType);
		dict.appendChild(PayloadTypeKeyString);

		Text PayloadTypeKeyStringParam = document.createTextNode(payloadType);
		PayloadTypeKeyString.appendChild(PayloadTypeKeyStringParam);
	}

	/*
	 * PayloadUUID
	 * 
	 * プロファイルを特定する汎用一意識別子
	 */
	public void PayloadUUID(Element dict, Document document, String valueType) {
		Element PayloadUUIDKey = document.createElement("key");
		dict.appendChild(PayloadUUIDKey);

		Text PayloadUUIDKeyParam = document.createTextNode("PayloadUUID");
		PayloadUUIDKey.appendChild(PayloadUUIDKeyParam);

		Element PayloadUUIDKeyString = document.createElement(valueType);
		dict.appendChild(PayloadUUIDKeyString);

		Text PayloadUUIDKeyStringParam = document
				.createTextNode(UUIDGenerator());
		// "78F09905-5D59-48E6-A740-E64858041549"
		PayloadUUIDKeyString.appendChild(PayloadUUIDKeyStringParam);
	}

	/*
	 * UUIDGenerator
	 * 
	 * UUIDを16進数でランダムに生成
	 */
	public String UUIDGenerator() {
		String UUID;
		UUID = RandomStringUtils.random(8, "0123456789ABCDEF");
		UUID += "-";
		UUID += RandomStringUtils.random(4, "0123456789ABCDEF");
		UUID += "-";
		UUID += RandomStringUtils.random(4, "0123456789ABCDEF");
		UUID += "-";
		UUID += RandomStringUtils.random(4, "0123456789ABCDEF");
		UUID += "-";
		UUID += RandomStringUtils.random(12, "0123456789ABCDEF");
		return UUID;
	}

	/*
	 * PayloadVersion
	 * 
	 * プロファイルのバージョン。現在は「1」固定らしい
	 */
	public void PayloadVersion(Element dict, Document document,
			String valueType, String version) {
		Element PayloadVersionKey = document.createElement("key");
		dict.appendChild(PayloadVersionKey);

		Text PayloadVersionKeyParam = document.createTextNode("PayloadVersion");
		PayloadVersionKey.appendChild(PayloadVersionKeyParam);

		Element PayloadVersionKeyInteger = document.createElement(valueType);
		dict.appendChild(PayloadVersionKeyInteger);

		Text PayloadVersionKeyStringParam = document.createTextNode(version);
		PayloadVersionKeyInteger.appendChild(PayloadVersionKeyStringParam);
	}
}
