/*
   This file is provided under the LGPL license ver 2.1.
   Written by K.Tanaka & Katsumi
   http://www.ze.em-net.ne.jp/~kenken/index.html
   http://hp.vector.co.jp/authors/VA016157/
*/

// main.c
// MachiKania BASIC System Ver Zoea
// KM-BASIC Js for PIC32MX170F256B / PIC32MX270F256B by K.Tanaka

// pVXe
// ps2keyboard.X.a : PS/2L[{[h̓VXeCu
// lib_colortext32.a : J[rfIMo̓VXeCui30~27eLXgŁj
// libsdfsio.a F SDJ[hANZXpCu

/*
	PIC32MX ytFgp
	
	荞
		NTSC,   Timer2, vector  8, priority 5
		NTSC,   OC3,    vector 14, priority 5
		NTSC,   OC2,    vector 10, priority 5
		NTSC,   OC1,    vector  6, priority 5
		PS/2,   CNF,    vector 33, priority 6
		PS/2,   Timer5, vector 20, priority 4
		MUSIC,  CS0,    vector  1, priority 2
		TIMER,  Timer1, vector  4, priority 3
		INT,    CS1,    vector  2, priority 1
	
	^C}[
		Timer1 BASICp^C}[
		Timer2 NTSC
		Timer3 MUSIC/PWM
		Timer4 MUSIC
		Timer5 PS/2
	
	DMA
		DMA0 gp
		DMA1 gp
		DMA2 MUSIC
		DMA3 PS/2
	
	Output compair
		OC1 NTSC
		OC2 NTSC
		OC3 NTSC
		OC4 MUSIC/PWM
		OC5 
		
	SPI
		SPI1 gp
		SPI2 }`fBAJ[h
	
	I2C
		I2C1 gp
		I2C2 gp
	
	|[ggp
		A0  MMC
		A1  PS2/button ؊
		A2  Crystal
		A3  Crystal
		A4  MMC
		B0  NTSC
		B1  NTSC
		B2  NTSC
		B3  NTSC
		B4  NTSC
		B5  MMC
		B6  gp
		B7  button
		B8  PS2/button
		B9  PS2/button
		B10 button
		B11 button
		B12 gp
		B13 audio out
		B14 button
		B15 MMC
*/

#include <xc.h>
#include "api.h"
#include "compiler.h"
#include "editor.h"
#include "interface/keyinput.h"
#include "main.h"

//OtNX^ with PLL (16{)
#pragma config PMDL1WAY = OFF, IOL1WAY = OFF
#pragma config FPLLIDIV = DIV_1, FPLLMUL = MUL_16, FPLLODIV = DIV_1
#pragma config FNOSC = PRIPLL, FSOSCEN = OFF, POSCMOD = XT, OSCIOFNC = OFF
#pragma config FPBDIV = DIV_1, FWDTEN = OFF, JTAGEN = OFF, ICESEL = ICS_PGx1
#pragma config FCKSM = CSECMD

#define mBMXSetRAMKernProgOffset(offset)	(BMXDKPBA = (offset))
#define mBMXSetRAMUserDataOffset(offset)	(BMXDUDBA = (offset))
#define mBMXSetRAMUserProgOffset(offset)	(BMXDUPBA = (offset))

// INIt@CwL[[hi8ȓj
const char InitKeywords[][9]={
	"106KEY","101KEY","NUMLOCK","CAPSLOCK","SCRLLOCK"
};

void freadline(char *s,FSFILE *fp){
// t@C1sǂݍ݁AzsɕԂ
// ő8܂ŁB9ȏ̏ꍇ
// #܂0x20ȉ̃R[hꍇAȍ~͖
// s:9oCgȏ̔z
// fp:t@C|C^
	int n;
	char c,*p;
	n=0;
	p=s;
	*p=0;
	while(n<=8){
		if(FSfread(p,1,1,fp)==0 || *p=='\n'){
			*p=0;
			return;
		}
		if(*p=='#'){
			*p=0;
			break;
		}
		if(*p<=' '){
			if(n>0){
				*p=0;
				break;
			}
			continue;
		}
		p++;
		n++;
	}
	if(n>8) *s=0; //9ȏ̏̕ꍇ͖
	//ȍ~͖̕
	while(FSfread(&c,1,1,fp) && c!='\n') ;
}
int searchinittext(char *s){
// InitKeywordsz̒當sTAʒuꍇԖڂԂ
// Ȃꍇ-1Ԃ
	int i;
	char *p1;
	const char *p2;
	for(i=0;i<sizeof(InitKeywords)/sizeof(InitKeywords[0]);i++){
		p1=s;
		p2=InitKeywords[i];
		while(*p1==*p2){
			if(*p1==0) return i;
			p1++;
			p2++;
		}
	}
	return -1;
}
void readinifile(void){
	FSFILE *fp;
	char inittext[9];

	fp=FSfopen(INIFILE,"r");
	if(fp==NULL) return;
	printstr("Initialization File Found\n");
	lockkey=0; //INIt@C݂ꍇALock֘AL[INIt@Cɏ]
	while(1){
		if(FSfeof(fp)) break;
		freadline(inittext,fp);
		switch(searchinittext(inittext)){
			case 0:
				keytype=0;//{L[{[h
				break;
			case 1:
				keytype=1;//pL[{[h
				break;
			case 2:
				lockkey|=2;//Num Lock
				break;
			case 3:
				lockkey|=4;//CAPS Lock
				break;
			case 4:
				lockkey|=1;//Scroll Lock
				break;
		}
	}
	FSfclose(fp);
}

void printhex8(unsigned char d){
	printchar("0123456789ABCDEF"[d>>4]);
	printchar("0123456789ABCDEF"[d&0x0f]);	
}

void printhex16(unsigned short d){
	printhex8(d>>8);
	printhex8(d&0x00ff);
}

void printhex32(unsigned int d){
	printhex16(d>>16);
	printhex16(d&0x0000ffff);
}

int main(void){
	char *appname,*s;

	if(DEVCFG1 & 0x8000){
		// Set Clock switching enabled and reset
		NVMWriteWord(&DEVCFG1,DEVCFG1 & 0xffff7fff);
		SoftReset();
	}

	/* |[g̏ݒ */
	TRISA = 0x0000; // PORTASďo
	ANSELA = 0x0000; // SăfW^
	TRISB = KEYSTART | KEYFIRE | KEYUP | KEYDOWN | KEYLEFT | KEYRIGHT;// {^ڑ|[g͐ݒ
	ANSELB = 0x0000; // SăfW^
	CNPUBSET=KEYSTART | KEYFIRE | KEYUP | KEYDOWN | KEYLEFT | KEYRIGHT;// vAbvݒ
	ODCB = 0x0300;	//RB8,RB9̓I[vhC

	// Ӌ@\s蓖
	SDI2R=2; //RPA4:SDI2
	RPB5R=4; //RPB5:SDO2

	// Make RAM executable. See also "char RAM[RAMSIZE]" in globalvars.c
	mBMXSetRAMKernProgOffset(PIC32MX_RAMSIZE-RAMSIZE);
	mBMXSetRAMUserDataOffset(PIC32MX_RAMSIZE);
	mBMXSetRAMUserProgOffset(PIC32MX_RAMSIZE);

	ps2mode(); //RA1IiPS/2L}Nj
	init_composite(); // rfINAA荞ݏAJ[rfIo͊Jn
	setcursor(0,0,COLOR_NORMALTEXT);

	// Show blue screen if exception before soft reset.
	blue_screen();

	printstr("MachiKania BASIC System\n");
	printstr(" Ver "SYSVER1" "SYSVER2" by KENKEN\n");
	printstr("BASIC Compiler "BASVER"\n");
	printstr(" by Katsumi\n\n");
	//SDJ[ht@CVXe
	setcursorcolor(COLOR_NORMALTEXT);
	printstr("Init File System...");
	// Initialize the File System
	if(FSInit()==FALSE){ //t@CVXe
		//G[̏ꍇ~
		setcursorcolor(COLOR_ERRORTEXT);
		printstr("\nFile System Error\n");
		printstr("Insert Correct Card\n");
		printstr("And Reset\n");
		while(1) asm("wait");
	}
	printstr("OK\n");
	lockkey=2; // NumLockL[I
	keytype=0; // {L[{[h
	readinifile(); //INIt@Cǂݍ
	printstr("Init PS/2...");
	if(ps2init()){ //PS/2
		//L[{[hȂꍇ
		printstr("Keyboard Not Found\n");
	}
	else printstr("OK\n");

	wait60thsec(60); //1b҂

	// sHEXt@CHEXFILEƈvꍇ̓GfB^N
	appname=(char*)FILENAME_FLASH_ADDRESS;
	s=HEXFILE;
	while(*s++==*appname++) if(*s==0) texteditor(); //eLXgGfB^[Ăяo

	// sHEXt@Ću.HEXvu.BASvɒuBASt@Cs
	appname=(char*)FILENAME_FLASH_ADDRESS;
	s=tempfile;
	while(*appname!='.') *s++=*appname++;
	appname=".BAS";
	while(*appname!=0) *s++=*appname++;
	*s=0;
	// buttonmode(); //{^L
	g_disable_break=1; // BreakL[
	runbasic(tempfile,0);
	while(1) asm(WAIT);
}

