package org.pulpdust.snappingcamera;

import java.io.FileOutputStream;

import android.content.Context;
import android.hardware.Camera;
import android.os.Environment;
import android.util.Log;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;

public class SnappingCameraView extends SurfaceView
 implements SurfaceHolder.Callback, Camera.PictureCallback {
	final static String TAG = "SnappingCameraView";
	private SurfaceHolder srfchldr;
	private Camera cmr;

	public SnappingCameraView(Context context) {
		super(context);
		srfchldr = getHolder();
		srfchldr.addCallback(this);
		srfchldr.setType(SurfaceHolder.SURFACE_TYPE_PUSH_BUFFERS);
	}
	public void surfaceCreated(SurfaceHolder holder){
		cmr = Camera.open();
		try {
			cmr.setPreviewDisplay(holder);
		} catch (Exception e) {
			Log.e(TAG, e.getMessage());
		}
	}
	public void surfaceChanged(SurfaceHolder holder,
			int format, int width, int height){
		cmr.startPreview();
	}
	public void surfaceDestroyed(SurfaceHolder holder){
		cmr.setPreviewCallback(null);
		cmr.stopPreview();
		cmr.release();
		cmr = null;
	}
	@Override
	public boolean onTouchEvent(MotionEvent event){
		if (event.getAction() == MotionEvent.ACTION_DOWN){
			cmr.takePicture(null, null, this);
		}
		return true;
	}
	public void onPictureTaken(byte[] data, Camera camera){
		FileOutputStream flops = null;
		double ctm = System.currentTimeMillis();
		try {
			flops = new FileOutputStream(Environment.getExternalStorageDirectory() + "/"
					+ Double.toString(ctm) + ".jpg");
			flops.write(data);
			flops.close();
		} catch (Exception e){
			Log.e(TAG, e.getMessage());
		}
		cmr.startPreview();
	}

}
