#/bin/sh

. ./_cblfsset.sh

APPNAME=curl
VER=7.29.0
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

checkRequired ""
checkOptions  \
	openssl gnutls openldap krb5 libidn libssh2 \
        c-ares cacerts libgssapi libmetalink
checkTarball
checkExit "$1" || exit $?

cd $SRC

BIT32
RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Configuring...
CC="gcc ${BUILD32}" USE_ARCH=32 PKG_CONFIG_PATH="${PKG_CONFIG_PATH32}" \
./configure --prefix=/usr \
	1> $LOG/$TARGET.$BIT.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$TARGET.$BIT.2_make.log 2>&1 || exit 1

echo Installing...
paco -p $TARGET "\
make install" \
	1> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
mv -v /usr/bin/curl-config{,-32}" \
	1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
mv -v /usr/include/curl/curlbuild{,-32}.h" \
	1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1

TimeEnd
cd ..

BIT64
RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Configuring...
CC="gcc ${BUILD64}" USE_ARCH=64 PKG_CONFIG_PATH="${PKG_CONFIG_PATH64}" \
./configure --prefix=/usr --libdir=/usr/lib64 \
        1> $LOG/$TARGET.$BIT.1_conf.log 2>&1 || exit 1

echo Making...
make \
        1> $LOG/$TARGET.$BIT.2_make.log 2>&1 || exit 1

echo Installing...
paco -p+ $TARGET "\
make install" \
        1> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
mv -v /usr/bin/curl-config{,-64}" \
        1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
ln -sfv multiarch_wrapper /usr/bin/curl-config" \
        1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
mv -v /usr/include/curl/curlbuild{,-64}.h" \
        1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
find docs -name \"Makefile*\" -o -name \"*.1\" -o -name \"*.3\" | xargs rm" \
        1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
install -v -d -m755 /usr/share/doc/curl-$VER" \
        1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
cp -v -R docs/* /usr/share/doc/curl-$VER" \
        1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1

cat > /usr/include/curl/curlbuild.h << "EOF"
/* curlbuild.h - Stub Header  */
#ifndef __STUB__CURLBUILD_H__
#define __STUB__CURLBUILD_H__

#if defined(__x86_64__) || \
    defined(__sparc64__) || \
    defined(__arch64__) || \
    defined(__powerpc64__) || \
    defined (__s390x__)
# include "curlbuild-64.h"
#else
# include "curlbuild-32.h"
#endif

#endif /* __STUB__CURLBUILD_H__ */
EOF

paco -p+ $TARGET "touch /usr/include/curl/curlbuild.h" \
        1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1

TimeEnd
cd ..
RemoveSrcDir
PacoingDone

