#!/bin/sh

function teckit() {
cd libs
cd teckit

SUBPKG=teckit

echo $SUBPKG: Configuring...
./configure --prefix=$INSTDIR \
	--with-system-zlib \
        1> $LOG/$TARGET-$SUBPKG.1_conf.log 2>&1 || exit 1

echo $SUBPKG: Making...
make \
        1> $LOG/$TARGET-$SUBPKG.2_make.log 2>&1 || exit 1

echo $SUBPKG: Installing...
paco -p $TARGET "make install" \
        1> $LOG/$TARGET-$SUBPKG.3_install.log 2>&1 || exit 1

cd ../..
}

function graphite2() {
cd libs
cd graphite2

SUBPKG=graphite2

echo $SUBPKG: Configuring...
./configure --prefix=$INSTDIR \
        1> $LOG/$TARGET-$SUBPKG.1_conf.log 2>&1 || exit 1

echo $SUBPKG: Making...
make \
        1> $LOG/$TARGET-$SUBPKG.2_make.log 2>&1 || exit 1

echo $SUBPKG: Installing...
paco -p $TARGET "make install" \
        1> $LOG/$TARGET-$SUBPKG.3_install.log 2>&1 || exit 1

cd ../..
}

function xpdf() {
cd libs
cd xpdf

SUBPKG=xpdf

echo $SUBPKG: Configuring...
./configure --prefix=$INSTDIR \
        1> $LOG/$TARGET-$SUBPKG.1_conf.log 2>&1 || exit 1

echo $SUBPKG: Making...
make \
        1> $LOG/$TARGET-$SUBPKG.2_make.log 2>&1 || exit 1

echo $SUBPKG: Installing...
paco -p $TARGET "make install" \
        1> $LOG/$TARGET-$SUBPKG.3_install.log 2>&1 || exit 1

cd ../..
}

function kpathsea() {
cd texk
cd kpathsea

SUBPKG=kpathsea

echo $SUBPKG: Configuring...
./configure --prefix=$INSTDIR \
        1> $LOG/$TARGET-$SUBPKG.1_conf.log 2>&1 || exit 1

echo $SUBPKG: Making...
make \
        1> $LOG/$TARGET-$SUBPKG.2_make.log 2>&1 || exit 1

echo $SUBPKG: Installing...
paco -p+ $TARGET "make install" \
        1> $LOG/$TARGET-$SUBPKG.3_install.log 2>&1 || exit 1

cd ../..
}

function ptexenc() {
cd texk
cd ptexenc

SUBPKG=ptexenc

echo $SUBPKG: Configuring...
./configure --prefix=$INSTDIR \
        1> $LOG/$TARGET-$SUBPKG.1_conf.log 2>&1 || exit 1

echo $SUBPKG: Making...
make \
        1> $LOG/$TARGET-$SUBPKG.2_make.log 2>&1 || exit 1

echo $SUBPKG: Installing...
paco -p+ $TARGET "make install" \
        1> $LOG/$TARGET-$SUBPKG.3_install.log 2>&1 || exit 1

cd ../..
}

function web2c() {
cd texk
cd web2c

SUBPKG=web2c

       # --disable-aleph \
       # --disable-xetex \
echo $SUBPKG: Configuring...
./configure --prefix=/opt/texlive \
        --disable-native-texlive-build \
        --enable-build-in-source-tree  \
        --enable-mktextex-default \
        --disable-luatex \
        --disable-shared \
        --disable-debug \
        --with-banner-add=" - BLFS" \
        --with-system-xpdf \
        --with-system-zlib \
        --with-system-libpng \
        --with-system-poppler \
        --with-system-freetype2 \
        --with-system-cairo \
        --with-system-pixman \
        --with-system-icu \
        --with-system-t1lib \
        --with-system-gd \
	--with-system-harfbuzz \
	--with-system-graphite2 \
        --without-x \
        --disable-chktex \
        --disable-detex \
        --disable-devnag \
        --disable-dtl \
        --disable-dvi2tty \
        --disable-dvidvi \
        --disable-dviljk \
        --disable-dvipng \
        --disable-dvipos \
        --disable-dvisvgm \
        --disable-lacheck \
        1> $LOG/$TARGET-$SUBPKG.1_conf.log 2>&1 || exit 1

echo $SUBPKG: Making...
make \
        1> $LOG/$TARGET-$SUBPKG.2_make.log 2>&1 || exit 1

echo $SUBPKG: Installing...
paco -p $TARGET "make install" \
        1> $LOG/$TARGET-$SUBPKG.3_install.log 2>&1 || exit 1

cd ../..
}

function dvipdfmx() {
cd texk
cd dvipdfmx

SUBPKG=dvipdfmx

echo $SUBPKG: Configuring...
./configure --prefix=$INSTDIR \
        --with-system-zlib \
        --with-system-libpng \
        1> $LOG/$TARGET-$SUBPKG.1_conf.log 2>&1 || exit 1

echo $SUBPKG: Making...
make \
        1> $LOG/$TARGET-$SUBPKG.2_make.log 2>&1 || exit 1

echo $SUBPKG: Installing...
paco -p+ $TARGET "make install" \
        1> $LOG/$TARGET-$SUBPKG.3_install.log 2>&1 || exit 1

cd ../..
}

function dvipsk() {
cd texk
cd dvipsk

SUBPKG=dvipsk

echo $SUBPKG: Configuring...
./configure --prefix=$INSTDIR \
        1> $LOG/$TARGET-$SUBPKG.1_conf.log 2>&1 || exit 1

echo $SUBPKG: Making...
make \
        1> $LOG/$TARGET-$SUBPKG.2_make.log 2>&1 || exit 1

echo $SUBPKG: Installing...
paco -p+ $TARGET "make install" \
        1> $LOG/$TARGET-$SUBPKG.3_install.log 2>&1 || exit 1

cd ../..
}

function texlive() {
cd texk
cd texlive

SUBPKG=texlive

echo $SUBPKG: Configuring...
./configure --prefix=$INSTDIR \
        1> $LOG/$TARGET-$SUBPKG.1_conf.log 2>&1 || exit 1

echo $SUBPKG: Making...
make \
        1> $LOG/$TARGET-$SUBPKG.2_make.log 2>&1 || exit 1

echo $SUBPKG: Installing...
paco -p+ $TARGET "make install" \
        1> $LOG/$TARGET-$SUBPKG.3_install.log 2>&1 || exit 1

cd ../..
}

