#!/bin/sh

. ../_blfsset.sh
. ./_gnomeset.sh

APPNAME=gnome-panel
VER=3.6.2
TARGET=$APPNAME-$VER
TARGETBALL=$GNOMEDLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	gnome-desktop gnome-menus libcanberra \
        libgweather librsvg libwnck yelp-xsl
. $WRK/_checkOptions.sh  \
	evolution-data-server \
        gobject-introspection NetworkManager \
        telepathy-glib rarian gtk-doc
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr \
            --sysconfdir=/etc \
            --libexecdir=/usr/lib/gnome-applets \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

