#!/bin/sh

VER=0.18.2
TARGET=gupnp-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

. ../_blfsset.sh
. ../Xorg/_xorgset.sh
. ./_gnomeset.sh

echo Check Required...
../_checkRequired.sh gssdp shared-mime-info || exit 1

echo Check Options...
../_checkOptions.sh \
	gobject-introspection gtk-doc \
	NetworkManager

if test "$1" == "check"; then
  exit 0
fi

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

cd $TARGETDIR

echo \ \ Configuring...
./configure --prefix=/usr --disable-static \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

