#!/bin/sh

. ./_blfsset.sh

APPNAME=gnutls
VER=3.3.11
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$APPNAME-$VER

echo $TARGET

. $WRK/_checkRequired.sh \
	nettle 
. $WRK/_checkOptions.sh  \
	cacerts gtk-doc guile libtasn1 libidn p11-kit \
        autogen trousers unbound valgrind
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

if [ ${OPTION_p11kit} -eq "1" ]; then
  export WITHP11KIT=""
else
  export WITHP11KIT="--without-p11-kit "
fi

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr \
        --with-default-trust-store-file=/etc/ssl/ca-bundle.crt \
	$WITHP11KIT \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

