#!/bin/sh

. ./_blfsset.sh

APPNAME=hicolor-icon-theme
VER=0.13
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
. $WRK/_rmdir.sh
. $WRK/_extract.sh $TARGETBALL

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR

echo Configuring...
./configure --prefix=/usr \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

echo Installing...
paco -p $TARGET 'make install' \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo `cat /etc/lfs-release`,$TARGET,$START,$END \
        >> $TME/$APPNAME.txt

cd ..
. $WRK/_rmdir.sh

echo -n Pacoing:\   && paco $TARGET || echo none


