#!/bin/sh

. ./_blfsset.sh

APPNAME=librsvg
VER=2.40.1
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	gdk-pixbuf libcroco pango
. $WRK/_checkOptions.sh  \
	gtk+-2 gtk+-3 gobject-introspection vala \
	docbook-utils gtk-doc
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

unset MAKEFLAGS

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

#$([ "${OPTION_vala}" -eq 1 ] && echo --enable-vala ) \

Configuring
./configure --prefix=/usr --disable-static \
$([ "${OPTION_gobjectintrospection}" -ne 1 ] && echo --disable-introspection) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

