#!/bin/sh

. ./_blfsset.sh

APPNAME=mariadb
VER=10.0.14
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	cmake openssl
. $WRK/_checkOptions.sh  \
	libevent boost libxml2 Linux-PAM pcre \
	unixODBC valgrind libaio judy sphinx tokudb
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

#if [ ${OPTION_tcp_wrappers} -eq "1" ]; then
#  export WITHWRAP="--with-libwrap "
#else
#  export WITHWRAP=""
#fi

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

groupadd -g 40 mysql 
useradd -c "MySQL Server" -d /srv/mysql -g mysql -s /bin/false -u 40 mysql

Configuring
sed -i "s@data/test@\${INSTALL_MYSQLTESTDIR}@g" sql/CMakeLists.txt
sed -i "s/srv_buf_size/srv_sort_buf_size/" storage/innobase/row/row0log.cc

mkdir build
cd build

cmake -DCMAKE_BUILD_TYPE=Release                       \
      -DCMAKE_INSTALL_PREFIX=/usr                      \
      -DINSTALL_DOCDIR=share/doc/mariadb-10.0.14       \
      -DINSTALL_DOCREADMEDIR=share/doc/mariadb-10.0.14 \
      -DINSTALL_MANDIR=share/man                       \
      -DINSTALL_MYSQLSHAREDIR=share/mysql              \
      -DINSTALL_MYSQLTESTDIR=share/mysql/test          \
      -DINSTALL_PLUGINDIR=lib/mysql/plugin             \
      -DINSTALL_SBINDIR=sbin                           \
      -DINSTALL_SCRIPTDIR=bin                          \
      -DINSTALL_SQLBENCHDIR=share/mysql/bench          \
      -DINSTALL_SUPPORTFILESDIR=share/mysql            \
      -DMYSQL_DATADIR=/srv/mysql                       \
      -DMYSQL_UNIX_ADDR=/run/mysqld/mysqld.sock        \
      -DWITH_EXTRA_CHARSETS=complex                    \
      -DWITH_EMBEDDED_SERVER=ON                        \
      -DTOKUDB_OK=0                                    \
      .. \
	1> $LOG/$TARGET.1_cmake.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp  $TARGET "\
make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ../..
RemoveSrcDir
PorgingDone

#paco -p+ $TARGET "\
#install -v -Dm644 /usr/share/mysql/support/my-medium.cnf /etc/mysql/my.cnf"

#sed -i 's/^log-bin/#log-bin/' /etc/mysql/my.cnf
#sed -i 's/^binlog/#binlog/' /etc/mysql/my.cnf

install -dm 755 /etc/mysql

cat > /etc/mysql/my.cnf << "EOF"
# Begin /etc/mysql/my.cnf

# The following options will be passed to all MySQL clients
[client]
#password       = your_password
port            = 3306
socket          = /run/mysqld/mysqld.sock

# The MySQL server
[mysqld]
port            = 3306
socket          = /run/mysqld/mysqld.sock
datadir         = /srv/mysql
skip-external-locking
key_buffer_size = 16M
max_allowed_packet = 1M
sort_buffer_size = 512K
net_buffer_length = 16K
myisam_sort_buffer_size = 8M

# Don't listen on a TCP/IP port at all.
skip-networking

# required unique id between 1 and 2^32 - 1
server-id       = 1

# Uncomment the following if you are using BDB tables
#bdb_cache_size = 4M
#bdb_max_lock = 10000

# Uncomment the following if you are using InnoDB tables
#innodb_data_home_dir = /srv/mysql
#innodb_data_file_path = ibdata1:10M:autoextend
#innodb_log_group_home_dir = /srv/mysql
# You can set .._buffer_pool_size up to 50 - 80 %
# of RAM but beware of setting memory usage too high
#innodb_buffer_pool_size = 16M
#innodb_additional_mem_pool_size = 2M
# Set .._log_file_size to 25 % of buffer pool size
#innodb_log_file_size = 5M
#innodb_log_buffer_size = 8M
#innodb_flush_log_at_trx_commit = 1
#innodb_lock_wait_timeout = 50

character-set-server=utf8

[mysqldump]
quick
max_allowed_packet = 16M

default-character-set=utf8

[mysql]
no-auto-rehash
# Remove the next comment character if you are not familiar with SQL
#safe-updates

default-character-set=utf8

[isamchk]
key_buffer = 20M
sort_buffer_size = 20M
read_buffer = 2M
write_buffer = 2M

[myisamchk]
key_buffer_size = 20M
sort_buffer_size = 20M
read_buffer = 2M
write_buffer = 2M

[mysqlhotcopy]
interactive-timeout

# End /etc/mysql/my.cnf
EOF

porg -lp+ $TARGET "\
touch /etc/mysql/my.cnf"

mysql_install_db --basedir=/usr --datadir=/srv/mysql --user=mysql
chown -R mysql:mysql /srv/mysql

install -v -m755 -o mysql -g mysql -d /run/mysqld
mysqld_safe --user=mysql 2>&1 >/dev/null &

mysqladmin -u root password 1268

mysqladmin -p shutdown

