#!/bin/sh

. ./_blfsset.sh

APPNAME=vsftpd
VER=3.0.2
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	Linux-PAM openssl
. $WRK/_checkOptions.sh  \
	tcp_wrappers libcap2
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

unset MAKEFLAGS

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

install -v -d -m 0755 /var/ftp/empty
install -v -d -m 0755 /home/ftp
groupadd -g 47 vsftpd
groupadd -g 45 ftp 
useradd -c "vsftpd User"  -d /dev/null -g vsftpd -s /bin/false -u 47 vsftpd
useradd -c anonymous_user -d /home/ftp -g ftp    -s /bin/false -u 45 ftp

if test "${OPTION_tcpwrappers}" == "1";  then
  echo "#define VSF_BUILD_TCPWRAPPERS" >>builddefs.h
fi
echo "#define VSF_BUILD_SSL" >>builddefs.h

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "\
install -v -m 755 vsftpd        /usr/sbin/vsftpd" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
install -v -m 644 vsftpd.8      /usr/share/man/man8" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
install -v -m 644 vsftpd.conf.5 /usr/share/man/man5" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
install -v -m 644 vsftpd.conf   /etc" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
cp -p /etc/vsftpd.conf{,.orig}" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

sed -i \
        -e '/anonymous_enable=YES/s/^anon.*$/#anon&/' \
        -e '/local_enable=YES/s/^#//' \
        -e '/write_enable=YES/s/^#//' \
        -e '/local_umask=022/s/^#//' \
        -e '/chroot_local_user=YES/s/^#//' \
        -e '/chroot_list_enable=YES/s/^#//' \
        -e '/chroot_list_file=\/etc\/vsftpd.chroot_list/s/^#//' \
        -e '/ls_recurse_enable=YES/s/^#//' \
        /etc/vsftpd.conf

cat >> /etc/vsftpd.conf << "EOF"
background=YES
nopriv_user=vsftpd
secure_chroot_dir=/var/ftp/empty

session_support=YES
pam_service_name=vsftpd
userlist_enable=YES
userlist_deny=YES
ssl_enable=YES
ssl_tlsv1=YES
ssl_sslv2=NO
ssl_sslv3=NO
rsa_cert_file=/etc/ssl/certs/vsftpd.pem
require_ssl_reuse=NO
allow_writeable_chroot=YES
debug_ssl=YES
log_ftp_protocol=YES
EOF

TimeEnd

openssl req -x509 -nodes -days 36500 -newkey rsa:1024 -keyout /etc/ssl/certs/vsftpd.pem -out /etc/ssl/certs/vsftpd.pem

paco -p+ $TARGET "\
touch /etc/ssl/certs/vsftpd.pem"

cat > /etc/pam.d/vsftpd << "EOF"
#%PAM-1.0
#auth       required    /lib/security/pam_listfile.so item=user sense=deny file=/etc/ftpusers onerr=succeed
auth       required     /lib/security/pam_unix.so shadow nullok
auth       required     /lib/security/pam_shells.so
account    required     /lib/security/pam_unix.so
session    required     /lib/security/pam_unix.so
EOF

paco -p+ $TARGET "touch /etc/pam.d/vsftpd"

cat > /etc/vsftpd.chroot_list << "EOF"
root
EOF

paco -p+ $TARGET "touch /etc/vsftpd.chroot_list"

cat > /etc/vsftpd.user_list << "EOF"
root
bin
daemon
adm
lp
sync
shutdown
halt
mail
news
uucp
operator
games
nobody
EOF

paco -p+ $TARGET "touch /etc/vsftpd.user_list"

cd ..
RemoveSrcDir
PacoingDone

