#!/bin/sh

. ./_xfceset.sh

APPNAME=libwnck
APPVER=2
VER=2.31.0
TARGET=$APPNAME-$VER
TARGETBALL=$XFCEDLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	gtk+-2 intltool
. $WRK/_checkOptions.sh  \
	gobject-introspection gtk-doc startup-notification
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr --disable-static --program-suffix=-1 \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make GETTEXT_PACKAGE=libwnck-1 \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "\
make GETTEXT_PACKAGE=libwnck-1 install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

