#/bin/sh

. ./_cblfsset.sh

APPNAME=acl
VER=2.2.51
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.src.tar.gz
TARGETDIR=$TARGET

echo $TARGET

checkRequired attr
checkOptions  ""
checkTarball
checkExit "$1" || exit $?

cd $SRC

BIT32
RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Configuring...
CC="gcc ${BUILD32}" ./configure --prefix=/ --exec-prefix=/ --sbindir=/sbin \
  --bindir=/usr/sbin --libdir=/lib --libexecdir=/usr/lib --includedir=/usr/include \
  --mandir=/usr/share/man --datadir=/usr/share \
	1> $LOG/$TARGET.$BIT.1_conf.log 2>&1 || exit 1

echo Making...
make DEBUG=-DNDEBUG LIBTOOL="$PWD/libtool" \
	1> $LOG/$TARGET.$BIT.2_make.log 2>&1 || exit 1

echo Installing...
paco -p $TARGET "\
make LIBTOOL=$PWD/libtool install install-dev install-lib" \
	1> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
chmod -v 755 /lib/libacl.so.1.1.0 \
	1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1

TimeEnd
cd ..

BIT64
RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Configuring...
CC="gcc ${BUILD64}" ./configure --prefix=/ --exec-prefix=/ --sbindir=/sbin \
  --bindir=/usr/sbin --libdir=/lib64 --libexecdir=/usr/lib64 --includedir=/usr/include \
  --mandir=/usr/share/man --datadir=/usr/share \
        1> $LOG/$TARGET.$BIT.1_conf.log 2>&1 || exit 1

echo Making...
make DEBUG=-DNDEBUG LIBTOOL="$PWD/libtool" \
        1> $LOG/$TARGET.$BIT.2_make.log 2>&1 || exit 1

echo Installing...
paco -p+ $TARGET "\
make LIBTOOL=$PWD/libtool install install-dev install-lib" \
        1> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
chmod -v 755 /lib64/libacl.so.1.1.0 \
        1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1

TimeEnd
cd ..
RemoveSrcDir
PacoingDone

