#/bin/sh

. ./_clfsset.sh

APPNAME=bzip2
VER=1.0.6
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir
rm -f /usr/lib/libbz2.so
Extract
TimeStart

cd $TARGETDIR

sed -i -e 's:ln -s -f $(PREFIX)/bin/:ln -s :' Makefile
sed -i 's@X)/man@X)/share/man@g' ./Makefile

echo Making...
make -f Makefile-libbz2_so CC="gcc ${BUILD32}" CXX="g++ ${BUILD32}" \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1
make clean \
	1>> $LOG/$THISFILE.2_make.log 2>&1 || exit 1
make CC="gcc ${BUILD32}" CXX="g++ ${BUILD32}" libbz2.a \
	1>> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
cp -v libbz2.a /usr/lib \
	1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
cp -av libbz2.so* /lib \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
ln -sv ../../lib/libbz2.so.1.0 /usr/lib/libbz2.so \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir

echo Done.
