#/bin/sh

. ./_clfsset.sh

APPNAME=tar
VER=1.27.1
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Patching...
patch -Np1 -i $DLD/tar-$VER-manpage-1.patch \
	1> $LOG/$THISFILE.0_patch.log 2>&1 || exit 1

echo Configuring...
FORCE_UNSAFE_CONFIGURE=1 CC="gcc ${BUILD64}" \
  ./configure --prefix=/usr \
    --bindir=/bin --libexecdir=/usr/sbin \
	1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make install \
	1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

perl tarman > /usr/share/man/man1/tar.1 \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

make -C doc install-html docdir=/usr/share/doc/tar-1.27.1 \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir

echo Done.
