#/bin/sh

. ./_clfsset.sh
. ./_6clfsset.sh

APPNAME=ncurses
VER=5.9
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo Patching...
patch -Np1 -i $DLD/ncurses-$VER-bash_fix-1.patch \
	1> $LOG/$THISFILE.0_patch.log 2>&1 || exit 1

echo Configuring...
./configure --prefix=/tools --with-shared \
   --build=${CLFS_HOST} --host=${CLFS_TARGET} \
   --without-debug --without-ada \
   --enable-overwrite --with-build-cc=gcc \
   --libdir=/tools/lib64 \
	1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make install \
	1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir

echo Done.

