#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

VER=1.0.6
TARGET=bzip2-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

echo $CHAP: $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR

echo \ \ Patching...
patch -Np1 -i $DLD/bzip2-$VER-install_docs-1.patch || exit 1

sed -i 's@\(ln -s -f \)$(PREFIX)/bin/@\1@' Makefile

sed -i "s@(PREFIX)/man@(PREFIX)/share/man@g" Makefile

echo \ \ Making...
make -f Makefile-libbz2_so \
	1> $LOG/$CHAP.$TARGET.1_make.log 2>&1 || exit 1

echo \ \ Cleaning...
make clean \
	1> $LOG/$CHAP.$TARGET.2_clean.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.3_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p $TARGET "make PREFIX=/usr install" \
	1> $LOG/$CHAP.$TARGET.4_install.log 2>&1 || exit 1

paco -p+ $TARGET "cp -v bzip2-shared /bin/bzip2" \
	1>> $LOG/$CHAP.$TARGET.4_install.log 2>&1 || exit 1

paco -p+ $TARGET "cp -av libbz2.so* /lib" \
	1>> $LOG/$CHAP.$TARGET.4_install.log 2>&1 || exit 1

paco -p+ $TARGET "ln -sv ../../lib/libbz2.so.1.0 /usr/lib/libbz2.so" \
	1>> $LOG/$CHAP.$TARGET.4_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
rm -v /usr/bin/{bunzip2,bzcat,bzip2}" \
	1>> $LOG/$CHAP.$TARGET.4_install.log 2>&1 || exit 1

paco -p+ $TARGET "ln -sv bzip2 /bin/bunzip2"
paco -p+ $TARGET "ln -sv bzip2 /bin/bzcat"

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo $CHAP, $TARGET, $START, $END \
	>> $TME/lfstime.txt

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

echo \ \ Done.

