#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

VER=6.2
TARGET=readline-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

echo $CHAP: $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR

sed -i '/MV.*old/d' Makefile.in
sed -i '/{OLDSUFF}/c:' support/shlib-install

echo Patching...
patch -Np1 -i $DLD/readline-$VER-fixes-1.patch || exit 1

echo \ \ Configuring...
./configure --prefix=/usr --libdir=/lib \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make SHLIB_LIBS=-lncurses \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p $TARGET "make install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "mv -v /lib/lib{readline,history}.a /usr/lib" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "rm -v /lib/lib{readline,history}.so" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "ln -sfv ../../lib/libreadline.so.6 /usr/lib/libreadline.so" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "ln -sfv ../../lib/libhistory.so.6 /usr/lib/libhistory.so" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

mkdir   -v       /usr/share/doc/readline-$VER \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "install -v -m644 doc/*.{ps,pdf,html,dvi} \
                 /usr/share/doc/readline-$VER" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || echo Error occured while copying

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo $CHAP, $TARGET, $START, $END \
	>> $TME/lfstime.txt

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

echo \ \ Done.

