#include "stdafx.h"
#include "nlite_include.h"



namespace nlite{
	
	namespace nliteregex{
		namespace text{
			const  CString URL_TEXT = TEXT("(https?|ftp)(://[-_.!~*\'()a-zA-Z0-9;/?:@&=+$,%#]+)");
			const  CString TAG_TEXT = TEXT("<[\"_;!?,\\:.'$%&#/a-zA-Z0-9= ]*>");
			const  CString VIDEOID_TEXT = TEXT("(sm|nm)([0-9])+");
			const  CString LIVEID_TEXT = TEXT("(lv)([0-9])+");
			const  CString LINK_TEXT = TEXT("(") + URL_TEXT + TEXT(")|(") + VIDEOID_TEXT + TEXT(")|(") + LIVEID_TEXT + TEXT(")");
			const  CString SEARTCH_AT_MARK(TEXT("(.*)(@|)([^ |^@][^@^]+)"));
			const  tstring NUTHINGSTRING(TEXT(""));
		}
		const  tregex URL(text::URL_TEXT);
		const  tregex TAGSTRING(text::TAG_TEXT);
		const  tregex VIDEOID(text::VIDEOID_TEXT);
		const  tregex LIVEID(text::LIVEID_TEXT);
		const  tregex LILNKREGEX(text::LINK_TEXT);
		const tregex NAMESERTCHREGEX(text::SEARTCH_AT_MARK);
	}
	CProperty nliteProperty;	
	CListenerList nlite::listenerList;
	TCHAR appFolderPath[_MAX_PATH];
	CString ncvAppSettingPath;
	TCHAR localAppDataPath[_MAX_PATH];
	speaker::ISpeaker &g_speaker = speaker::ISpeaker::GetMeiNormal(TEXT("libs\\Voice\\mei_normal\\"),TEXT("libs\\open_jtalk_dic\\"));
	WSAData wsaData;							//winsockdata
	HINTERNET hInternet = NULL;
	CNliteMainFrame wnd;						//Ct[EBhE

	VOID nlite::UnexpectedErrorMessageShow(LPCTSTR headMessage,LPCTSTR summary,UINT line,LPCTSTR fileName,LPCTSTR function){
		

		


		TCHAR file[_MAX_PATH];
		TCHAR ext[_MAX_PATH];
		_wsplitpath(fileName,(wchar_t*)NULL,(wchar_t*)NULL,file,ext);
		DWORD lastErrorCode = ::GetLastError();
		LPTSTR lpMsgBuf;
		FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS, NULL, lastErrorCode,MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), (LPTSTR) &lpMsgBuf,0,(va_list*)NULL);
		
		BugTrail bugtrail;
		bugtrail.sourcefile.Format(TEXT("%s%s"),file,ext);
		bugtrail.summary = summary;
		bugtrail.function = function;
		bugtrail.line.Format(TEXT("%d"),line);
		bugtrail.windowsErrorCode.Format(TEXT("%d"),lastErrorCode);
		bugtrail.windowsErrorMessage = lpMsgBuf;
		LocalFree(lpMsgBuf);
	

		tstring errMessage;
		errMessage = headMessage;
		errMessage += TEXT("z肳ĂȂG[܂BoO|[g𑗐M܂H\r\n");
		errMessage += TEXT("\r\nG[bZ[W:");
		errMessage += summary;
		int rs = ::MessageBox(NULL,errMessage.c_str(),TEXT("z肳ĂȂG["),MB_ICONERROR | MB_YESNO);
		
		
		CBugReport bugreport;
		if(rs == IDYES){
			
			bugreport.SendBugReport(hInternet,bugtrail);

		}
		
		
		
		
		return;
	}

	HINSTANCE OpenURL(HWND hwnd,const CGeneralProperty &gp,LPCTSTR url ,INT nShowCommand){

		HINSTANCE rslt;

		if(gp.GetBrowserPath().Length() == 0){

			rslt = ShellExecute(hwnd, NULL, url, NULL, NULL, nShowCommand);

		} else{

			rslt = ShellExecute(hwnd, NULL, gp.GetBrowserPath(), url, NULL, nShowCommand);

		}

		return rslt;

	}

	BOOL SurelyCreate(LPCTSTR dir,BOOL bFile){



		BOOL rslt = FALSE;
		std::vector<TCHAR> buf(_tcslen(dir) + 1);
		_tcscpy(&buf[0],dir);


		if( (PathFileExists(dir) && (!bFile || !::PathIsDirectory( dir )))){

			goto success;
		}

		LPTSTR startPtr = &buf[0];
		LPTSTR indexPtr = startPtr;
		LPTSTR cmpPtr;
		do {

			cmpPtr = _tcsstr(indexPtr,TEXT("\\"));

			if(cmpPtr == NULL){

				if(bFile == TRUE){
					CAtlFile file;
					if( file.Create(startPtr,0,0,OPEN_ALWAYS,FILE_ATTRIBUTE_NORMAL) != S_OK){

						goto err;

					}
				} else {

					::CreateDirectory(startPtr,0);
				}

				break;


			}else if(indexPtr == cmpPtr){
				break;

			}

			cmpPtr[0] = TEXT('\0');
			::CreateDirectory(startPtr,0);
			cmpPtr[0] = TEXT('\\');
			cmpPtr++;
			indexPtr = cmpPtr;


		}while(indexPtr[0] != TEXT('\0'));

success:


		rslt = TRUE;

end:

		return rslt;


err:
		rslt = FALSE;
		goto end;
	}


	///
	///NCV[Ut@CpX擾XMLp[T
	///
	class CReadNCVListenerInfoFile:public CXmlParser{

	private:

		BOOL settingDirFlag;
		CString &path;	




	public:

		CReadNCVListenerInfoFile(CString &in_path):settingDirFlag(FALSE),path(in_path){}

		void OnStartElement (const XML_Char *pszName, const XML_Char **papszAttrs){

			if(_tcscmp(pszName,TEXT("SettingDir")) == 0){

				settingDirFlag = TRUE;

			}

		}

		void OnEndElement (const XML_Char *pszName){

			if(_tcscmp(pszName,TEXT("SettingDir")) == 0){

				settingDirFlag = FALSE;

			}

		}

		void OnCharacterData (const XML_Char *pszData, int nLength){

			if(settingDirFlag == TRUE){

				path.Append(pszData,nLength);

			}

		}
	};

	CString GetNCVListenerInfoFilePath(){


		CString rslt;


		if((PathFileExists(ncvAppSettingPath) &&  (!::PathIsDirectory( ncvAppSettingPath )))){


			CAtlFile ncvAppSettingFile;
			ULONGLONG ncvAppSettingFileSize = 0;
			if(SUCCEEDED(ncvAppSettingFile.Create(ncvAppSettingPath,GENERIC_READ,FILE_SHARE_READ,OPEN_ALWAYS)) == FALSE ||
				SUCCEEDED(ncvAppSettingFile.GetSize(ncvAppSettingFileSize)) == FALSE){

					throw Exception(TEXT("NCV̐ݒt@Cǂݍ߂܂ł"),__LINE__,TEXT(__FILE__),TEXT(__FUNCTION__));

			}
			std::vector<char> fileBuf(static_cast<UINT_PTR>(ncvAppSettingFileSize) / sizeof(char) + (1 * sizeof(char)));
			ncvAppSettingFile.Read(&fileBuf[0],fileBuf.size());
			LPSTR startPtr = strstr(&fileBuf[0],"<");
			if(startPtr != NULL){
				CReadNCVListenerInfoFile parser(rslt);
				parser.Parse(startPtr);
				rslt += TEXT("UserSetting.xml");

			}

		}




		return rslt;
	}



	const CApplicationInfo * appInfo = NULL;





	BOOL InitializeNlite(){

		BOOL rslt = FALSE;

		try{

			nlite::appInfo = &CApplicationInfo::getInstance();
			INT_PTR err;
			INT_PTR count = 0;

			//WSAData
			while((err = WSAStartup(MAKEWORD(2,0),&wsaData)) == WSASYSNOTREADY){

				count++;
				if(count >= 5)break;
				Sleep(500);



			}

			if(err != ERROR_SUCCESS){

				throw AppInitException(__LINE__,TEXT(__FILE__),TEXT(__FUNCTION__));
			}

			//AvP[VCX^X
			const CApplicationInfo &appInfo = CApplicationInfo::getInstance();
			CNLiteString userAgent;
			userAgent = appInfo.getProcuctName();
			userAgent += TEXT("/");
			userAgent += appInfo.getProductVersion();



			//HTTPIuWFNg
			hInternet = WinHttpOpen(userAgent,WINHTTP_ACCESS_TYPE_DEFAULT_PROXY,(LPCWSTR)WINHTTP_NO_PROXY_NAME,(LPCWSTR)WINHTTP_NO_PROXY_BYPASS,0);

			if(hInternet == NULL){

				throw AppInitException(__LINE__,TEXT(__FILE__),TEXT(__FUNCTION__));

			}

			//nlib̏
			InitializeNLIB(hInternet);

			//[JAvP[VtH_
			if(SHGetFolderPathW(0,CSIDL_LOCAL_APPDATA,0,SHGFP_TYPE_CURRENT,localAppDataPath) != S_OK){

				throw AppInitException(__LINE__,TEXT(__FILE__),TEXT(__FUNCTION__));
			}

			
			
			


			if(SHGetFolderPathW(0,CSIDL_APPDATA,0,SHGFP_TYPE_CURRENT,appFolderPath) != S_OK){

				throw AppInitException(__LINE__,TEXT(__FILE__),TEXT(__FUNCTION__));
			}
			ncvAppSettingPath = appFolderPath;
			ncvAppSettingPath += TEXT("\\posite-c\\NiconamaCommentViewer\\AppSetting.xml");

			nliteProperty.ReadProperty();

			if((nliteProperty.GetGeneralProperty().IsNCVUserSettingReaded() == FALSE)){

				ReadNCVListenerData();
			}

			listenerList.ReadProperty(nliteProperty.GetListenerDataPath());

			
			rslt = TRUE;
		}catch (AppInitException e){

			rslt = FALSE;

		}
	

		return rslt;
	}


	VOID FinalizeNlite(){

		//Ct[EBhE㏈
		wnd.Finalaize();

		//nlib㏈
		FinalizeNLIB();

		//HTTPIuWFNgJ
		WinHttpCloseHandle(hInternet);

		//winsockJ
		WSACleanup();

		return;
	}


	BOOL ReadNCVListenerData(){

		BOOL rslt = FALSE;

		if((PathFileExists(ncvAppSettingPath) &&  (!::PathIsDirectory( ncvAppSettingPath )))){
		
			if((::MessageBox(NULL,TEXT("NCṼXi[Ɠ܂H"),TEXT("Xi[ǂݍ"),MB_OK | MB_OKCANCEL) == IDOK)){
				listenerList.ReadProperty(GetNCVListenerInfoFilePath());
			}
			nliteProperty.GetGeneralProperty().SetNCVUSerSettingReaded(TRUE);
			rslt = TRUE;
		}

		return rslt;
	}
}

