
#ifndef __CIMAGEMANAGER_H__
#define __CIMAGEMANAGER_H__

#include "..\CommonIncludes.h"

//==============================================================
//! @class CImageManager
//! @brief 摜̊ǗNX
//! 
//! yǂݍމ摜ǉ@z
//!     
//!     yfilename_00.pngzyFILENAME_00zƂv̂
//!     ǉ摜t@C̃t@CA
//!     gq啶ɂ̂
//!     yCImageManager.hźyEImageIDz񋓌^̗񋓒萔ɒǉ܂B
//!     
//!     ̎ɁA
//!     yCImageManager.cppz
//!     const TCHAR* CImageManager::PATHS[]
//!     
//!     ɊɏĂ鑼̍sɍ킹ăpXǉĊłB
//! 
//! ygp摜ɂāz
//! 
//!     sxARGB摜gpĂB
//! 
//! ypXwɂāz
//!     
//!     y????.vcxprojzƂgq̃t@CuĂKw
//!     JgfBNgłB
//!
//==============================================================
class CImageManager {
public:
	
	//! @brief ʂ̉
	const static int CLIENT_AREA_WIDTH    = 960;
	
	//! @brief ʂ̏c
	const static int CLIENT_AREA_HEIGHT   = 540;
	
	//==============================================================
	//! @enum  EImageID
	//! @brief 摜t@ČŗLʎq
	//! 
	//!     j
	//!         yTITLE_BACKźytitle_back.pngzt@CƑΉĂ܂B
	//!
	//==============================================================
	enum EImageID {
		TITLE_BACK,
		CONQUEST_BACK,
		TERMINAL_BACK,
		
		FADE,
		
		MOVE_AREA,
		NOT_MOVE_AREA,
		
		PROTAGONIST_STANDING,
		PROTAGONIST_FORWARD,
		PROTAGONIST_BACK,
		PROTAGONIST_LEFT,
		PROTAGONIST_RIGHT,
		
		TOTAL,
	};
	
	//==============================================================
	//! @attention
	//! vO̎sɁAxCX^X
	//! łȂ悤ɂȂĂ܂BRs[o܂B
	//! 
	//! externtO[oϐ̂悤ɐU镑A
	//! fUCp^[ySingletonzƈقȂAx悤ƂƗ܂B
	//! deleteɁAnewĂ邽߁AXR[v𔲂Ƃ
	//! |C^ێĂȂƓxƎg܂̂łӂB
	//! 
	//==============================================================
	CImageManager( void );
	
	//==============================================================
	//! @brief     摜t@CꊇŃ[h܂B
	//! 
	//!     ǂݍ݂Ɏsƃt@CX[܂B
	//==============================================================
	int Load( void ) throw( ... );
	
	//==============================================================
	//! @brief     摜̕`
	//! 
	//!     XYWEImageID񋓌^Őݒ肳ꂽ񋓒萔
	//!     w肵ĕ`悵܂B
	//!     sxARGB摜Ƃĕ\܂B
	//==============================================================
	void Draw( int arg_iX, int arg_iY, EImageID arg_eImageID );
	
	//==============================================================
	//! @brief     xݒ肵ĕ`
	//==============================================================
	void DrawAlpha( int      arg_iX,
                    int      arg_iY,
                    EImageID arg_eImageID,
                    int      arg_iAlpha );
	
private:
	//! @brief 摜t@C̃pX
	const static TCHAR* PATHS[ EImageID::TOTAL ];
	
	//==============================================================
	//! @struct tag_Graphics
	//! @brief 摜̏ێ\
	//! 
	//!     摜̃nhAAێł܂B
	//!     摜̃nhAAƂȂĂȂŔA
	//!     XY̏Ԃɍ킹Ă邽߂łB
	//! 
	//==============================================================
	struct tag_Graphics {
		int iHandle;
		int iWidth;
		int iHeight;
	};
	
	//==============================================================
	//!     XWyWnzyWnzɕϊ܂B
	//==============================================================
	int GetTransformedCoordinates_X( int arg_iX );
	
	//==============================================================
	//!     YWyWnzyWnzɕϊ܂B
	//==============================================================
	int GetTransformedCoordinates_Y( EImageID arg_eImageID, int arg_iY );
	
	//==============================================================
	//! @brief 摜̏ێ\̂̕ϐłB
	//! 
	//!     摜̃nhAAێĂ܂B
	//!     摜̃nhAȀƂȂĂȂŔA
	//!     XY̏Ԃɍ킹Ă邽߂łB
	//==============================================================
	tag_Graphics m_aSGraphics[ EImageID::TOTAL ];
	
	
	//! Rs[␶łȂ悤邽߁AprivateoɂĂ܂B
	CImageManager( const CImageManager& rhs );
	//! Rs[␶łȂ悤邽߁AprivateoɂĂ܂B
	CImageManager& operator=( const CImageManager& rhs );
};

#endif




