
#include "..\..\00_HeaderFiles\00_ManagementClasses\CImageManager.h"
#include "..\..\00_HeaderFiles\00_ManagementClasses\CMapCellManager.h"

CImageManager::CImageManager( void )
{
	// x悤ƂƂ̓vOIB
	static bool bFirstGeneration = true;
	if ( bFirstGeneration ) {
		bFirstGeneration = false;
		return;
	}
	
	MessageBox( NULL,
	            "CImageManagerNXx悤Ƃ܂B",
	            "",
	            MB_OK );
	
	assert( false );
}

// 摜t@C̃pX
const TCHAR* CImageManager::PATHS[ CImageManager::EImageID::TOTAL ] = {
    "01_Images\\title_back.png",
    "01_Images\\conquest_back.png",
    "01_Images\\terminal_back.png",
    "01_Images\\fade.png",
    "01_Images\\move_area.png",
    "01_Images\\not_move_area.png",
    "01_Images\\protagonist_standing.png",
    "01_Images\\protagonist_forward.png",
    "01_Images\\protagonist_back.png",
    "01_Images\\protagonist_left.png",
    "01_Images\\protagonist_right.png",
};

int CImageManager::Load( void ) throw( ... )
{
	for ( int i = 0; i < EImageID::TOTAL; i++ ) {
		m_aSGraphics[ i ].iHandle = LoadGraph( PATHS[ i ] );
		
		// 萔Ƃ̓lZł͒萔ӂƂB
		if ( -1 == m_aSGraphics[ i ].iHandle )
		{
			std::stringstream sstr;
			
			sstr << "摜t@C" << std::endl 
			     << "    " << PATHS[ i ] << std::endl
			     << "̓ǂݍ݂Ɏs܂B" << std::endl;
			throw sstr.str();
		}
		
		// 摜t@C̕ƍ\̂Ɋi[B
		GetGraphSize( m_aSGraphics[ i ].iHandle,
		              &m_aSGraphics[ i ].iWidth,
		              &m_aSGraphics[ i ].iHeight );
		
	}
	
	return 0;
}

void CImageManager::Draw( int arg_iX,
                          int arg_iY, 
                          EImageID arg_eImageID )
{
	// Wn̍Wi[邽߂̕ϐ
	int iFoundationCoordinates_X;
	int iFoundationCoordinates_Y;
	
	// Wnɕϊ
	iFoundationCoordinates_X = GetTransformedCoordinates_X( arg_iX );
	iFoundationCoordinates_Y = GetTransformedCoordinates_Y( arg_eImageID, arg_iY );
	
	DrawGraph( iFoundationCoordinates_X,
	           iFoundationCoordinates_Y,
	           m_aSGraphics[ arg_eImageID ].iHandle,
	           TRUE );
	
}

void CImageManager::DrawAlpha( int      arg_iX,
                               int      arg_iY,
                               EImageID arg_eImageID,
                               int      arg_iAlpha )
{
	
	// Wn̍Wi[邽߂̕ϐ
	int iFoundationCoordinates_X;
	int iFoundationCoordinates_Y;
	
	// Wnɕϊ
	iFoundationCoordinates_X = GetTransformedCoordinates_X( arg_iX );
	iFoundationCoordinates_Y = GetTransformedCoordinates_Y( arg_eImageID, arg_iY );
	
	SetDrawBlendMode( DX_BLENDMODE_ALPHA, arg_iAlpha );

	DrawGraph( iFoundationCoordinates_X,
	           iFoundationCoordinates_Y,
	           m_aSGraphics[ arg_eImageID ].iHandle,
	           TRUE );

	SetDrawBlendMode( DX_BLENDMODE_NOBLEND, 255 );
}

int CImageManager::GetTransformedCoordinates_X( int arg_iX )
{
	return arg_iX;
}

int CImageManager::GetTransformedCoordinates_Y( EImageID arg_eImageID, int arg_iY )
{
	// ㉺t]
	arg_iY = CMapCellManager::CLIENT_AREA_HEIGHT - arg_iY;
	
	// 摜̍オ`_ƂȂĂ邽ߍɂ
	arg_iY -= m_aSGraphics[ arg_eImageID ].iHeight;

	return arg_iY;
}






