	.list ON, EXP
	
; Compiling definitions and their primitives for fig-FORTH for SH-3
; Joel Matthew Rees, Hyougo Polytec Center
; 2014.03.11

; Licensed extended under GPL v. 2 or 3, or per the following:
; ------------------------------------LICENSE-------------------------------------
;
; Copyright (c) 2009, 2010, 2011 Joel Matthew Rees
;
; Permission is hereby granted, free of charge, to any person obtaining a copy
; of this software and associated documentation files (the "Software"), to deal
; in the Software without restriction, including without limitation the rights
; to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
; copies of the Software, and to permit persons to whom the Software is
; furnished to do so, subject to the following conditions:
;
; The above copyright notice and this permission notice shall be included in
; all copies or substantial portions of the Software.
;
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
; OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
; THE SOFTWARE.
;
; --------------------------------END-OF-LICENSE----------------------------------

; Monolithic, not separate assembly:
; context.inc must be included before this file.
;	.include	"context.inc"
;
;	.section	compiler, code


; :       ( --- )                                                 P
;         { : name sundry-stuff ; } typical input
;
;         If executing, record the data stack mark in CSP, CREATE a
;         header, compile a call to DOCOL, and set state to compile. 
;
;         The interpreter will remain in a compiling state, 
;         compiling as literals the characteristic addresses 
;         of all non-IMMEDIATE symbols (words) it scans, 
;         until it scans a terminating (IMMEDIATE) symbol such as 
;         ";" or ";CODE".
;
;         CONTEXT (interpretation) vocabulary is set to CURRENT.
;
; DOCOL   ( *** IP )
;         Characteristic of a colon (:) definition.  Begins execution of a
;         high-level definition, i. e., nests the definition and begins
;         processing icodes. 
;
;         In the low-level description, it pushes the IP
;         and loads the Parameter Field Address of the definition which
;         called it into the IP.
;
;         SEMIS un-nests out of list interpretation.
;         DOCOL nests in.
;         This is the way that lists get interpreted.
;
;         Should DOCOL have a header? 
;         -- The fig model for 6800 does not give it one.
;
;         See NEXT loop.
;
	HIHEADER	":", COLON, DOCOL, MIMM
	.data.l	QEXEC,SCSP,CURENT,AT,CONTXT,STORE
	.data.l	CREATE,RBRAK
	.data.l	PSCODE
DOCOL:
_fDOCOL:
	mov.l	fIP, @-fRP	; Remember where we were.
	mov 	fW, fIP		; fW is still pointing at the characteristic (CFA).
	rts
	add 	#NATURAL_SIZE, fIP	; bump it before we start


; ;       ( --- )                                                 P
;         { : name sundry-stuff ; } typical input
;         ERROR check data stack against mark in CSP, compile ;S, unSMUDGE
;         LATEST definition, and set state to interpretation.
;
	HIHEADER	";", SEMI, DOCOL
	.data.l	QCSP,COMPIL,SEMIS,SMUDGE,LBRAK
	.data.l	SEMIS


; CONSTANT        ( n --- )
;         { value CONSTANT name } typical input
;         CREATE a header, compile a call to DOCON, 
;         compile the constant value.
;
; DOCON   ( --- n ) 
;         Characteristic of a CONSTANT.  A CONSTANT simply loads its value
;         from its parameter field and pushes it on the stack.
;
	HIHEADER	CONSTANT, CON, DOCOL
	.data.l	CREATE,SMUDGE,COMMA,PSCODE
DOCON:
_fDOCON:
	mov.l	@(NATURAL_SIZE,fW), r0
	rts
	mov.l	r0, @-fSP


; VARIABLE        ( init --- )
;         { init VARIABLE name } typical input
;         CREATE a header, compile a call to XVAR, compile the initial
;         value init.
;
; DOVAR   ( --- vadr )    jsr <XVAR (bif.m, bifdp.a)
;         Characteristic of a VARIABLE.  A VARIABLE pushes its PFA address
;         on the stack.  The parameter field of a VARIABLE is the actual
;         allocation of the variable, so that pushing its address allows
;         its contents to be @ed (fetched).  Ordinary arrays and strings
;         that do not subscript themselves may be allocated by defining a
;         variable and immediately ALLOTting the remaining space.
;         VARIABLES are global to all users, and thus should have been
;         hidden in resource monitors, but aren't.
;
	HIHEADER	VARIABLE, VAR, DOCOL
	.data.l	CON,PSCODE
DOVAR:
_fDOVAR:
	add 	#NATURAL_SIZE, fW
	rts
	mov.l	fW, @-fSP


; USER    ( u --- )
;         { uoffset USER name } typical input
;         CREATE a header, compile a call to DOUSER, 
;         compile the unsigned offset.
;         The offset is treated by DOUSER as an offset into the 
;         per-user variable table. 
;
;         The HUMAN user is entirely responsible for maintaining allocation!
;
; DOUSER  ( --- vadr ) 
;         Characteristic of a per-USER variable. USER variables are
;         similiar to VARIABLEs, but are allocated (by hand!) in the
;         per-user table.  A USER variable's parameter field contains its
;         offset in the per-user table.
;
;         DOUSER adds the compiled offset to the base of the per-user table
;         and pushes the resulting address.
;
	HIHEADER	USER, USER, DOCOL
	.data.l	CON,PSCODE
DOUSER:
_fDOUSER:
	mov.l	@(NATURAL_SIZE,fW), r0
	add 	fUP, r0
	rts
	mov.l	r0, @-fSP	


; CURRENT  ( --- vadr )
;          NFA of LATEST definition.  Not fig.
;          Pointer to the current compiling vocabulary. 
;
;          See CONTEXT and VOC-LINK.
;
	HIHEADER	CURRENT, CURENT, DOUSER
	.data.l	XCURR


; STATE    ( --- vadr )
;          Compiler/interpreter state.
;
	HIHEADER	STATE, STATE, DOUSER
	.data.l	XSTATE	;	Non-zero if compiling, 0 if not
	

; CSP      ( --- vadr )
;          Compiler stack mark for stack check.
;          (The so-called "compiler security" feature.)
;
	HIHEADER	CSP, CSP, DOUSER
	.data.l	XCSP


; HERE   ( --- adr )
;        Get contents of DP, or the current allocation location.
;        More than a pseudo-constant.
;        Kind of like the here symbol in assemblers.
;
	HIHEADER	HERE, HERE, DOCOL
	.data.l	DP,AT
	.data.l	SEMIS


; ALLOT  ( n --- )
;        Increase/decrease heap allocation mark (add signed n to DP).
;
	HIHEADER	ALLOT, ALLOT, DOCOL
	.data.l	DP,PSTORE
	.data.l	SEMIS


; ,      ( n --- )
;        Store natural word n at DP+.
;        (Store and allocate, which is the wrong order for things.)
;
	HIHEADER	",", COMMA, DOCOL
	.data.l	HERE,STORE,NWIDTH,ALLOT
	.data.l	SEMIS



; C,     ( b --- )
;        Store byte b at DP+.
;        (Store and allocate, which is the wrong order for things.)
;
	HIHEADER	"C,", CCOMM, DOCOL
	.data.l	HERE,CSTORE,ONE,ALLOT
	.data.l	SEMIS


