	.list ON, EXP
	
; FORTH input/output definitions for fig-FORTH for SH-3
; Joel Matthew Rees, Hyougo Polytec Center
; 2014.03.05

; Licensed extended under GPL v. 2 or 3, or per the following:
; ------------------------------------LICENSE-------------------------------------
;
; Copyright (c) 2009, 2010, 2011 Joel Matthew Rees
;
; Permission is hereby granted, free of charge, to any person obtaining a copy
; of this software and associated documentation files (the "Software"), to deal
; in the Software without restriction, including without limitation the rights
; to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
; copies of the Software, and to permit persons to whom the Software is
; furnished to do so, subject to the following conditions:
;
; The above copyright notice and this permission notice shall be included in
; all copies or substantial portions of the Software.
;
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
; OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
; THE SOFTWARE.
;
; --------------------------------END-OF-LICENSE----------------------------------

; Monolithic, not separate assembly:
; context.inc must be included before this file.
;	.include	"context.inc"
;
;	.section	inputoutput, code


; EMIT, KEY, QTERM, and CR are assumed to be the focus 
; of porting to new hardware.

; These are stubs which call real drivers defined in driver.inc
; In the fig-FORTH model, you see the stubs around screen 21.
; And you see the drivers around screen 63.

; Contrary to usual practice, I am assuming the drivers 
; use the stack instead of registers to pass results.
; No particular reason not use the registers, of course.


; EMIT    ( c --- )
;         Write c to the terminal device, whatever that may be.
;         Increment the OUT per USER variable.
;
	HEADER	EMIT, EMIT
	sts.l	PR, @-fRP
	mov.l	#_fPEMIT, r1	; May be within range of absolute call?
	jsr 	@r1
	nop
	mov.l	#XOUT, r0	; We defined XOUT as the offset itself.
	mov.l	@(r0,fUP), r1
	add 	#1, r1
	lds.l	@fRP+, PR
	rts
	mov.l	r1, @(r0,fUP)
	

; KEY     ( --- c )
;         Leave the ascii value of the next terminal key struck.
;
	HEADER	KEY, KEY
	sts.l	PR, @-fRP
	mov.l	#_fPKEY, r1	; May be within range of absolute call?
	jsr 	@r1
	nop
	mov.l	@fSP, r1
	mov.l	#H'000000ff, r0
	and 	r1, r0
	lds.l	@fRP+, PR
	rts
	mov.l	r0, @fSP


; ?TERMINAL       ( --- f )
;        Perform a test of the terminal keyboard for actuation of the break
;        key. A true flag indicates actuation.
;        In other words, scan keyboard, but do not wait.  
;        Return true if break key currently pressed, 0 otherwise.
;        Ignores any keys buffered up, in theory.
;        But this definition is installation dependent,
;        and may not give exactly these results.
;
	HEADER	"?TERMINAL", QTERM
	sts.l	PR, @-fRP
	mov.l	#_fPQTER, r1	; May be within range of absolute call?
	jsr 	@r1
	nop		; Might need to filter results?
	lds.l	@fRP+, PR
	rts
	nop


; CR      ( --- )
;         Transmit a carriage return and line feed to the selected output
;         device.
;
	HEADER	CR, CR
	sts.l	PR, @-fRP
	mov.l	#_fPCR, r1	; May be within range of absolute call?
	jsr 	@r1
	nop		; Might push a CR and EMIT, then a LF and EMIT?
	lds.l	@fRP+, PR
	rts
	nop




; FIRST  ( --- adr )     The base of the disk buffer space.
;        Returns the address of the lowest disk block buffer.
;
	HIHEADER	FIRST, FIRST, DOCON
	.data.l	DISK_BUFFERS


; LIMIT  ( --- adr )     The limit of the disk buffer space.
;        Returns the address one beyond the highest disk block buffer.
;        In many fig FORTHs, this would mark the end of system memory.
;        Not so in this SH-3 implementation.
;
	HIHEADER	LIMIT, LIMIT, DOCON
	.data.l	DISK_BUFFERS_END


; B/BUF  ( --- size )     The size, in bytes, of a buffer.
;        Bytes per buffer, or the size of a disk block.
;
	HIHEADER	"B/BUF", BBUF, DOCON
	.data.l	DISK_BUFFER_SIZE


; B/SCR  ( --- count )       The size, in buffers, of a screen.
;        Blocks per screen. 
;        A screen is the traditional unit of disk space in the old FORTH.
;
;        It's a good rule-of-thumb limit on the size of a word definition,
;        named for the size of a useable small screen --
;        16 lines, 64 columns in 20x80.
;
;        Many traditional FORTH text editors organized the screen this way.
;
	HIHEADER	"B/SCR", BSCR, DOCON
	.data.l	DISK_BUFFER_COUNT


; TIB     ( --- vadr )    Terminal Input Buffer address.  
;         Note that this is a USER variable, so users may allocate their own
;         buffers, but it must be @ed.
;
	HIHEADER	"TIB", TIB, DOUSER
	.data.l	XTIB


; BLK     ( --- vadr )    Block being interpreted.  Zero refers to the terminal.
;
	HIHEADER	BLK, BLK, DOUSER
	.data.l	XBLK


; IN      ( --- vadr )    Input buffer offset/cursor.
;         Offset of the next byte to be read from the current input device's 
;         currently active buffer -- terminal or disk. 
;
;         The WORD parser uses IN.
;
	HIHEADER	IN, IN, DOUSER
	.data.l	XIN


; OUT     ( --- vadr )    Output buffer offset/cursor.
;         EMIT alters this. May be used to control display formatting.
;
	HIHEADER	OUT, OUT, DOUSER
	.data.l	XOUT


; SCR     ( --- vadr )    Current screen being edited or LISTed, etc.
;
	HIHEADER	SCR, SCR, DOUSER
	.data.l	XSCR


; OFFSET  ( --- vadr )    Sector offset to BLOCK, particularly for LOADing screens, 
;         set by DR0 or DR1 to make a new drive the default.
;
;         Does not affect MESSAGE, etc. 
;
	HIHEADER	OFFSET, OFSET, DOUSER
	.data.l	XOFSET


; R#      ( --- vadr )
;         Editing cursor location, maybe.
; 
	HIHEADER	"R#", RNUM, DOUSER
	.data.l	XRNUM


; COLUMNS ( --- 32 )
;         The number of columns per line on the CRT.
;         Determines the length of error messages and the
;         width and length of screen listings, among other things.
;         Not in fig, but in 6800 model.
;
	HIHEADER	COLUMNS, COLUMS, DOUSER
	.data.l	XCOLUM

