﻿﻿/******************************************************************************
 プロジェクト: loxXmlUtils
 ライセンス: MIT License (http://opensource.org/licenses/mit-license.php)
   http://sourceforge.jp/projects/opensource/wiki/licenses%2FMIT_license
 *****************************************************************************/
/******************************************************************************
 Copyright (c) 2012-2015 synctam

 Permission is hereby granted, free of charge, to any person obtaining a copy of
 this software and associated documentation files (the "Software"), to deal in
 the Software without restriction, including without limitation the rights to
 use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 of the Software, and to permit persons to whom the Software is furnished to do
 so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *****************************************************************************/
using MonoOptions;
using System;
using System.Diagnostics;

namespace loxXmlUtils
{
    class Program
    {
        static void PrintUsage()
        {
            Console.WriteLine("Usage: loxXmlUtils -t English | Japanese");
            Console.WriteLine(" -t: MOD作成タイプ");
            Console.WriteLine("   English 固有名詞英語版");
            Console.WriteLine("   Japanese 固有名詞日本語版");
            Console.WriteLine(" -m: 実行区分");
            Console.WriteLine("   prod 本番用");
            Console.WriteLine("   test テスト用");
            Console.WriteLine("example");
            Console.WriteLine("  loxXmlUtils -t English");
        }
        static int Main(string[] args)
        {
            TJxFlashCard.TConvertMode ConverMode = TJxFlashCard.TConvertMode.ProperNounEnglish;

            try {
                TJxCommon.TRunMode RunMode = new TJxCommon.TRunMode();

                TOptions opt = new TOptions(args);
                if (opt.Options.ModType == null) {
                    Console.WriteLine("翻訳オプション(-t)を指定してください。");
                    opt.ShowUsage();
                    pause();
                    return 1;
                } else if (opt.Options.RunMode == null) {
                    Console.WriteLine("実行モードオプション(-m)を指定してください。");
                    opt.ShowUsage();
                    pause();
                    return 1;
                } else {
                    switch (opt.Options.ModType.ToLower()) {
                        case "english":
                            ConverMode = TJxFlashCard.TConvertMode.ProperNounEnglish;
                            break;
                        case "japanese":
                            ConverMode = TJxFlashCard.TConvertMode.ProperNounJapanese;
                            break;
                        default:
                            Console.WriteLine("オプションエラー：{0}", args[0]);
                            opt.ShowUsage();
                            pause();
                            return 1;
                    }
                    switch (opt.Options.RunMode.ToLower()) {
                        case "prod":
                            RunMode.RunMode = TJxCommon.TRunMode.ERunMode.Prod;
                            break;
                        case "test":
                            RunMode.RunMode = TJxCommon.TRunMode.ERunMode.Test;
                            break;
                        default:
                            Console.WriteLine("実行モード(-m)オプションエラー：{0}", args[0]);
                            opt.ShowUsage();
                            pause();
                            return 1;
                    }
                }

                // Googleドキュメントを直接読み込む場合は以下の４変数に値をセットすること。CSVから読み込む場合は不要。
                //const string appName = ""; // Googleで設定したAPP名
                //const string user = ""; // Googleで設定したメールアドレス。
                //const string CLIENT_ID = ""; // Googleより取得した Client ID を指定する。
                //const string CLIENT_SECRET = ""; // Googleより取得した Client Secret を指定する。

                TJxFlashCard FlashCard = new TJxFlashCard();
                FlashCard.loadFromCsv(@"data\GoogleDocs\FlashCard\loxJpMod_翻訳シート - 固有名詞単語帳.csv"); // CSVから読み込む。
                //FlashCard.loadFromGoogle(appName, user, CLIENT_ID, CLIENT_SECRET, RunMode.BookName); // Googleドキュメントを直接読み込む。
                Console.WriteLine(FlashCard.ProperNounList.Count);


                TJxDlg jxDlg = new TJxDlg();
                jxDlg.FalshCard = FlashCard;
                jxDlg.ConvertMode = ConverMode; // 固有名詞の処理方法を指定する
                jxDlg.loadFromXml(@"data\en.xml\SOL_EN.jxdlg.xml");
                jxDlg.makeGoogleTransCsvList(@"data\GoogleDocs\trans\loxJpMod_翻訳シート - SOL_EN.jxdlg.csv"); // CSVから読み込む。
                jxDlg.saveToCsv(@"data\GoogleDocs\upload\SOL_EN.jxdlg.csv");
                //jxDlg.makeGoogleTransList(appName, user, CLIENT_ID, CLIENT_SECRET, RunMode.BookName); // Googleドキュメントを直接読み込む。
                jxDlg.saveToXml(@"data\jp.xml\SOL_EN.jxdlg");

                TJxJou jxJou = new TJxJou();
                jxJou.FalshCard = FlashCard;
                jxJou.ConvertMode = ConverMode;
                jxJou.loadFromXml(@"data\en.xml\SOL_EN.jxjou.xml");
                jxJou.makeGoogleTransCsvList(@"data\GoogleDocs\trans\loxJpMod_翻訳シート - SOL_EN.jxjou.csv"); // CSVから読み込む。
                jxJou.saveToCsv(@"data\GoogleDocs\upload\SOL_EN.jxjou.csv");
                //jxJou.makeGoogleTransList(appName, user, CLIENT_ID, CLIENT_SECRET, RunMode.BookName); // Googleドキュメントを直接読み込む。
                jxJou.saveToXml(@"data\jp.xml\SOL_EN.jxjou");

                TJxInt jxInt = new TJxInt();
                jxInt.FalshCard = FlashCard;
                jxInt.ConvertMode = ConverMode;
                jxInt.loadFromXml(@"data\en.xml\SOL_EN.jxint.xml");
                jxInt.makeGoogleTransCsvList(@"data\GoogleDocs\trans\loxJpMod_翻訳シート - SOL_EN.jxint.csv"); // CSVから読み込む。
                jxInt.saveToCsv(@"data\GoogleDocs\upload\SOL_EN.jxint.csv");
                //jxInt.makeGoogleTransList(appName, user, CLIENT_ID, CLIENT_SECRET, RunMode.BookName); // Googleドキュメントを直接読み込む。
                jxInt.saveToXml(@"data\jp.xml\SOL_EN.jxint");

                TJxRul jxRul = new TJxRul();
                jxRul.FalshCard = FlashCard;
                jxRul.ConvertMode = ConverMode;
                jxRul.loadFromXml(@"data\en.xml\SOL.jxrul.xml");
                jxRul.makeGoogleTransCsvList(@"data\GoogleDocs\trans\loxJpMod_翻訳シート - SOL.jxrul.csv"); // CSVから読み込む。
                jxRul.saveToCsv(@"data\GoogleDocs\upload\SOL_EN.jxrul.csv");
                //jxRul.makeGoogleTransList(appName, user, CLIENT_ID, CLIENT_SECRET, RunMode.BookName); // Googleドキュメントを直接読み込む。
                jxRul.saveToXml(@"data\jp.xml\SOL.jxrul");
                //jxRul.saveToCsv(@"data\upload\SOL.jxrul.csv");

                //TJxSol jxSol = new TJxSol();
                //jxSol.FalshCard = FlashCard;
                //jxSol.ConvertMode = ConverMode;
                //jxSol.loadFromXml(@"data\en.xml\SOL.xml");
                //jxSol.makeGoogleTransCsvList(@"data\GoogleDocs\trans\loxJpMod_翻訳シート - SOL.csv");
                //jxSol.makeGoogleTransList(@"loxJpMod_翻訳シート(不要分)", @"SOL");
                //jxSol.saveToXml(@"data\jp.xml\SOL");

                pause();
                return 0;
            }
            catch (Exception ex) {
                Console.WriteLine(ex.StackTrace);
                Console.WriteLine("{0}", ex.Message);

                pause();
                return 1;
            }
        }

        static void pause(string msg = "hit enter key")
        {
            if (Debugger.IsAttached) {
                Console.Write(msg);
                Console.Read();
            }
        }
    }
}
