﻿﻿/******************************************************************************
 プロジェクト: loxXmlUtils
 ライセンス: MIT License (http://opensource.org/licenses/mit-license.php)
   http://sourceforge.jp/projects/opensource/wiki/licenses%2FMIT_license
 *****************************************************************************/
/******************************************************************************
 Copyright (c) 2012-2015 synctam

 Permission is hereby granted, free of charge, to any person obtaining a copy of
 this software and associated documentation files (the "Software"), to deal in
 the Software without restriction, including without limitation the rights to
 use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 of the Software, and to permit persons to whom the Software is furnished to do
 so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *****************************************************************************/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace loxXmlUtils
{
    public class TJxCommon
    {
        const string BOOK_NAME_PROD = "loxJpMod_翻訳シート";
        const string BOOK_NAME_TEST = "loxJpMod_翻訳シート - TEST";
        public const string BOOK_NAME = BOOK_NAME_TEST;

        public class TRunMode
        {
            public enum ERunMode
            {
                Prod,
                Test,
            }

            private string FBookName = BOOK_NAME_PROD;
            public string BookName { get { return this.FBookName; } }

            private ERunMode FRunMode = ERunMode.Prod;
            public ERunMode RunMode { get { return this.FRunMode;} set { setRunMode(value); } }
            private void setRunMode(ERunMode value)
            {
                this.FRunMode = value;
                switch (value) {
                    case ERunMode.Prod:
                        this.FBookName = BOOK_NAME_PROD;
                        break;
                    case ERunMode.Test:
                        this.FBookName = BOOK_NAME_TEST;
                        break;
                    default:
                        throw new Exception(string.Format("unknown RunMode({0})", value.ToString()));
                }
            }

        }

        static public string EscapeControlChar(string Text)
        {
            if (Text == null) {
                return null;
            }

            StringBuilder result = new StringBuilder(Text.Length + 32);
            result.Append(Text);
            result.Replace("\r\n", "<CRLF>");
            result.Replace("\n", "<LF>");
            result.Replace("\t", "<TAB>");

            return result.ToString();
        }

        static public string unEscapeControlChar(string Text)
        {
            if (Text == null) {
                return null;
            }

            StringBuilder result = new StringBuilder(Text.Length + 32);
            result.Append(Text);
            result.Replace("<CRLF>", "\r\n");
            result.Replace("<LF>", "\n");
            result.Replace("<TAB>", "\t");

            return result.ToString();
        }

        /// <summary>
        /// 指定した文字列内の指定した文字列を別の文字列に置換する。
        /// </summary>
        /// <param name="input">置換する文字列のある文字列。</param>
        /// <param name="oldValue">検索文字列。</param>
        /// <param name="newValue">置換文字列。</param>
        /// <param name="count">置換する回数。負の数が指定されたときは、すべて置換する。</param>
        /// <param name="compInfo">文字列の検索に使用するCompareInfo。</param>
        /// <param name="compOptions">文字列の検索に使用するCompareOptions。</param>
        /// <returns>置換された結果の文字列。</returns>
        public static string StringReplace(
            string input, string oldValue, string newValue, int count,
            System.Globalization.CompareInfo compInfo,
            System.Globalization.CompareOptions compOptions)
        {
            if (input == null || input.Length == 0 ||
                oldValue == null || oldValue.Length == 0 ||
                count == 0) {
                return input;
            }

            if (compInfo == null) {
                compInfo = System.Globalization.CultureInfo.InvariantCulture.CompareInfo;
                compOptions = System.Globalization.CompareOptions.Ordinal;
            }

            int inputLen = input.Length;
            int oldValueLen = oldValue.Length;
            System.Text.StringBuilder buf = new System.Text.StringBuilder(inputLen);

            int currentPoint = 0;
            int foundPoint = -1;
            int currentCount = 0;

            do {
                //文字列を検索する
                foundPoint = compInfo.IndexOf(input, oldValue, currentPoint, compOptions);
                if (foundPoint < 0) {
                    buf.Append(input.Substring(currentPoint));
                    break;
                }

                //見つかった文字列を新しい文字列に換える
                buf.Append(input.Substring(currentPoint, foundPoint - currentPoint));
                buf.Append(newValue);

                //次の検索開始位置を取得
                currentPoint = foundPoint + oldValueLen;

                //指定回数置換したか調べる
                currentCount++;
                if (currentCount == count) {
                    buf.Append(input.Substring(currentPoint));
                    break;
                }
            }
            while (currentPoint < inputLen);

            return buf.ToString();
        }
        //*********************************************************************************************************
        //*********************************************************************************************************
        /// <summary>
        /// 指定した文字列内の指定した文字列を別の文字列に置換する。
        /// </summary>
        /// <param name="input">置換する文字列のある文字列。</param>
        /// <param name="oldValue">検索文字列。</param>
        /// <param name="newValue">置換文字列。</param>
        /// <param name="count">置換する回数。負の数が指定されたときは、すべて置換する。</param>
        /// <param name="ignoreCase">大文字と小文字を区別しない時はTrue。</param>
        /// <returns>置換された結果の文字列。</returns>
        public static string StringReplace(
            string input, string oldValue, string newValue, int count, bool ignoreCase)
        {
            if (ignoreCase) {
                return StringReplace(input, oldValue, newValue, count,
                    System.Globalization.CultureInfo.InvariantCulture.CompareInfo,
                    System.Globalization.CompareOptions.OrdinalIgnoreCase);
            } else {
                return StringReplace(input, oldValue, newValue, count,
                    System.Globalization.CultureInfo.InvariantCulture.CompareInfo,
                    System.Globalization.CompareOptions.Ordinal);
            }
        }

        /// <summary>
        /// 指定した文字列内の指定した文字列を別の文字列に置換する。
        /// </summary>
        /// <param name="input">置換する文字列のある文字列。</param>
        /// <param name="oldValue">検索文字列。</param>
        /// <param name="newValue">置換文字列。</param>
        /// <param name="count">置換する回数。負の数が指定されたときは、すべて置換する。</param>
        /// <returns>置換された結果の文字列。</returns>
        public static string StringReplace(
            string input, string oldValue, string newValue, int count)
        {
            return StringReplace(input, oldValue, newValue, count,
                System.Globalization.CultureInfo.InvariantCulture.CompareInfo,
                System.Globalization.CompareOptions.Ordinal);
        }
        //*********************************************************************************************************
        //*********************************************************************************************************
    }
}
