﻿﻿/******************************************************************************
 プロジェクト: loxXmlUtils
 ライセンス: MIT License (http://opensource.org/licenses/mit-license.php)
   http://sourceforge.jp/projects/opensource/wiki/licenses%2FMIT_license
 *****************************************************************************/
/******************************************************************************
 Copyright (c) 2012-2015 synctam

 Permission is hereby granted, free of charge, to any person obtaining a copy of
 this software and associated documentation files (the "Software"), to deal in
 the Software without restriction, including without limitation the rights to
 use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 of the Software, and to permit persons to whom the Software is furnished to do
 so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *****************************************************************************/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace loxXmlUtils
{
    public class TJxRulItemUtils
    {
        public static TJxRulItemBase makeJxRulItem(string Category)
        {
            TJxRulItemBase obj = null;
            switch (Category) {
                case "Accessories": // 1
                    obj = new TJxRulItemAccessories(Category);
                    break;
                case "Armours": // 2
                    obj = new TJxRulItemArmours(Category);
                    break;
                case "Classes": // 3
                    obj = new TJxRulItemClasses(Category);
                    break;
                case "Consumables": // 4
                    obj = new TJxRulItemConsumables(Category);
                    break;
                case "Enchantments": // 5
                    obj = new TJxRulItemEnchantments(Category);
                    break;
                case "Enemies": // 6
                    obj = new TJxRulItemEnemies(Category);
                    break;
                case "Global": // 7
                    obj = new TJxRulItemGlobal(Category);
                    break;
                case "Heralds": // 8
                    obj = new TJxRulItemHeralds(Category);
                    break;
                case "ItemGroups": // 9
                    obj = new TJxRulItemItemGroups(Category);
                    break;
                case "Missions": // 10
                    obj = new TJxRulItemMissions(Category);
                    break;
                case "Monsters": // 11
                    obj = new TJxRulItemMonsters(Category);
                    break;
                case "MonsterSkills": // 12
                    obj = new TJxRulItemMonsterSkills(Category);
                    break;
                case "MPBase": // 13
                    obj = new TJxRulItemMPBase(Category);
                    break;
                case "MPFactor": // 14
                    obj = new TJxRulItemMPFactor(Category);
                    break;
                case "MPPerLevel": // 15
                    obj = new TJxRulItemMPPerLevel(Category);
                    break;
                case "PowerFactor": // 16
                    obj = new TJxRulItemPowerFactor(Category);
                    break;
                case "Qualities": // 17
                    obj = new TJxRulItemQualities(Category);
                    break;
                case "Questions": // 18
                    obj = new TJxRulItemQuestions(Category);
                    break;
                case "RandomContainers": // 19
                    obj = new TJxRulItemRandomContainers(Category);
                    break;
                case "SkillGroups": // 20
                    obj = new TJxRulItemSkillGroups(Category);
                    break;
                case "Skills": // 21
                    obj = new TJxRulItemSkills(Category);
                    break;
                case "SpecialItems": // 22
                    obj = new TJxRulItemSpecialItems(Category);
                    break;
                case "Terrains": // 23
                    obj = new TJxRulItemTerrains(Category);
                    break;
                case "Weapons": // 24
                    obj = new TJxRulItemWeapons(Category);
                    break;
                case "Zones": // 25
                    obj = new TJxRulItemZones(Category);
                    break;
                case "WeaponsPrint_Area": // 26
                    obj = new TJxRulItemWeaponsPrint_Area(Category);
                    break;
                default:
                    throw new Exception(string.Format("unknown Category1=({0})", Category));
            }
            return obj;
        }
    }
    /// <summary>
    /// 01.Accessories
    /// </summary>
    public class TJxRulItemAccessories : TJxRulItemBase // 1
    {
        public TJxRulItemAccessories(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            string ID = this.ItemDetailList[0];
            string Name = this.ItemDetailList[4];
            string Description = this.ItemDetailList[14];
            return string.Format("Category={0} ID={1} Name={2}", Category, ID, Name);
        }
        public override Dictionary<string, string> ToDictionary()
        {
            Dictionary<string, string> dict = new Dictionary<string, string>();
            dict.Add("Category", Category);
            dict.Add("ID", this.ItemDetailList[0]);
            dict.Add("Name", this.ItemDetailList[4]);
            dict.Add("Description", this.ItemDetailList[14]);
            return dict;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Name", this.ItemDetailList[4]); csvList.Add(data1);
            TJxCsvData data2 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Description", this.ItemDetailList[14]); csvList.Add(data2);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                case 4:
                case 14:
                    return true;
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 02.Armours
    /// </summary>
    public class TJxRulItemArmours : TJxRulItemBase // 2
    {
        public TJxRulItemArmours(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            string ID = this.ItemDetailList[0];
            string Name = this.ItemDetailList[4];
            string Description = this.ItemDetailList[18];
            return string.Format("Category={0} ID={1} Name={2}", Category, ID, Name);
        }
        public override Dictionary<string, string> ToDictionary()
        {
            Dictionary<string, string> dict = new Dictionary<string, string>();
            dict.Add("Category", Category);
            dict.Add("ID", this.ItemDetailList[0]);
            dict.Add("Name", this.ItemDetailList[4]);
            dict.Add("Description", this.ItemDetailList[18]);
            return dict;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Name", this.ItemDetailList[4]); csvList.Add(data1);
            TJxCsvData data2 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Description", this.ItemDetailList[18]); csvList.Add(data2);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                case 4:
                case 18:
                    return true;
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 03.Classes
    /// </summary>
    public class TJxRulItemClasses : TJxRulItemBase // 3
    {
        public TJxRulItemClasses(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            string ID = this.ItemDetailList[0];
            string Name = this.ItemDetailList[3];
            string Description = this.ItemDetailList[33];
            return string.Format("Category={0} ID={1} Name={2} Description={3}", Category, ID, Name, Description);
        }
        public override Dictionary<string, string> ToDictionary()
        {
            Dictionary<string, string> dict = new Dictionary<string, string>();
            dict.Add("Category", Category);
            dict.Add("ID", this.ItemDetailList[0]);
            dict.Add("Name", this.ItemDetailList[3]);
            dict.Add("Description", this.ItemDetailList[33]);
            return dict;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Name", this.ItemDetailList[3]); csvList.Add(data1);
            TJxCsvData data2 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Description", this.ItemDetailList[33]); csvList.Add(data2);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                case 3:
                case 33:
                    return true;
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 04.Consumables
    /// </summary>
    public class TJxRulItemConsumables : TJxRulItemBase // 4
    {
        public TJxRulItemConsumables(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            string ID = this.ItemDetailList[0];
            string Name = this.ItemDetailList[4];
            string Description = this.ItemDetailList[24];
            return string.Format("Category={0} ID={1} Name={2} Description={3}", Category, ID, Name, Description);
        }
        public override Dictionary<string, string> ToDictionary()
        {
            Dictionary<string, string> dict = new Dictionary<string, string>();
            dict.Add("Category", Category);
            dict.Add("ID", this.ItemDetailList[0]);
            dict.Add("Name", this.ItemDetailList[4]);
            dict.Add("Description", this.ItemDetailList[24]);
            return dict;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Name", this.ItemDetailList[4]); csvList.Add(data1);
            TJxCsvData data2 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Description", this.ItemDetailList[24]); csvList.Add(data2);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                case 4:
                case 24:
                    return true;
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 05.Enchantments
    /// </summary>
    public class TJxRulItemEnchantments : TJxRulItemBase // 5
    {
        public TJxRulItemEnchantments(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            string ID = this.ItemDetailList[0];
            string Name = this.ItemDetailList[4];
            string Description = this.ItemDetailList[47];
            return string.Format("Category={0} ID={1} Name={2}", Category, ID, Name);
        }
        public override Dictionary<string, string> ToDictionary()
        {
            Dictionary<string, string> dict = new Dictionary<string, string>();
            dict.Add("Category", Category);
            dict.Add("ID", this.ItemDetailList[0]);
            dict.Add("Name", this.ItemDetailList[4]);
            dict.Add("Description", this.ItemDetailList[47]);
            return dict;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Name", this.ItemDetailList[4]); csvList.Add(data1);
            TJxCsvData data2 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Description", this.ItemDetailList[47]); csvList.Add(data2);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                case 4:
                case 47:
                    return true;
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 06.Enemies
    /// </summary>
    public class TJxRulItemEnemies : TJxRulItemBase // 6
    {
        public TJxRulItemEnemies(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            string ID = this.ItemDetailList[0];
            string Name = this.ItemDetailList[2];
            return string.Format("Category={0} ID={1} Name={2}", Category, ID, Name);
        }
        public override Dictionary<string, string> ToDictionary()
        {
            Dictionary<string, string> dict = new Dictionary<string, string>();
            dict.Add("Category", Category);
            dict.Add("ID", this.ItemDetailList[0]);
            dict.Add("Name", this.ItemDetailList[2]);
            return dict;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Name", this.ItemDetailList[2]); csvList.Add(data1);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                case 2:
                    return true;
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 07.Global
    /// </summary>
    public class TJxRulItemGlobal : TJxRulItemBase // 7
    {
        public TJxRulItemGlobal(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            string ID = this.ItemDetailList[0];
            string Description = this.ItemDetailList[6];
            return string.Format("Category={0} ID={1} Description={2}", Category, ID, Description);
        }
        public override Dictionary<string, string> ToDictionary()
        {
            Dictionary<string, string> dict = new Dictionary<string, string>();
            dict.Add("Category", Category);
            dict.Add("ID", this.ItemDetailList[0]);
            dict.Add("Description", this.ItemDetailList[6]);
            return dict;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Description", this.ItemDetailList[6]); csvList.Add(data1);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                case 6:
                    return true;
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 08.Heralds
    /// </summary>
    public class TJxRulItemHeralds : TJxRulItemBase // 8
    {
        public TJxRulItemHeralds(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            return "";
        }
        public override Dictionary<string, string> ToDictionary()
        {
            return null;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData("", "", "", ""); csvList.Add(data1);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 09.ItemGroups
    /// </summary>
    public class TJxRulItemItemGroups : TJxRulItemBase // 9
    {
        public TJxRulItemItemGroups(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            string ID = this.ItemDetailList[0];
            string Name = this.ItemDetailList[3];
            string Description = this.ItemDetailList[8];
            return string.Format("Category={0} ID={1} Name={2}", Category, ID, Name);
        }
        public override Dictionary<string, string> ToDictionary()
        {
            Dictionary<string, string> dict = new Dictionary<string, string>();
            dict.Add("Category", Category);
            dict.Add("ID", this.ItemDetailList[0]);
            dict.Add("Name", this.ItemDetailList[3]);
            dict.Add("Description", this.ItemDetailList[8]);
            return dict;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Name", this.ItemDetailList[3]); csvList.Add(data1);
            TJxCsvData data2 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Description", this.ItemDetailList[8]); csvList.Add(data2);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                case 3:
                case 8:
                    return true;
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 10.Missions
    /// </summary>
    public class TJxRulItemMissions : TJxRulItemBase // 10
    {
        public TJxRulItemMissions(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            string ID = this.ItemDetailList[0];
            string Name = this.ItemDetailList[3];
            string Description = this.ItemDetailList[18];
            string WinResult = this.ItemDetailList[23];
            string FailedResult = this.ItemDetailList[27];
            return string.Format("Category={0} ID={1} Name={2} Description={3} WinResult={4} FailedResult={5}", Category, ID, Name, Description, WinResult, FailedResult);
        }
        public override Dictionary<string, string> ToDictionary()
        {
            Dictionary<string, string> dict = new Dictionary<string, string>();
            dict.Add("Category", Category);
            dict.Add("ID", this.ItemDetailList[0]);
            dict.Add("Name", this.ItemDetailList[3]);
            dict.Add("Description", this.ItemDetailList[18]);
            dict.Add("WinResult", this.ItemDetailList[23]);
            dict.Add("FailedResult", this.ItemDetailList[27]);
            return dict;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Name", this.ItemDetailList[3]); csvList.Add(data1);
            TJxCsvData data2 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Description", this.ItemDetailList[18]); csvList.Add(data2);
            TJxCsvData data3 = this.makeCsvData(this.Category, this.ItemDetailList[0], "WinResult", this.ItemDetailList[23]); csvList.Add(data3);
            TJxCsvData data4 = this.makeCsvData(this.Category, this.ItemDetailList[0], "FailedResult", this.ItemDetailList[27]); csvList.Add(data4);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                case 3:
                case 18:
                case 23:
                case 27:
                    return true;
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 11.Monsters
    /// </summary>
    public class TJxRulItemMonsters : TJxRulItemBase // 11
    {
        public TJxRulItemMonsters(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            string ID = this.ItemDetailList[0];
            string Name = this.ItemDetailList[6];
            string Description_EN = this.ItemDetailList[42];
            return string.Format("Category={0} ID={1} Name={2} Description_EN={3}", Category, ID, Name, Description_EN);
        }
        public override Dictionary<string, string> ToDictionary()
        {
            Dictionary<string, string> dict = new Dictionary<string, string>();
            dict.Add("Category", Category);
            dict.Add("ID", this.ItemDetailList[0]);
            dict.Add("Name", this.ItemDetailList[6]);
            dict.Add("Description", this.ItemDetailList[42]);
            return dict;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Name", this.ItemDetailList[6]); csvList.Add(data1);
            TJxCsvData data2 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Description", this.ItemDetailList[42]); csvList.Add(data2);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                case 6:
                case 42:
                    return true;
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 12.MonsterSkills
    /// </summary>
    public class TJxRulItemMonsterSkills : TJxRulItemBase // 12
    {
        public TJxRulItemMonsterSkills(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            string ID = this.ItemDetailList[0];
            string Name = this.ItemDetailList[3];
            string Description = this.ItemDetailList[31];
            return string.Format("Category={0} ID={1} Name={2} Description={3}", Category, ID, Name, Description);
        }
        public override Dictionary<string, string> ToDictionary()
        {
            Dictionary<string, string> dict = new Dictionary<string, string>();
            dict.Add("Category", Category);
            dict.Add("ID", this.ItemDetailList[0]);
            dict.Add("Name", this.ItemDetailList[3]);
            dict.Add("Description", this.ItemDetailList[31]);
            return dict;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Name", this.ItemDetailList[3]); csvList.Add(data1);
            TJxCsvData data2 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Description", this.ItemDetailList[31]); csvList.Add(data2);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                case 3:
                case 31:
                    return true;
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 13.MPBase
    /// </summary>
    public class TJxRulItemMPBase : TJxRulItemBase // 13
    {
        public TJxRulItemMPBase(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            return "";
        }
        public override Dictionary<string, string> ToDictionary()
        {
            return null;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData("", "", "", ""); csvList.Add(data1);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 14.MPFactor
    /// </summary>
    public class TJxRulItemMPFactor : TJxRulItemBase // 14
    {
        public TJxRulItemMPFactor(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            return "";
        }
        public override Dictionary<string, string> ToDictionary()
        {
            return null;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData("", "", "", ""); csvList.Add(data1);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 15.MPPerLevel
    /// </summary>
    public class TJxRulItemMPPerLevel : TJxRulItemBase // 15
    {
        public TJxRulItemMPPerLevel(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            return "";
        }
        public override Dictionary<string, string> ToDictionary()
        {
            return null;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData("", "", "", ""); csvList.Add(data1);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 16.PowerFactor
    /// </summary>
    public class TJxRulItemPowerFactor : TJxRulItemBase // 16
    {
        public TJxRulItemPowerFactor(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            return "";
        }
        public override Dictionary<string, string> ToDictionary()
        {
            return null;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData("", "", "", ""); csvList.Add(data1);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 17.Qualities
    /// </summary>
    public class TJxRulItemQualities : TJxRulItemBase // 17
    {
        public TJxRulItemQualities(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            string ID = this.ItemDetailList[0];
            string Metal = this.ItemDetailList[6];
            string Wood = this.ItemDetailList[11];
            string Leather = this.ItemDetailList[16];
            string Cloth = this.ItemDetailList[21];
            string Mineral = this.ItemDetailList[26];
            string Description = this.ItemDetailList[31];
            return string.Format("Category={0} ID={1} Metal={2} Cloth={3} Mineral={4} Description={5}", Category, ID, Metal, Cloth, Mineral, Description);
        }
        public override Dictionary<string, string> ToDictionary()
        {
            Dictionary<string, string> dict = new Dictionary<string, string>();
            dict.Add("Category", Category);
            dict.Add("ID", this.ItemDetailList[0]);
            dict.Add("Metal", this.ItemDetailList[6]);
            dict.Add("Wood", this.ItemDetailList[11]);
            dict.Add("Leather", this.ItemDetailList[16]);
            dict.Add("Cloth", this.ItemDetailList[21]);
            dict.Add("Mineral", this.ItemDetailList[26]);
            dict.Add("Description", this.ItemDetailList[31]);
            return dict;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Metal", this.ItemDetailList[6]); csvList.Add(data1);
            TJxCsvData data2 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Wood", this.ItemDetailList[11]); csvList.Add(data2);
            TJxCsvData data3 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Leather", this.ItemDetailList[16]); csvList.Add(data3);
            TJxCsvData data4 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Cloth", this.ItemDetailList[21]); csvList.Add(data4);
            TJxCsvData data5 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Mineral", this.ItemDetailList[26]); csvList.Add(data5);
            TJxCsvData data6 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Description", this.ItemDetailList[31]); csvList.Add(data6);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                case 6:
                case 11:
                case 16:
                case 21:
                case 26:
                case 31:
                    return true;
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 18.Questions
    /// </summary>
    public class TJxRulItemQuestions : TJxRulItemBase // 18
    {
        public TJxRulItemQuestions(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            string ID = this.ItemDetailList[0];
            string Question = this.ItemDetailList[3];
            string Answer = this.ItemDetailList[4];
            return string.Format("Category1={0} ID={1} Question={2} Answer={3}", Category, ID, Question, Answer);
        }
        public override Dictionary<string, string> ToDictionary()
        {
            Dictionary<string, string> dict = new Dictionary<string, string>();
            dict.Add("Category", Category);
            dict.Add("ID", this.ItemDetailList[0]);
            dict.Add("Question", this.ItemDetailList[3]);
            dict.Add("Answer", this.ItemDetailList[4]);
            return dict;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Question", this.ItemDetailList[3]); csvList.Add(data1);
            TJxCsvData data2 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Answer", this.ItemDetailList[4]); csvList.Add(data2);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                case 3:
                case 4:
                    return true;
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 19.RandomContainers
    /// </summary>
    public class TJxRulItemRandomContainers : TJxRulItemBase // 19
    {
        public TJxRulItemRandomContainers(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            return "";
        }
        public override Dictionary<string, string> ToDictionary()
        {
            return null;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData("", "", "", ""); csvList.Add(data1);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 20.SkillGroups
    /// </summary>
    public class TJxRulItemSkillGroups : TJxRulItemBase // 20
    {
        public TJxRulItemSkillGroups(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            string ID = this.ItemDetailList[0];
            string Name = this.ItemDetailList[3];
            string Description = this.ItemDetailList[11];
            return string.Format("Category={0} ID={1} Name={2} Description={3}", Category, ID, Name, Description);
        }
        public override Dictionary<string, string> ToDictionary()
        {
            Dictionary<string, string> dict = new Dictionary<string, string>();
            dict.Add("Category", Category);
            dict.Add("ID", this.ItemDetailList[0]);
            dict.Add("Name", this.ItemDetailList[3]);
            dict.Add("Description", this.ItemDetailList[11]);
            return dict;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Name", this.ItemDetailList[3]); csvList.Add(data1);
            TJxCsvData data2 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Description", this.ItemDetailList[11]); csvList.Add(data2);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                case 3:
                case 11:
                    return true;
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 21.Skills
    /// </summary>
    public class TJxRulItemSkills : TJxRulItemBase // 21
    {
        public TJxRulItemSkills(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            string ID = this.ItemDetailList[0];
            string Name = this.ItemDetailList[6];
            string Description = this.ItemDetailList[44];
            return string.Format("Category={0} ID={1} Name={2} Description={3}", Category, ID, Name, Description);
        }
        public override Dictionary<string, string> ToDictionary()
        {
            Dictionary<string, string> dict = new Dictionary<string, string>();
            dict.Add("Category", Category);
            dict.Add("ID", this.ItemDetailList[0]);
            dict.Add("Name", this.ItemDetailList[6]);
            dict.Add("Description", this.ItemDetailList[44]);
            return dict;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Name", this.ItemDetailList[6]); csvList.Add(data1);
            TJxCsvData data2 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Description", this.ItemDetailList[44]); csvList.Add(data2);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                case 6:
                case 44:
                    return true;
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 22.SpecialItems
    /// </summary>
    public class TJxRulItemSpecialItems : TJxRulItemBase // 22
    {
        public TJxRulItemSpecialItems(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            string ID = this.ItemDetailList[0];
            string Name = this.ItemDetailList[2];
            string Description = this.ItemDetailList[13];
            return string.Format("Category={0} ID={1} Name={2} Description={3}", Category, ID, Name, Description);
        }
        public override Dictionary<string, string> ToDictionary()
        {
            Dictionary<string, string> dict = new Dictionary<string, string>();
            dict.Add("Category", Category);
            dict.Add("ID", this.ItemDetailList[0]);
            dict.Add("Name", this.ItemDetailList[2]);
            dict.Add("Description", this.ItemDetailList[13]);
            return dict;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Name", this.ItemDetailList[2]); csvList.Add(data1);
            TJxCsvData data2 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Description", this.ItemDetailList[13]); csvList.Add(data2);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                case 2:
                case 13:
                    return true;
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 23.Terrains
    /// </summary>
    public class TJxRulItemTerrains : TJxRulItemBase // 23
    {
        public TJxRulItemTerrains(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            string ID = this.ItemDetailList[0];
            string Name = this.ItemDetailList[2];
            string Description = this.ItemDetailList[16];
            return string.Format("Category={0} ID={1} Name={2} Description={3}", Category, ID, Name, Description);
        }
        public override Dictionary<string, string> ToDictionary()
        {
            Dictionary<string, string> dict = new Dictionary<string, string>();
            dict.Add("Category", Category);
            dict.Add("ID", this.ItemDetailList[0]);
            dict.Add("Name", this.ItemDetailList[2]);
            dict.Add("Description", this.ItemDetailList[16]);
            return dict;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Name", this.ItemDetailList[2]); csvList.Add(data1);
            TJxCsvData data2 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Description", this.ItemDetailList[16]); csvList.Add(data2);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                case 2:
                case 16:
                    return true;
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 24.Weapons
    /// </summary>
    public class TJxRulItemWeapons : TJxRulItemBase // 24
    {
        public TJxRulItemWeapons(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            string ID = this.ItemDetailList[0];
            string Name = this.ItemDetailList[4];
            string Description = this.ItemDetailList[29];
            return string.Format("Category={0} ID={1} Name={2} Description={3}", Category, ID, Name, Description);
        }
        public override Dictionary<string, string> ToDictionary()
        {
            Dictionary<string, string> dict = new Dictionary<string, string>();
            dict.Add("Category", Category);
            dict.Add("ID", this.ItemDetailList[0]);
            dict.Add("Name", this.ItemDetailList[4]);
            dict.Add("Description", this.ItemDetailList[29]);
            return dict;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Name", this.ItemDetailList[4]); csvList.Add(data1);
            TJxCsvData data2 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Description", this.ItemDetailList[29]); csvList.Add(data2);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                case 4:
                case 29:
                    return true;
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 25.Zones
    /// </summary>
    public class TJxRulItemZones : TJxRulItemBase // 25
    {
        public TJxRulItemZones(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            string ID = this.ItemDetailList[0];
            string Name = this.ItemDetailList[2];
            string Description = this.ItemDetailList[34];
            return string.Format("Category={0} ID={1} Name={2} Description={3}", Category, ID, Name, Description);
        }
        public override Dictionary<string, string> ToDictionary()
        {
            Dictionary<string, string> dict = new Dictionary<string, string>();
            dict.Add("Category", Category);
            dict.Add("ID", this.ItemDetailList[0]);
            dict.Add("Name", this.ItemDetailList[2]);
            dict.Add("Description", this.ItemDetailList[34]);
            return dict;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Name", this.ItemDetailList[2]); csvList.Add(data1);
            TJxCsvData data2 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Description", this.ItemDetailList[34]); csvList.Add(data2);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                case 2:
                case 34:
                    return true;
                default:
                    return false;
            }
        }
    }
    /// <summary>
    /// 26.WeaponsPrint_Area
    /// </summary>
    public class TJxRulItemWeaponsPrint_Area : TJxRulItemBase // 26
    {
        public TJxRulItemWeaponsPrint_Area(string Category)
            : base(Category)
        {
        }
        public override string ToString()
        {
            string ID = this.ItemDetailList[0];
            string Name = this.ItemDetailList[4];
            return string.Format("Category={0} ID={1} Name={2}", Category, ID, Name);
        }
        public override Dictionary<string, string> ToDictionary()
        {
            Dictionary<string, string> dict = new Dictionary<string, string>();
            dict.Add("Category", Category);
            dict.Add("ID", this.ItemDetailList[0]);
            dict.Add("Name", this.ItemDetailList[4]);
            return dict;
        }
        public override List<TJxCsvData> ToCsv()
        {
            List<TJxCsvData> csvList = new List<TJxCsvData>();
            TJxCsvData data1 = this.makeCsvData(this.Category, this.ItemDetailList[0], "Name", this.ItemDetailList[4]); csvList.Add(data1);
            return csvList;
        }
        public override bool checkID(int no)
        {
            switch (no) {
                case 4:
                    return true;
                default:
                    return false;
            }
        }
    }
}
