﻿﻿/******************************************************************************
 プロジェクト: loxXmlUtils
 ライセンス: MIT License (http://opensource.org/licenses/mit-license.php)
   http://sourceforge.jp/projects/opensource/wiki/licenses%2FMIT_license
 *****************************************************************************/
/******************************************************************************
 Copyright (c) 2012-2015 synctam

 Permission is hereby granted, free of charge, to any person obtaining a copy of
 this software and associated documentation files (the "Software"), to deal in
 the Software without restriction, including without limitation the rights to
 use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 of the Software, and to permit persons to whom the Software is furnished to do
 so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *****************************************************************************/
using Mono.Options;
using System;
using System.Collections.Generic;
using System.IO;

namespace MonoOptions
{
    public class TOptions
    {
        private TMyOptions FMyOptions;
        public TMyOptions Options { get { return this.FMyOptions; } }
        
        private bool FisError = false;
        public bool isError { get { return this.FisError; } }
        private string FErrorMessage = null;
        public string ErrorMessage { get { return this.FErrorMessage;} }

        private OptionSet FOptionSet;

        public class TMyOptions
        {
            public string ModType;
            public string RunMode;
            public bool help;
        }

        public TOptions(string[] arges)
        {
            FMyOptions = new TMyOptions();
            settings(arges);
        }

        private void settings(string[] args)
        {
            this.FOptionSet = new OptionSet()
            {
                {"t=|type=", "t MOD Type.", v => this.FMyOptions.ModType = v},
                {"m=|mode=", "m Run Mode.", v => this.FMyOptions.RunMode = v},
                {"h|help", "show help.", v => this.FMyOptions.help = v != null}
            };

            List<string> extra;
            try {
                extra = this.FOptionSet.Parse(args);
                // 指定されたオプション以外のオプションが指定されていた場合、
                // extra に格納される。
                //extra.ForEach(t => Console.WriteLine(t));
                this.FisError = false;
                this.FErrorMessage = "";
            }
            //パースに失敗した場合OptionExceptionを発生させる
            catch (OptionException e) {
                Console.WriteLine(e.Message);
                this.FisError = true;
                this.FErrorMessage = e.Message;
            }
        }
        // Uasgeを表示する
        public void ShowUsage()
        {
            TextWriter o = Console.Error;
            ShowUsage(o);
        }
        public void ShowUsage(TextWriter o)
        {
            if (o == null) o = Console.Error;
            o.WriteLine("Usage:{0} [OPTIONS]", Path.GetFileName(Environment.GetCommandLineArgs()[0]));
            o.WriteLine();
            this.FOptionSet.WriteOptionDescriptions(o);
        }
    }
}
