using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace LocalMessenger
{
    public delegate void ConfiguredHandler(bool restart);

    public partial class Configure : Form
    {
        public event ConfiguredHandler configured;

        private bool changed = false;

        private bool Changed
        {
            get { return changed; }
            set
            {
                changed = value;
                this.buttonApply.Enabled = changed;
            }
        }

        private bool adapter_changed = false;

        public Configure()
        {
            InitializeComponent();

            textNickName.Text = Properties.Settings.Default.NickName;
            textPortNumber.Text = Properties.Settings.Default.PortNumber.ToString();
            textFolderPath.Text = Properties.Settings.Default.Folder;

            List<NetInfo> infos = NetAdapter.GetNetInfo();
            foreach (NetInfo info in infos){
                comboBoxAdapter.Items.Add(info.Name);
            }
            comboBoxAdapter.SelectedIndex = NetAdapter.GetSelectedIndex(infos);
            Changed = false;
        }

        private void save()
        {
            if (Changed)
            {
                Properties.Settings.Default.NickName = textNickName.Text;
                Properties.Settings.Default.PortNumber = Int32.Parse(textPortNumber.Text);
                Properties.Settings.Default.Folder = textFolderPath.Text;

                Object selectedItem = comboBoxAdapter.SelectedItem;
                Properties.Settings.Default.Adapter = selectedItem.ToString();

                Properties.Settings.Default.Save();
                Changed = false;

                if (configured != null)
                    configured(adapter_changed);
            }
        }

        private void buttonSave_Click(object sender, EventArgs e)
        {
            save();
            DialogResult = DialogResult.OK;
            Close();
        }

        private void buttonCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }

        private void buttonApply_Click(object sender, EventArgs e)
        {
            save();
        }

        private void nickName_TextChanged(object sender, EventArgs e)
        {
            Changed = true;
        }

        // |[gԍ͐̂ݓ͉
        private void portNumber_KeyPress(object sender, KeyPressEventArgs e)
        {
            if ((e.KeyChar < '0' || e.KeyChar > '9') && e.KeyChar != '\b')
                e.Handled = true;
        }

        private void buttonRefer_Click(object sender, EventArgs e)
        {
            FolderBrowserDialog browser = new FolderBrowserDialog();

            browser.Description = "t@C]̕ۑw肵ĉB";
            browser.RootFolder = Environment.SpecialFolder.MyComputer;
            browser.SelectedPath = textFolderPath.Text;
            browser.ShowNewFolderButton = true;

            DialogResult result = browser.ShowDialog();

            if (result == DialogResult.OK)
            {
                textFolderPath.Text = browser.SelectedPath;
                browser.Dispose();
                Changed = true;
            }
        }

        private void comboBoxAdapter_SelectedIndexChanged_1(object sender, EventArgs e)
        {
            adapter_changed = true;
            Changed = true;
        }
    }
}
