using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.Diagnostics;

using System.Collections;

namespace LocalMessenger
{
    public partial class Manager
    {
        private void InitializeListView()
        {
            // ListViewRg[̃vpeBݒ
            listView.FullRowSelect = true;
            listView.GridLines = false;
            listView.Sorting = SortOrder.Ascending;
            listView.View = View.Details;

            imageStatus.Images.Add(Properties.Resources.Status0);
            imageStatus.Images.Add(Properties.Resources.Status1);
            imageStatus.Images.Add(Properties.Resources.Status2);
            imageStatus.Images.Add(Properties.Resources.Status3);
            imageStatus.Images.Add(Properties.Resources.Status4);
            imageStatus.Images.Add(Properties.Resources.Status5);
            imageStatus.Images.Add(Properties.Resources.Status6);
            imageStatus.Images.Add(Properties.Resources.Status7);
            imageStatus.Images.Add(Properties.Resources.Status8);
            imageStatus.Images.Add(Properties.Resources.Status9);

            listView.SmallImageList = imageStatus;

            // iRjwb_̍쐬
            ColumnHeader NickName = new ColumnHeader();
            ColumnHeader Memo = new ColumnHeader();

            NickName.Text = "o[";
            NickName.Width = 128;
            Memo.Text = "";
            Memo.Width = 256;

            ColumnHeader[] colHeaderRegValue = { NickName, Memo };
            listView.Columns.AddRange(colHeaderRegValue);
        }

        private void UpdateListView()
        {
            listView.Items.Clear();

            ArrayList items = new ArrayList();
            ListViewItem item;

            for (int i = 0; i < memberList.Count; i++)
            {
                ContactMember contact = memberList[i];
                // ItC̃o[͕\Ȃ
                if (contact.Member.Status == Member.State.OFFLINE)
                    continue;

                string[] info =
                {
                    contact.Member.NickName,
                    contact.Member.Memo
                };

                item = new ListViewItem(info, (int)contact.Member.Status);
                item.ToolTipText = contact.Member.Name + "@" + contact.Member.Machine
                    + " [" + contact.Member.Address + "] ";
                item.Tag = contact.Member;
                items.Add(item);
            }

            listView.Items.AddRange((ListViewItem[])items.ToArray(typeof(ListViewItem)));
        }
    }
}